/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree.serializer;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.directory.mavibot.btree.comparator.CharArrayComparator;
import org.apache.directory.mavibot.btree.serializer.AbstractElementSerializer;
import org.apache.directory.mavibot.btree.serializer.BufferHandler;
import org.apache.directory.mavibot.btree.serializer.IntSerializer;

public class CharArraySerializer
extends AbstractElementSerializer<char[]> {
    public CharArraySerializer() {
        super(new CharArrayComparator());
    }

    @Override
    public byte[] serialize(char[] element) {
        int len = -1;
        if (element != null) {
            len = element.length;
        }
        byte[] bytes = null;
        switch (len) {
            case 0: {
                bytes = new byte[]{0, 0, 0, 0};
                break;
            }
            case -1: {
                bytes = new byte[]{-1, -1, -1, -1};
                break;
            }
            default: {
                bytes = new byte[len * 2 + 4];
                int pos = 4;
                bytes[0] = (byte)(len >>> 24);
                bytes[1] = (byte)(len >>> 16);
                bytes[2] = (byte)(len >>> 8);
                bytes[3] = (byte)len;
                for (char c : element) {
                    bytes[pos++] = (byte)(c >>> 8);
                    bytes[pos++] = (byte)c;
                }
            }
        }
        return bytes;
    }

    public static char[] deserialize(byte[] in) {
        if (in == null || in.length < 4) {
            throw new RuntimeException("Cannot extract a byte[] from a buffer with not enough bytes");
        }
        int len = IntSerializer.deserialize(in);
        switch (len) {
            case 0: {
                return new char[0];
            }
            case -1: {
                return null;
            }
        }
        char[] result = new char[len];
        for (int i = 4; i < len * 2 + 4; i += 2) {
            result[i] = Character.valueOf((char)((in[i] << 8) + (in[i + 1] & 0xFF))).charValue();
        }
        return result;
    }

    @Override
    public char[] deserialize(BufferHandler bufferHandler) throws IOException {
        byte[] in = bufferHandler.read(4);
        int len = IntSerializer.deserialize(in);
        switch (len) {
            case 0: {
                return new char[0];
            }
            case -1: {
                return null;
            }
        }
        char[] result = new char[len];
        byte[] buffer = bufferHandler.read(len * 2);
        for (int i = 0; i < len * 2; i += 2) {
            result[i] = Character.valueOf((char)((buffer[i] << 8) + (buffer[i + 1] & 0xFF))).charValue();
        }
        return result;
    }

    @Override
    public char[] deserialize(ByteBuffer buffer) throws IOException {
        int len = buffer.getInt();
        switch (len) {
            case 0: {
                return new char[0];
            }
            case -1: {
                return null;
            }
        }
        char[] result = new char[len];
        for (int i = 0; i < len; ++i) {
            result[i] = buffer.getChar();
        }
        return result;
    }
}

