/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.rest.ProtobufMessageHandler;
import org.apache.hadoop.hbase.rest.model.ColumnSchemaModel;
import org.apache.hadoop.hbase.rest.protobuf.generated.ColumnSchemaMessage;
import org.apache.hadoop.hbase.rest.protobuf.generated.TableSchemaMessage;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@XmlRootElement(name="TableSchema")
@InterfaceAudience.Private
public class TableSchemaModel
implements Serializable,
ProtobufMessageHandler {
    private static final long serialVersionUID = 1L;
    private static final QName IS_META = new QName("IS_META");
    private static final QName IS_ROOT = new QName("IS_ROOT");
    private static final QName READONLY = new QName("READONLY");
    private static final QName TTL = new QName("TTL");
    private static final QName VERSIONS = new QName("VERSIONS");
    private static final QName COMPRESSION = new QName("COMPRESSION");
    private String name;
    private Map<QName, Object> attrs = new LinkedHashMap<QName, Object>();
    private List<ColumnSchemaModel> columns = new ArrayList<ColumnSchemaModel>();

    public TableSchemaModel() {
    }

    public TableSchemaModel(HTableDescriptor htd) {
        this.setName(htd.getTableName().getNameAsString());
        for (Map.Entry e : htd.getValues().entrySet()) {
            this.addAttribute(Bytes.toString((byte[])((Bytes)e.getKey()).get()), Bytes.toString((byte[])((Bytes)e.getValue()).get()));
        }
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            ColumnSchemaModel columnModel = new ColumnSchemaModel();
            columnModel.setName(hcd.getNameAsString());
            for (Map.Entry e : hcd.getValues().entrySet()) {
                columnModel.addAttribute(Bytes.toString((byte[])((Bytes)e.getKey()).get()), Bytes.toString((byte[])((Bytes)e.getValue()).get()));
            }
            this.addColumnFamily(columnModel);
        }
    }

    @JsonAnySetter
    public void addAttribute(String name, Object value) {
        this.attrs.put(new QName(name), value);
    }

    public String getAttribute(String name) {
        Object o = this.attrs.get(new QName(name));
        return o != null ? o.toString() : null;
    }

    public void addColumnFamily(ColumnSchemaModel family) {
        this.columns.add(family);
    }

    public ColumnSchemaModel getColumnFamily(int index) {
        return this.columns.get(index);
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    @XmlAnyAttribute
    @JsonAnyGetter
    public Map<QName, Object> getAny() {
        return this.attrs;
    }

    @XmlElement(name="ColumnSchema")
    public List<ColumnSchemaModel> getColumns() {
        return this.columns;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setColumns(List<ColumnSchemaModel> columns) {
        this.columns = columns;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ NAME=> '");
        sb.append(this.name);
        sb.append('\'');
        for (Map.Entry<QName, Object> e : this.attrs.entrySet()) {
            sb.append(", ");
            sb.append(e.getKey().getLocalPart());
            sb.append(" => '");
            sb.append(e.getValue().toString());
            sb.append('\'');
        }
        sb.append(", COLUMNS => [ ");
        Iterator<ColumnSchemaModel> i = this.columns.iterator();
        while (i.hasNext()) {
            ColumnSchemaModel family = i.next();
            sb.append(family.toString());
            if (i.hasNext()) {
                sb.append(',');
            }
            sb.append(' ');
        }
        sb.append("] }");
        return sb.toString();
    }

    public boolean __getIsMeta() {
        Object o = this.attrs.get(IS_META);
        return o != null && Boolean.parseBoolean(o.toString());
    }

    public boolean __getIsRoot() {
        Object o = this.attrs.get(IS_ROOT);
        return o != null && Boolean.parseBoolean(o.toString());
    }

    public boolean __getReadOnly() {
        Object o = this.attrs.get(READONLY);
        return o != null ? Boolean.parseBoolean(o.toString()) : false;
    }

    public void __setIsMeta(boolean value) {
        this.attrs.put(IS_META, Boolean.toString(value));
    }

    public void __setIsRoot(boolean value) {
        this.attrs.put(IS_ROOT, Boolean.toString(value));
    }

    public void __setReadOnly(boolean value) {
        this.attrs.put(READONLY, Boolean.toString(value));
    }

    @Override
    public byte[] createProtobufOutput() {
        TableSchemaMessage.TableSchema.Builder builder = TableSchemaMessage.TableSchema.newBuilder();
        builder.setName(this.name);
        for (Map.Entry<QName, Object> e : this.attrs.entrySet()) {
            TableSchemaMessage.TableSchema.Attribute.Builder attrBuilder = TableSchemaMessage.TableSchema.Attribute.newBuilder();
            attrBuilder.setName(e.getKey().getLocalPart());
            attrBuilder.setValue(e.getValue().toString());
            builder.addAttrs(attrBuilder);
        }
        for (ColumnSchemaModel family : this.columns) {
            Map<QName, Object> familyAttrs = family.getAny();
            ColumnSchemaMessage.ColumnSchema.Builder familyBuilder = ColumnSchemaMessage.ColumnSchema.newBuilder();
            familyBuilder.setName(family.getName());
            for (Map.Entry<QName, Object> e : familyAttrs.entrySet()) {
                ColumnSchemaMessage.ColumnSchema.Attribute.Builder attrBuilder = ColumnSchemaMessage.ColumnSchema.Attribute.newBuilder();
                attrBuilder.setName(e.getKey().getLocalPart());
                attrBuilder.setValue(e.getValue().toString());
                familyBuilder.addAttrs(attrBuilder);
            }
            if (familyAttrs.containsKey(TTL)) {
                familyBuilder.setTtl(Integer.parseInt(familyAttrs.get(TTL).toString()));
            }
            if (familyAttrs.containsKey(VERSIONS)) {
                familyBuilder.setMaxVersions(Integer.parseInt(familyAttrs.get(VERSIONS).toString()));
            }
            if (familyAttrs.containsKey(COMPRESSION)) {
                familyBuilder.setCompression(familyAttrs.get(COMPRESSION).toString());
            }
            builder.addColumns(familyBuilder);
        }
        if (this.attrs.containsKey(READONLY)) {
            builder.setReadOnly(Boolean.parseBoolean(this.attrs.get(READONLY).toString()));
        }
        return builder.build().toByteArray();
    }

    @Override
    public ProtobufMessageHandler getObjectFromMessage(byte[] message) throws IOException {
        TableSchemaMessage.TableSchema.Builder builder = TableSchemaMessage.TableSchema.newBuilder();
        ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])message);
        this.setName(builder.getName());
        for (TableSchemaMessage.TableSchema.Attribute attr : builder.getAttrsList()) {
            this.addAttribute(attr.getName(), attr.getValue());
        }
        if (builder.hasReadOnly()) {
            this.addAttribute("READONLY", builder.getReadOnly());
        }
        for (ColumnSchemaMessage.ColumnSchema family : builder.getColumnsList()) {
            ColumnSchemaModel familyModel = new ColumnSchemaModel();
            familyModel.setName(family.getName());
            for (ColumnSchemaMessage.ColumnSchema.Attribute attr : family.getAttrsList()) {
                familyModel.addAttribute(attr.getName(), attr.getValue());
            }
            if (family.hasTtl()) {
                familyModel.addAttribute("TTL", family.getTtl());
            }
            if (family.hasMaxVersions()) {
                familyModel.addAttribute("VERSIONS", family.getMaxVersions());
            }
            if (family.hasCompression()) {
                familyModel.addAttribute("COMPRESSION", family.getCompression());
            }
            this.addColumnFamily(familyModel);
        }
        return this;
    }

    @JsonIgnore
    public HTableDescriptor getTableDescriptor() {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.getName()));
        for (Map.Entry<QName, Object> e : this.getAny().entrySet()) {
            htd.setValue(e.getKey().getLocalPart(), e.getValue().toString());
        }
        for (ColumnSchemaModel column : this.getColumns()) {
            HColumnDescriptor hcd = new HColumnDescriptor(column.getName());
            for (Map.Entry<QName, Object> e : column.getAny().entrySet()) {
                hcd.setValue(e.getKey().getLocalPart(), e.getValue().toString());
            }
            htd.addFamily(hcd);
        }
        return htd;
    }
}

