/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;

@InterfaceAudience.Public
@InterfaceStability.Evolving
@XmlRootElement(name="app")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppInfo {
    protected String appId;
    protected String currentAppAttemptId;
    protected String user;
    protected String name;
    protected String queue;
    protected String type;
    protected String host;
    protected int rpcPort;
    protected YarnApplicationState appState;
    protected int runningContainers;
    protected float progress;
    protected String diagnosticsInfo;
    protected String originalTrackingUrl;
    protected String trackingUrl;
    protected FinalApplicationStatus finalAppStatus;
    private long submittedTime;
    protected long startedTime;
    private long launchTime;
    protected long finishedTime;
    protected long elapsedTime;
    protected String applicationTags;
    protected int priority;
    private long allocatedCpuVcores;
    private long allocatedMemoryMB;
    private long reservedCpuVcores;
    private long reservedMemoryMB;
    protected boolean unmanagedApplication;
    private String appNodeLabelExpression;
    private String amNodeLabelExpression;
    private String aggregateResourceAllocation;
    private String aggregatePreemptedResourceAllocation;

    public AppInfo() {
    }

    public AppInfo(ApplicationReport app) {
        ApplicationResourceUsageReport usageReport;
        this.appId = app.getApplicationId().toString();
        if (app.getCurrentApplicationAttemptId() != null) {
            this.currentAppAttemptId = app.getCurrentApplicationAttemptId().toString();
        }
        this.user = app.getUser();
        this.queue = app.getQueue();
        this.name = app.getName();
        this.type = app.getApplicationType();
        this.host = app.getHost();
        this.rpcPort = app.getRpcPort();
        this.appState = app.getYarnApplicationState();
        this.diagnosticsInfo = app.getDiagnostics();
        this.trackingUrl = app.getTrackingUrl();
        this.originalTrackingUrl = app.getOriginalTrackingUrl();
        this.submittedTime = app.getSubmitTime();
        this.startedTime = app.getStartTime();
        this.launchTime = app.getLaunchTime();
        this.finishedTime = app.getFinishTime();
        this.elapsedTime = Times.elapsed((long)this.startedTime, (long)this.finishedTime);
        this.finalAppStatus = app.getFinalApplicationStatus();
        this.priority = 0;
        if (app.getPriority() != null) {
            this.priority = app.getPriority().getPriority();
        }
        if ((usageReport = app.getApplicationResourceUsageReport()) != null) {
            this.runningContainers = usageReport.getNumUsedContainers();
            if (usageReport.getUsedResources() != null) {
                this.allocatedCpuVcores = usageReport.getUsedResources().getVirtualCores();
                this.allocatedMemoryMB = usageReport.getUsedResources().getMemorySize();
                this.reservedCpuVcores = usageReport.getReservedResources().getVirtualCores();
                this.reservedMemoryMB = usageReport.getReservedResources().getMemorySize();
            }
            this.aggregateResourceAllocation = usageReport.getMemorySeconds() + " MB-seconds, " + usageReport.getVcoreSeconds() + " vcore-seconds";
            this.aggregatePreemptedResourceAllocation = usageReport.getPreemptedMemorySeconds() + " MB-seconds, " + usageReport.getPreemptedVcoreSeconds() + " vcore-seconds";
        }
        this.progress = app.getProgress() * 100.0f;
        if (app.getApplicationTags() != null && !app.getApplicationTags().isEmpty()) {
            this.applicationTags = StringHelper.CSV_JOINER.join((Iterable)app.getApplicationTags());
        }
        this.unmanagedApplication = app.isUnmanagedApp();
        this.appNodeLabelExpression = app.getAppNodeLabelExpression();
        this.amNodeLabelExpression = app.getAmNodeLabelExpression();
    }

    public String getAppId() {
        return this.appId;
    }

    public String getCurrentAppAttemptId() {
        return this.currentAppAttemptId;
    }

    public String getUser() {
        return this.user;
    }

    public String getName() {
        return this.name;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getType() {
        return this.type;
    }

    public String getHost() {
        return this.host;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public YarnApplicationState getAppState() {
        return this.appState;
    }

    public int getRunningContainers() {
        return this.runningContainers;
    }

    public long getAllocatedCpuVcores() {
        return this.allocatedCpuVcores;
    }

    public long getAllocatedMemoryMB() {
        return this.allocatedMemoryMB;
    }

    public long getReservedCpuVcores() {
        return this.reservedCpuVcores;
    }

    public long getReservedMemoryMB() {
        return this.reservedMemoryMB;
    }

    public float getProgress() {
        return this.progress;
    }

    public String getDiagnosticsInfo() {
        return this.diagnosticsInfo;
    }

    public String getOriginalTrackingUrl() {
        return this.originalTrackingUrl;
    }

    public String getTrackingUrl() {
        return this.trackingUrl;
    }

    public FinalApplicationStatus getFinalAppStatus() {
        return this.finalAppStatus;
    }

    public long getSubmittedTime() {
        return this.submittedTime;
    }

    public long getLaunchTime() {
        return this.launchTime;
    }

    public long getStartedTime() {
        return this.startedTime;
    }

    public long getFinishedTime() {
        return this.finishedTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String getApplicationTags() {
        return this.applicationTags;
    }

    public boolean isUnmanagedApp() {
        return this.unmanagedApplication;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getAppNodeLabelExpression() {
        return this.appNodeLabelExpression;
    }

    public String getAmNodeLabelExpression() {
        return this.amNodeLabelExpression;
    }

    public String getAggregateResourceAllocation() {
        return this.aggregateResourceAllocation;
    }

    public String getAggregatePreemptedResourceAllocation() {
        return this.aggregatePreemptedResourceAllocation;
    }
}

