/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.util.MultiThreadedAction;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class LoadTestDataGeneratorWithVisibilityLabels
extends MultiThreadedAction.DefaultDataGenerator {
    private static final String COMMA = ",";
    private String[] visibilityExps = null;
    private String[][] authorizations = null;

    public LoadTestDataGeneratorWithVisibilityLabels(int minValueSize, int maxValueSize, int minColumnsPerKey, int maxColumnsPerKey, byte[] ... columnFamilies) {
        super(minValueSize, maxValueSize, minColumnsPerKey, maxColumnsPerKey, columnFamilies);
    }

    @Override
    public void initialize(String[] args) {
        super.initialize(args);
        if (args.length < 1 || args.length > 2) {
            throw new IllegalArgumentException("LoadTestDataGeneratorWithVisibilityLabels can have 1 or 2 initialization arguments");
        }
        String temp = args[0];
        this.visibilityExps = temp.split(COMMA);
        if (args.length == 2) {
            this.authorizations = LoadTestDataGeneratorWithVisibilityLabels.toAuthorizationsSet(args[1]);
        }
    }

    private static String[][] toAuthorizationsSet(String authorizationsStr) {
        String[] split = authorizationsStr.split("],");
        String[][] result = new String[split.length][];
        for (int i = 0; i < split.length; ++i) {
            String s = split[i].trim();
            assert (s.charAt(0) == '[');
            s = s.substring(1);
            if (i == split.length - 1) {
                assert (s.charAt(s.length() - 1) == ']');
                s = s.substring(0, s.length() - 1);
            }
            String[] tmp = s.split(COMMA);
            for (int j = 0; j < tmp.length; ++j) {
                tmp[j] = tmp[j].trim();
            }
            result[i] = tmp;
        }
        return result;
    }

    @Override
    public Mutation beforeMutate(long rowkeyBase, Mutation m) throws IOException {
        m.setCellVisibility(new CellVisibility(this.visibilityExps[(int)rowkeyBase % this.visibilityExps.length]));
        return m;
    }

    @Override
    public Get beforeGet(long rowkeyBase, Get get) {
        get.setAuthorizations(new Authorizations(this.authorizations[(int)(rowkeyBase % (long)this.authorizations.length)]));
        return get;
    }
}

