/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;

@Category(value={SecurityTests.class, MediumTests.class})
public class TestRpcAccessChecks {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRpcAccessChecks.class);
    @Rule
    public final TestName TEST_NAME = new TestName();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    private static User USER_ADMIN;
    private static User USER_NON_ADMIN;
    private static User USER_IN_SUPERGROUPS;
    private static User USER_ADMIN_NOT_SUPER;
    private static final String GROUP_ADMIN = "admin_group";
    private static User USER_GROUP_ADMIN;

    private static void enableSecurity(Configuration conf) throws IOException {
        conf.set("hadoop.security.authorization", "false");
        conf.set("hadoop.security.authentication", "simple");
        conf.set("hbase.coprocessor.master.classes", AccessController.class.getName() + "," + DummyCpService.class.getName());
        conf.set("hbase.coprocessor.region.classes", AccessController.class.getName());
        conf.set("hbase.coprocessor.regionserver.classes", AccessController.class.getName() + "," + DummyCpService.class.getName());
        conf.set("hbase.security.authorization", "true");
        SecureTestUtil.configureSuperuser(conf);
    }

    @BeforeClass
    public static void setup() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TestRpcAccessChecks.enableSecurity(conf);
        USER_ADMIN = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[0]);
        USER_NON_ADMIN = User.createUserForTesting((Configuration)conf, (String)"non_admin", (String[])new String[0]);
        USER_GROUP_ADMIN = User.createUserForTesting((Configuration)conf, (String)"user_group_admin", (String[])new String[]{GROUP_ADMIN});
        USER_IN_SUPERGROUPS = User.createUserForTesting((Configuration)conf, (String)"user_in_supergroup", (String[])new String[]{"supergroup"});
        USER_ADMIN_NOT_SUPER = User.createUserForTesting((Configuration)conf, (String)"normal_admin", (String[])new String[0]);
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.waitUntilAllRegionsAssigned(PermissionStorage.ACL_TABLE_NAME);
        SecureTestUtil.grantGlobal(TEST_UTIL, AuthUtil.toGroupEntry((String)GROUP_ADMIN), Permission.Action.ADMIN, Permission.Action.CREATE);
        SecureTestUtil.grantGlobal(TEST_UTIL, USER_ADMIN_NOT_SUPER.getShortName(), Permission.Action.ADMIN);
    }

    private void verifyAllowed(User user, Action action) throws Exception {
        user.runAs(() -> {
            try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                 Admin admin = conn.getAdmin();){
                action.run(admin);
            }
            catch (IOException e) {
                Assert.fail((String)e.toString());
            }
            return null;
        });
    }

    private void verifyDenied(User user, Action action) throws Exception {
        user.runAs(() -> {
            boolean accessDenied = false;
            try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                 Admin admin = conn.getAdmin();){
                action.run(admin);
            }
            catch (AccessDeniedException e) {
                accessDenied = true;
            }
            Assert.assertTrue((String)"Expected access to be denied", (boolean)accessDenied);
            return null;
        });
    }

    private void verifiedDeniedServiceException(User user, Action action) throws Exception {
        user.runAs(() -> {
            boolean accessDenied;
            block26: {
                accessDenied = false;
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Admin admin = conn.getAdmin();){
                    action.run(admin);
                }
                catch (ServiceException e) {
                    if (!(e.getCause() instanceof AccessDeniedException)) break block26;
                    accessDenied = true;
                }
            }
            Assert.assertTrue((String)"Expected access to be denied", (boolean)accessDenied);
            return null;
        });
    }

    private void verifyAdminCheckForAction(Action action) throws Exception {
        this.verifyAllowed(USER_ADMIN, action);
        this.verifyAllowed(USER_GROUP_ADMIN, action);
        this.verifyDenied(USER_NON_ADMIN, action);
    }

    @Test
    public void testEnableCatalogJanitor() throws Exception {
        this.verifyAdminCheckForAction(admin -> admin.enableCatalogJanitor(true));
    }

    @Test
    public void testRunCatalogJanitor() throws Exception {
        this.verifyAdminCheckForAction(admin -> admin.runCatalogJanitor());
    }

    @Test
    public void testCleanerChoreRunning() throws Exception {
        this.verifyAdminCheckForAction(admin -> admin.cleanerChoreSwitch(true));
    }

    @Test
    public void testRunCleanerChore() throws Exception {
        this.verifyAdminCheckForAction(admin -> admin.runCleanerChore());
    }

    @Test
    public void testExecProcedure() throws Exception {
        this.verifyAdminCheckForAction(admin -> admin.execProcedure("flush-table-proc", TableName.META_TABLE_NAME.getNameAsString(), new HashMap()));
    }

    @Test
    public void testExecService() throws Exception {
        Action action = admin -> {
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface service = TestRpcServiceProtos.TestProtobufRpcProto.newBlockingStub((BlockingRpcChannel)admin.coprocessorService());
            service.ping(null, TestProtos.EmptyRequestProto.getDefaultInstance());
        };
        this.verifyAllowed(USER_ADMIN, action);
        this.verifyAllowed(USER_GROUP_ADMIN, action);
        this.verifiedDeniedServiceException(USER_NON_ADMIN, action);
    }

    @Test
    public void testExecProcedureWithRet() throws Exception {
        this.verifyAdminCheckForAction(admin -> admin.execProcedureWithReturn("flush-table-proc", TableName.META_TABLE_NAME.getNameAsString(), new HashMap()));
    }

    @Test
    public void testNormalize() throws Exception {
        this.verifyAdminCheckForAction(admin -> admin.normalize());
    }

    @Test
    public void testSetNormalizerRunning() throws Exception {
        this.verifyAdminCheckForAction(admin -> admin.normalizerSwitch(true));
    }

    @Test
    public void testExecRegionServerService() throws Exception {
        Action action = admin -> {
            ServerName serverName = TEST_UTIL.getHBaseCluster().getRegionServer(0).getServerName();
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface service = TestRpcServiceProtos.TestProtobufRpcProto.newBlockingStub((BlockingRpcChannel)admin.coprocessorService(serverName));
            service.ping(null, TestProtos.EmptyRequestProto.getDefaultInstance());
        };
        this.verifyAllowed(USER_ADMIN, action);
        this.verifyAllowed(USER_GROUP_ADMIN, action);
        this.verifiedDeniedServiceException(USER_NON_ADMIN, action);
    }

    @Test
    public void testTableFlush() throws Exception {
        TableName tn = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tn).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"f1")).build();
        Action adminAction = admin -> {
            admin.createTable(desc);
            SecureTestUtil.grantOnTable(TEST_UTIL, USER_NON_ADMIN.getShortName(), tn, null, null, Permission.Action.READ, Permission.Action.WRITE, Permission.Action.CREATE);
        };
        this.verifyAllowed(USER_ADMIN, adminAction);
        Action userAction = admin -> {
            Connection conn = admin.getConnection();
            byte[] rowKey = Bytes.toBytes((String)"row1");
            byte[] col = Bytes.toBytes((String)"q1");
            byte[] val = Bytes.toBytes((String)"v1");
            try (Table table = conn.getTable(tn);){
                Put p = new Put(rowKey);
                p.addColumn(Bytes.toBytes((String)"f1"), col, val);
                table.put(p);
                admin.flush(tn);
                Result result = table.get(new Get(rowKey));
                Assert.assertFalse((boolean)result.isEmpty());
                Cell c = result.getColumnLatestCell(Bytes.toBytes((String)"f1"), col);
                Assert.assertArrayEquals((byte[])val, (byte[])CellUtil.cloneValue((Cell)c));
            }
        };
        this.verifyAllowed(USER_NON_ADMIN, userAction);
    }

    @Test
    public void testTableFlushAndSnapshot() throws Exception {
        TableName tn = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tn).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"f1")).build();
        Action adminAction = admin -> {
            admin.createTable(desc);
            SecureTestUtil.grantOnTable(TEST_UTIL, USER_NON_ADMIN.getShortName(), tn, null, null, Permission.Action.READ, Permission.Action.WRITE, Permission.Action.CREATE, Permission.Action.ADMIN);
        };
        this.verifyAllowed(USER_ADMIN, adminAction);
        Action userAction = admin -> {
            Connection conn = admin.getConnection();
            byte[] rowKey = Bytes.toBytes((String)"row1");
            byte[] col = Bytes.toBytes((String)"q1");
            byte[] val = Bytes.toBytes((String)"v1");
            try (Table table = conn.getTable(tn);){
                Put p = new Put(rowKey);
                p.addColumn(Bytes.toBytes((String)"f1"), col, val);
                table.put(p);
                admin.flush(tn);
                admin.snapshot(tn.getNameAsString() + "_snapshot1", tn);
                Result result = table.get(new Get(rowKey));
                Assert.assertFalse((boolean)result.isEmpty());
                Cell c = result.getColumnLatestCell(Bytes.toBytes((String)"f1"), col);
                Assert.assertArrayEquals((byte[])val, (byte[])CellUtil.cloneValue((Cell)c));
            }
        };
        this.verifyAllowed(USER_NON_ADMIN, userAction);
    }

    @Test
    public void testGrantDeniedOnSuperUsersGroups() {
        try {
            SecureTestUtil.grantGlobal(USER_ADMIN_NOT_SUPER, TEST_UTIL, USER_ADMIN.getShortName(), Permission.Action.ADMIN, Permission.Action.CREATE);
            Assert.fail((String)"Granting superuser's global permissions is not allowed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SecureTestUtil.grantOnNamespace(USER_ADMIN_NOT_SUPER, TEST_UTIL, USER_ADMIN.getShortName(), this.TEST_NAME.getMethodName(), Permission.Action.ADMIN, Permission.Action.CREATE);
            Assert.fail((String)"Granting superuser's namespace permissions is not allowed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SecureTestUtil.grantOnTable(USER_ADMIN_NOT_SUPER, TEST_UTIL, USER_ADMIN.getName(), TableName.valueOf((String)this.TEST_NAME.getMethodName()), null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
            Assert.fail((String)"Granting superuser's table permissions is not allowed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SecureTestUtil.grantGlobal(USER_ADMIN_NOT_SUPER, TEST_UTIL, USER_IN_SUPERGROUPS.getShortName(), Permission.Action.ADMIN, Permission.Action.CREATE);
            Assert.fail((String)"Granting superuser's global permissions is not allowed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRevokeDeniedOnSuperUsersGroups() {
        try {
            SecureTestUtil.revokeGlobal(USER_ADMIN_NOT_SUPER, TEST_UTIL, USER_ADMIN.getShortName(), Permission.Action.ADMIN);
            Assert.fail((String)"Revoking superuser's global permissions is not allowed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SecureTestUtil.revokeFromNamespace(USER_ADMIN_NOT_SUPER, TEST_UTIL, USER_ADMIN.getShortName(), this.TEST_NAME.getMethodName(), Permission.Action.ADMIN);
            Assert.fail((String)"Revoking superuser's namespace permissions is not allowed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SecureTestUtil.revokeFromTable(USER_ADMIN_NOT_SUPER, TEST_UTIL, USER_ADMIN.getName(), TableName.valueOf((String)this.TEST_NAME.getMethodName()), null, null, Permission.Action.ADMIN);
            Assert.fail((String)"Revoking superuser's table permissions is not allowed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SecureTestUtil.revokeGlobal(USER_ADMIN_NOT_SUPER, TEST_UTIL, AuthUtil.toGroupEntry((String)"supergroup"), Permission.Action.ADMIN, Permission.Action.CREATE);
            Assert.fail((String)"Revoking supergroup's permissions is not allowed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static interface Action {
        public void run(Admin var1) throws Exception;
    }

    public static class DummyCpService
    implements MasterCoprocessor,
    RegionServerCoprocessor {
        public Iterable<Service> getServices() {
            return Collections.singleton(Mockito.mock(TestRpcServiceProtos.TestProtobufRpcProto.class));
        }
    }
}

