/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.region;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.cleaner.DirScanPool;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.master.region.MasterRegionParams;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.junit.After;
import org.junit.Before;
import org.mockito.Mockito;

public class MasterRegionTestBase {
    protected HBaseCommonTestingUtility htu;
    protected MasterRegion region;
    protected ChoreService choreService;
    protected DirScanPool hfileCleanerPool;
    protected DirScanPool logCleanerPool;
    protected static byte[] CF1 = Bytes.toBytes((String)"f1");
    protected static byte[] CF2 = Bytes.toBytes((String)"f2");
    protected static byte[] QUALIFIER = Bytes.toBytes((String)"q");
    protected static String REGION_DIR_NAME = "local";
    protected static TableDescriptor TD = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"test:local")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])CF1)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])CF2)).build();

    protected void configure(Configuration conf) throws IOException {
    }

    protected void configure(MasterRegionParams params) {
    }

    protected void postSetUp() throws IOException {
    }

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtility();
        this.htu.getConfiguration().setBoolean("hbase.hregion.memstore.mslab.enabled", false);
        this.htu.getConfiguration().setBoolean("hbase.unsafe.stream.capability.enforce", false);
        this.createMasterRegion();
    }

    protected void createMasterRegion() throws IOException {
        this.configure(this.htu.getConfiguration());
        this.choreService = new ChoreService(this.getClass().getSimpleName());
        this.hfileCleanerPool = DirScanPool.getHFileCleanerScanPool((Configuration)this.htu.getConfiguration());
        this.logCleanerPool = DirScanPool.getLogCleanerScanPool((Configuration)this.htu.getConfiguration());
        Server server = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)server.getConfiguration()).thenReturn((Object)this.htu.getConfiguration());
        Mockito.when((Object)server.getServerName()).thenReturn((Object)ServerName.valueOf((String)"localhost", (int)12345, (long)System.currentTimeMillis()));
        Mockito.when((Object)server.getChoreService()).thenReturn((Object)this.choreService);
        Path testDir = this.htu.getDataTestDir();
        CommonFSUtils.setRootDir((Configuration)this.htu.getConfiguration(), (Path)testDir);
        MasterRegionParams params = new MasterRegionParams();
        params.server(server).regionDirName(REGION_DIR_NAME).tableDescriptor(TD).flushSize(0x8000000L).flushPerChanges(1000000L).flushIntervalMs(TimeUnit.MINUTES.toMillis(15L)).compactMin(4).maxWals(32).useHsync(false).ringBufferSlotCount(16).rollPeriodMs(TimeUnit.MINUTES.toMillis(15L)).archivedWalSuffix("$masterlocalwal$").archivedHFileSuffix("$-masterlocalhfile-$");
        this.configure(params);
        this.region = MasterRegion.create((MasterRegionParams)params);
        this.postSetUp();
    }

    @After
    public void tearDown() throws IOException {
        this.region.close(true);
        this.hfileCleanerPool.shutdownNow();
        this.logCleanerPool.shutdownNow();
        this.choreService.shutdown();
        this.htu.cleanupTestDir();
    }
}

