/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.CloneSnapshotFromClientTestBase;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;

public class CloneSnapshotFromClientAfterSplittingRegionTestBase
extends CloneSnapshotFromClientTestBase {
    private void splitRegion(RegionInfo regionInfo) throws IOException {
        byte[][] splitPoints = Bytes.split((byte[])regionInfo.getStartKey(), (byte[])regionInfo.getEndKey(), (int)1);
        this.admin.split(regionInfo.getTable(), splitPoints[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloneSnapshotAfterSplittingRegion() throws IOException, InterruptedException {
        this.admin.catalogJanitorSwitch(false);
        try {
            List regionInfos = this.admin.getRegions(this.tableName);
            RegionReplicaUtil.removeNonDefaultRegions((Collection)regionInfos);
            this.splitRegion((RegionInfo)regionInfos.get(0));
            this.admin.snapshot(this.snapshotName2, this.tableName);
            TableName clonedTableName = TableName.valueOf((String)(this.getValidMethodName() + "-" + System.currentTimeMillis()));
            this.admin.cloneSnapshot(this.snapshotName2, clonedTableName);
            SnapshotTestingUtils.waitForTableToBeOnline(TEST_UTIL, clonedTableName);
            this.verifyRowCount(TEST_UTIL, clonedTableName, this.snapshot1Rows);
            RegionStates regionStates = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
            int openRegionCountOfOriginalTable = ((List)regionStates.getRegionByStateOfTable(this.tableName).get(RegionState.State.OPEN)).size();
            int openRegionCountOfClonedTable = ((List)regionStates.getRegionByStateOfTable(clonedTableName).get(RegionState.State.OPEN)).size();
            Assert.assertEquals((long)openRegionCountOfOriginalTable, (long)openRegionCountOfClonedTable);
            int splitRegionCountOfOriginalTable = ((List)regionStates.getRegionByStateOfTable(this.tableName).get(RegionState.State.SPLIT)).size();
            int splitRegionCountOfClonedTable = ((List)regionStates.getRegionByStateOfTable(clonedTableName).get(RegionState.State.SPLIT)).size();
            Assert.assertEquals((long)splitRegionCountOfOriginalTable, (long)splitRegionCountOfClonedTable);
            TEST_UTIL.deleteTable(clonedTableName);
        }
        finally {
            this.admin.catalogJanitorSwitch(true);
        }
    }

    @Test
    public void testCloneSnapshotBeforeSplittingRegionAndDroppingTable() throws IOException, InterruptedException {
        this.admin.catalogJanitorSwitch(false);
        try {
            this.admin.snapshot(this.snapshotName2, this.tableName);
            TableName clonedTableName = TableName.valueOf((String)(this.getValidMethodName() + "-" + System.currentTimeMillis()));
            this.admin.cloneSnapshot(this.snapshotName2, clonedTableName);
            SnapshotTestingUtils.waitForTableToBeOnline(TEST_UTIL, clonedTableName);
            List regionInfos = this.admin.getRegions(this.tableName);
            RegionReplicaUtil.removeNonDefaultRegions((Collection)regionInfos);
            this.splitRegion((RegionInfo)regionInfos.get(0));
            this.admin.disableTable(this.tableName);
            this.admin.deleteTable(this.tableName);
            this.admin.disableTable(clonedTableName);
            this.admin.enableTable(clonedTableName);
            SnapshotTestingUtils.waitForTableToBeOnline(TEST_UTIL, clonedTableName);
            this.verifyRowCount(TEST_UTIL, clonedTableName, this.snapshot1Rows);
        }
        finally {
            this.admin.catalogJanitorSwitch(true);
        }
    }
}

