/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.IOException;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.IntStream;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanOptions;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.math.IntMath;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class WriteHeavyIncrementObserver
implements RegionCoprocessor,
RegionObserver {
    private final int mask;
    private final MutableLong[] lastTimestamps;

    public WriteHeavyIncrementObserver() {
        int stripes = 1 << IntMath.log2((int)Runtime.getRuntime().availableProcessors(), (RoundingMode)RoundingMode.CEILING);
        this.lastTimestamps = (MutableLong[])IntStream.range(0, stripes).mapToObj(i -> new MutableLong()).toArray(MutableLong[]::new);
        this.mask = stripes - 1;
    }

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public void preFlushScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ScanOptions options, FlushLifeCycleTracker tracker) throws IOException {
        options.readAllVersions();
    }

    private Cell createCell(byte[] row, byte[] family, byte[] qualifier, long ts, long value) {
        return CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(row).setType(Cell.Type.Put).setFamily(family).setQualifier(qualifier).setTimestamp(ts).setValue(Bytes.toBytes((long)value)).build();
    }

    private InternalScanner wrap(final byte[] family, final InternalScanner scanner) {
        return new InternalScanner(){
            private List<Cell> srcResult = new ArrayList<Cell>();
            private byte[] row;
            private byte[] qualifier;
            private long timestamp;
            private long sum;

            public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
                boolean moreRows = scanner.next(this.srcResult, scannerContext);
                if (this.srcResult.isEmpty()) {
                    if (!moreRows && this.row != null) {
                        result.add(WriteHeavyIncrementObserver.this.createCell(this.row, family, this.qualifier, this.timestamp, this.sum));
                    }
                    return moreRows;
                }
                Cell firstCell = this.srcResult.get(0);
                if (this.row == null) {
                    this.row = CellUtil.cloneRow((Cell)firstCell);
                    this.qualifier = CellUtil.cloneQualifier((Cell)firstCell);
                } else if (!CellUtil.matchingRows((Cell)firstCell, (byte[])this.row)) {
                    result.add(WriteHeavyIncrementObserver.this.createCell(this.row, family, this.qualifier, this.timestamp, this.sum));
                    this.row = CellUtil.cloneRow((Cell)firstCell);
                    this.qualifier = CellUtil.cloneQualifier((Cell)firstCell);
                    this.sum = 0L;
                }
                this.srcResult.forEach(c -> {
                    if (CellUtil.matchingQualifier((Cell)c, (byte[])this.qualifier)) {
                        this.sum += Bytes.toLong((byte[])c.getValueArray(), (int)c.getValueOffset());
                    } else {
                        result.add(WriteHeavyIncrementObserver.this.createCell(this.row, family, this.qualifier, this.timestamp, this.sum));
                        this.qualifier = CellUtil.cloneQualifier((Cell)c);
                        this.sum = Bytes.toLong((byte[])c.getValueArray(), (int)c.getValueOffset());
                    }
                    this.timestamp = c.getTimestamp();
                });
                if (!moreRows) {
                    result.add(WriteHeavyIncrementObserver.this.createCell(this.row, family, this.qualifier, this.timestamp, this.sum));
                }
                this.srcResult.clear();
                return moreRows;
            }

            public void close() throws IOException {
                scanner.close();
            }
        };
    }

    public InternalScanner preFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, FlushLifeCycleTracker tracker) throws IOException {
        return this.wrap(store.getColumnFamilyDescriptor().getName(), scanner);
    }

    public void preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ScanType scanType, ScanOptions options, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
        options.readAllVersions();
    }

    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
        return this.wrap(store.getColumnFamilyDescriptor().getName(), scanner);
    }

    public void preMemStoreCompactionCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ScanOptions options) throws IOException {
        options.readAllVersions();
    }

    public InternalScanner preMemStoreCompactionCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner) throws IOException {
        return this.wrap(store.getColumnFamilyDescriptor().getName(), scanner);
    }

    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> result) throws IOException {
        Scan scan = new Scan().withStartRow(get.getRow()).withStopRow(get.getRow(), true).readAllVersions();
        TreeMap<byte[], NavigableMap> sums = new TreeMap<byte[], NavigableMap>(Bytes.BYTES_COMPARATOR);
        get.getFamilyMap().forEach((cf, cqs) -> {
            TreeMap ss = new TreeMap(Bytes.BYTES_COMPARATOR);
            sums.put((byte[])cf, ss);
            cqs.forEach(cq -> {
                ss.put(cq, new MutableLong(0L));
                scan.addColumn(cf, cq);
            });
        });
        ArrayList cells = new ArrayList();
        try (RegionScanner scanner = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getScanner(scan);){
            boolean moreRows;
            do {
                moreRows = scanner.next(cells);
                for (Cell cell : cells) {
                    byte[] family = CellUtil.cloneFamily((Cell)cell);
                    byte[] qualifier = CellUtil.cloneQualifier((Cell)cell);
                    long value = Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset());
                    ((MutableLong)((NavigableMap)sums.get(family)).get(qualifier)).add(value);
                }
                cells.clear();
            } while (moreRows);
        }
        sums.forEach((cf, m) -> m.forEach((cq, s) -> result.add(this.createCell(get.getRow(), (byte[])cf, (byte[])cq, Long.MAX_VALUE, s.longValue()))));
        c.bypass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUniqueTimestamp(byte[] row) {
        int slot = Bytes.hashCode((byte[])row) & this.mask;
        MutableLong lastTimestamp = this.lastTimestamps[slot];
        long now = System.currentTimeMillis();
        MutableLong mutableLong = lastTimestamp;
        synchronized (mutableLong) {
            long pt = lastTimestamp.longValue() >> 10;
            if (now > pt) {
                lastTimestamp.setValue(now << 10);
            } else {
                lastTimestamp.increment();
            }
            return lastTimestamp.longValue();
        }
    }

    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        byte[] row = increment.getRow();
        Put put = new Put(row);
        long ts = this.getUniqueTimestamp(row);
        for (Map.Entry entry : increment.getFamilyCellMap().entrySet()) {
            for (Cell cell : (List)entry.getValue()) {
                put.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(row).setFamily(cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength()).setQualifier(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()).setValue(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()).setType(Cell.Type.Put).setTimestamp(ts).build());
            }
        }
        ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().put(put);
        c.bypass();
        return Result.EMPTY_RESULT;
    }

    public void preStoreScannerOpen(ObserverContext<RegionCoprocessorEnvironment> ctx, Store store, ScanOptions options) throws IOException {
        options.readAllVersions();
    }
}

