/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.top;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.RecordFilter;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.field.FieldInfo;
import org.apache.hadoop.hbase.hbtop.field.FieldValue;
import org.apache.hadoop.hbase.hbtop.mode.DrillDownInfo;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.screen.top.Summary;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TopScreenModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopScreenModel.class);
    private final Admin admin;
    private Mode currentMode;
    private Field currentSortField;
    private List<FieldInfo> fieldInfos;
    private List<Field> fields;
    private Summary summary;
    private List<Record> records;
    private final List<RecordFilter> filters = new ArrayList<RecordFilter>();
    private final List<RecordFilter> pushDownFilters = new ArrayList<RecordFilter>();
    private final List<String> filterHistories = new ArrayList<String>();
    private boolean ascendingSort;

    public TopScreenModel(Admin admin, Mode initialMode, @Nullable List<Field> initialFields, @Nullable Field initialSortField, @Nullable Boolean initialAscendingSort, @Nullable List<RecordFilter> initialFilters) {
        this.admin = Objects.requireNonNull(admin);
        this.switchMode(Objects.requireNonNull(initialMode), initialSortField, false, initialFields, initialAscendingSort, initialFilters);
    }

    public void switchMode(Mode nextMode, boolean keepSortFieldAndSortOrderIfPossible, List<RecordFilter> initialFilters) {
        this.switchMode(nextMode, null, keepSortFieldAndSortOrderIfPossible, null, null, initialFilters);
    }

    public void switchMode(Mode nextMode, Field initialSortField, boolean keepSortFieldAndSortOrderIfPossible, @Nullable List<Field> initialFields, @Nullable Boolean initialAscendingSort, @Nullable List<RecordFilter> initialFilters) {
        this.currentMode = nextMode;
        this.fieldInfos = Collections.unmodifiableList(new ArrayList<FieldInfo>(this.currentMode.getFieldInfos()));
        if (initialFields != null) {
            ArrayList<Field> tmp = new ArrayList<Field>(initialFields);
            tmp.addAll(this.currentMode.getFieldInfos().stream().map(FieldInfo::getField).filter(f -> !initialFields.contains(f)).collect(Collectors.toList()));
            this.fields = Collections.unmodifiableList(tmp);
        } else {
            this.fields = Collections.unmodifiableList(this.currentMode.getFieldInfos().stream().map(FieldInfo::getField).collect(Collectors.toList()));
        }
        if (keepSortFieldAndSortOrderIfPossible) {
            boolean match = this.fields.stream().anyMatch(f -> f == this.currentSortField);
            if (!match) {
                if (initialSortField != null && initialAscendingSort != null) {
                    this.currentSortField = initialSortField;
                    this.ascendingSort = initialAscendingSort;
                } else {
                    this.currentSortField = nextMode.getDefaultSortField();
                    this.ascendingSort = false;
                }
            }
        } else if (initialSortField != null && initialAscendingSort != null) {
            this.currentSortField = initialSortField;
            this.ascendingSort = initialAscendingSort;
        } else {
            this.currentSortField = nextMode.getDefaultSortField();
            this.ascendingSort = false;
        }
        this.clearFilters();
        if (initialFilters != null) {
            this.filters.addAll(initialFilters);
        }
        this.decomposePushDownFilter();
    }

    public void setSortFieldAndFields(Field sortField, List<Field> fields) {
        this.currentSortField = sortField;
        this.fields = Collections.unmodifiableList(new ArrayList<Field>(fields));
    }

    public void refreshMetricsData() {
        ClusterMetrics clusterMetrics;
        try {
            clusterMetrics = this.admin.getClusterMetrics();
        }
        catch (Exception e) {
            LOGGER.error("Unable to get cluster metrics", (Throwable)e);
            return;
        }
        this.refreshSummary(clusterMetrics);
        this.refreshRecords(clusterMetrics);
    }

    private void refreshSummary(ClusterMetrics clusterMetrics) {
        String currentTime = DateFormatUtils.ISO_8601_EXTENDED_TIME_FORMAT.format(System.currentTimeMillis());
        String version = clusterMetrics.getHBaseVersion();
        String clusterId = clusterMetrics.getClusterId();
        int liveServers = clusterMetrics.getLiveServerMetrics().size();
        int deadServers = clusterMetrics.getDeadServerNames().size();
        int regionCount = clusterMetrics.getRegionCount();
        int ritCount = clusterMetrics.getRegionStatesInTransition().size();
        double averageLoad = clusterMetrics.getAverageLoad();
        long aggregateRequestPerSecond = clusterMetrics.getLiveServerMetrics().entrySet().stream().mapToLong(e -> ((ServerMetrics)e.getValue()).getRequestCountPerSecond()).sum();
        this.summary = new Summary(currentTime, version, clusterId, liveServers + deadServers, liveServers, deadServers, regionCount, ritCount, averageLoad, aggregateRequestPerSecond);
    }

    private void refreshRecords(ClusterMetrics clusterMetrics) {
        List<Record> records = this.currentMode.getRecords(clusterMetrics, this.pushDownFilters);
        records = records.stream().filter(r -> this.filters.stream().allMatch(f -> f.execute((Record)r))).sorted((recordLeft, recordRight) -> {
            FieldValue left = recordLeft.get((Object)this.currentSortField);
            FieldValue right = recordRight.get((Object)this.currentSortField);
            return (this.ascendingSort ? 1 : -1) * left.compareTo(right);
        }).collect(Collectors.toList());
        this.records = Collections.unmodifiableList(records);
    }

    public void switchSortOrder() {
        this.ascendingSort = !this.ascendingSort;
    }

    public boolean addFilter(String filterString, boolean ignoreCase) {
        RecordFilter filter = RecordFilter.parse(filterString, this.fields, ignoreCase);
        if (filter == null) {
            return false;
        }
        this.filters.add(filter);
        this.filterHistories.add(filterString);
        return true;
    }

    public void clearFilters() {
        this.pushDownFilters.clear();
        this.filters.clear();
    }

    public boolean drillDown(Record selectedRecord) {
        DrillDownInfo drillDownInfo = this.currentMode.drillDown(selectedRecord);
        if (drillDownInfo == null) {
            return false;
        }
        this.switchMode(drillDownInfo.getNextMode(), true, drillDownInfo.getInitialFilters());
        return true;
    }

    public Mode getCurrentMode() {
        return this.currentMode;
    }

    public Field getCurrentSortField() {
        return this.currentSortField;
    }

    public List<FieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public Summary getSummary() {
        return this.summary;
    }

    public List<Record> getRecords() {
        return this.records;
    }

    public List<RecordFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public List<String> getFilterHistories() {
        return Collections.unmodifiableList(this.filterHistories);
    }

    private void decomposePushDownFilter() {
        this.pushDownFilters.clear();
        for (RecordFilter filter : this.filters) {
            if (this.fields.contains((Object)filter.getField())) continue;
            this.pushDownFilters.add(filter);
        }
        this.filters.removeAll(this.pushDownFilters);
    }

    public Collection<? extends RecordFilter> getPushDownFilters() {
        return this.pushDownFilters;
    }
}

