/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.mode;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.RecordFilter;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.field.FieldInfo;
import org.apache.hadoop.hbase.hbtop.mode.DrillDownInfo;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.mode.ModeStrategy;
import org.apache.hadoop.hbase.hbtop.mode.ModeStrategyUtils;
import org.apache.hadoop.hbase.hbtop.mode.RegionModeStrategy;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class NamespaceModeStrategy
implements ModeStrategy {
    private final List<FieldInfo> fieldInfos = Arrays.asList(new FieldInfo(Field.NAMESPACE, 0, true), new FieldInfo(Field.REGION_COUNT, 7, true), new FieldInfo(Field.REQUEST_COUNT_PER_SECOND, 10, true), new FieldInfo(Field.READ_REQUEST_COUNT_PER_SECOND, 10, true), new FieldInfo(Field.FILTERED_READ_REQUEST_COUNT_PER_SECOND, 8, true), new FieldInfo(Field.WRITE_REQUEST_COUNT_PER_SECOND, 10, true), new FieldInfo(Field.STORE_FILE_SIZE, 13, true), new FieldInfo(Field.UNCOMPRESSED_STORE_FILE_SIZE, 15, false), new FieldInfo(Field.NUM_STORE_FILES, 7, true), new FieldInfo(Field.MEM_STORE_SIZE, 11, true));
    private final RegionModeStrategy regionModeStrategy = new RegionModeStrategy();

    NamespaceModeStrategy() {
    }

    @Override
    public List<FieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    @Override
    public Field getDefaultSortField() {
        return Field.REQUEST_COUNT_PER_SECOND;
    }

    @Override
    public List<Record> getRecords(ClusterMetrics clusterMetrics, List<RecordFilter> pushDownFilters) {
        List<Record> records = this.regionModeStrategy.selectModeFieldsAndAddCountField(this.fieldInfos, this.regionModeStrategy.getRecords(clusterMetrics, pushDownFilters), Field.REGION_COUNT);
        return ModeStrategyUtils.aggregateRecords(records, Field.NAMESPACE);
    }

    @Override
    public DrillDownInfo drillDown(Record selectedRecord) {
        List<RecordFilter> initialFilters = Collections.singletonList(RecordFilter.newBuilder(Field.NAMESPACE).doubleEquals(selectedRecord.get((Object)Field.NAMESPACE)));
        return new DrillDownInfo(Mode.TABLE, initialFilters);
    }
}

