/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class ResourceCalculator {
    public abstract int compare(Resource var1, Resource var2, Resource var3, boolean var4);

    public int compare(Resource clusterResource, Resource lhs, Resource rhs) {
        return this.compare(clusterResource, lhs, rhs, false);
    }

    public static int divideAndCeil(int a, int b) {
        if (b == 0) {
            return 0;
        }
        return (a + (b - 1)) / b;
    }

    public static int divideAndCeil(int a, float b) {
        if (b == 0.0f) {
            return 0;
        }
        return (int)Math.ceil((float)a / b);
    }

    public static long divideAndCeil(long a, long b) {
        if (b == 0L) {
            return 0L;
        }
        return (a + (b - 1L)) / b;
    }

    public static long divideAndCeil(long a, float b) {
        if (b == 0.0f) {
            return 0L;
        }
        return (long)Math.ceil((float)a / b);
    }

    public static int roundUp(int a, int b) {
        return ResourceCalculator.divideAndCeil(a, b) * b;
    }

    public static long roundUp(long a, long b) {
        return ResourceCalculator.divideAndCeil(a, b) * b;
    }

    public static long roundDown(long a, long b) {
        return a / b * b;
    }

    public static int roundDown(int a, int b) {
        return a / b * b;
    }

    public abstract long computeAvailableContainers(Resource var1, Resource var2);

    public abstract Resource multiplyAndNormalizeUp(Resource var1, double var2, Resource var4);

    public abstract Resource multiplyAndNormalizeDown(Resource var1, double var2, Resource var4);

    public abstract Resource normalize(Resource var1, Resource var2, Resource var3, Resource var4);

    public abstract Resource roundUp(Resource var1, Resource var2);

    public abstract Resource roundDown(Resource var1, Resource var2);

    public abstract float divide(Resource var1, Resource var2, Resource var3);

    public abstract boolean isInvalidDivisor(Resource var1);

    public abstract float ratio(Resource var1, Resource var2);

    public abstract Resource divideAndCeil(Resource var1, int var2);

    public abstract Resource divideAndCeil(Resource var1, float var2);

    public abstract boolean fitsIn(Resource var1, Resource var2, Resource var3);

    public abstract boolean isAnyMajorResourceZero(Resource var1);
}

