/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.over.AbstractNonTimeUnboundedPrecedingOver;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonTimeRowsUnboundedPrecedingFunction<K>
extends AbstractNonTimeUnboundedPrecedingOver<K> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(NonTimeRowsUnboundedPrecedingFunction.class);

    public NonTimeRowsUnboundedPrecedingFunction(long stateRetentionTime, GeneratedAggsHandleFunction genAggsHandler, GeneratedRecordEqualiser genRecordEqualiser, GeneratedRecordEqualiser genSortKeyEqualiser, GeneratedRecordComparator genSortKeyComparator, LogicalType[] accTypes, LogicalType[] inputFieldTypes, LogicalType[] sortKeyTypes, RowDataKeySelector sortKeySelector) {
        super(stateRetentionTime, genAggsHandler, genRecordEqualiser, genSortKeyEqualiser, genSortKeyComparator, accTypes, inputFieldTypes, sortKeyTypes, sortKeySelector, InternalTypeInfo.ofFields(new LogicalType[]{new BigIntType()}));
    }

    @Override
    protected void insertIntoSortedList(RowData insRow, Collector<RowData> out) throws Exception {
        Long id = this.getNextId();
        List<Tuple2<RowData, List<Long>>> sortedList = this.getSortedList();
        RowKind origRowKind = insRow.getRowKind();
        insRow.setRowKind(RowKind.INSERT);
        RowData inputSortKey = (RowData)this.sortKeySelector.getKey((Object)insRow);
        Tuple2<Integer, Boolean> indexForInsertOrUpdate = this.findIndexOfSortKey(sortedList, inputSortKey, false);
        boolean isInsert = (Boolean)indexForInsertOrUpdate.f1;
        int index = (Integer)indexForInsertOrUpdate.f0;
        if (isInsert) {
            if (index == -1) {
                sortedList.add((Tuple2<RowData, List<Long>>)new Tuple2((Object)inputSortKey, List.of(id)));
                index = sortedList.size() - 1;
            } else {
                sortedList.add(index, (Tuple2<RowData, List<Long>>)new Tuple2((Object)inputSortKey, List.of(id)));
            }
            this.setAccumulatorOfPrevId(sortedList, index - 1, -1);
            this.aggFuncs.accumulate(insRow);
            this.collectInsertOrUpdateAfter(out, insRow, origRowKind, this.aggFuncs.getValue());
        } else {
            ArrayList<Long> ids = new ArrayList<Long>((Collection)sortedList.get((int)index).f1);
            ids.add(id);
            sortedList.set(index, (Tuple2<RowData, List<Long>>)new Tuple2((Object)inputSortKey, ids));
            this.setAccumulatorOfPrevId(sortedList, index, ids.size() - 2);
            this.reAccumulateIdsAfterInsert(this.aggFuncs.getAccumulators(), ids, insRow);
            this.emitUpdatesForIds(ids, ids.size() - 1, (RowData)this.accMapState.get((Object)GenericRowData.of((Object[])new Object[]{ids.get(ids.size() - 2)})), this.aggFuncs.getAccumulators(), origRowKind, insRow, out);
        }
        this.valueMapState.put((Object)id, (Object)insRow);
        this.accMapState.put((Object)GenericRowData.of((Object[])new Object[]{id}), (Object)this.aggFuncs.getAccumulators());
        this.sortedListState.update(sortedList);
        id = id + 1L;
        this.idState.update((Object)id);
        this.processRemainingElements(sortedList, index + 1, this.aggFuncs.getAccumulators(), out);
    }

    private void setAccumulatorOfPrevId(List<Tuple2<RowData, List<Long>>> sortedList, int prevIndex, int idIndex) throws Exception {
        RowData prevAcc;
        if (prevIndex < 0) {
            prevAcc = this.aggFuncs.createAccumulators();
        } else {
            int jIndex = idIndex == -1 ? ((List)sortedList.get((int)prevIndex).f1).size() - 1 : idIndex;
            prevAcc = (RowData)this.accMapState.get((Object)GenericRowData.of((Object[])new Object[]{((List)sortedList.get((int)prevIndex).f1).get(jIndex)}));
            if (prevAcc == null) {
                prevAcc = this.aggFuncs.createAccumulators();
            }
        }
        this.aggFuncs.setAccumulators(prevAcc);
    }

    @Override
    void reAccumulateIdsAfterInsert(RowData currAcc, List<Long> ids, RowData insRow) throws Exception {
        this.aggFuncs.setAccumulators(currAcc);
        this.aggFuncs.accumulate(insRow);
    }

    @Override
    void sendUpdatesForIds(List<Long> ids, int idxOfChangedRow, Collector<RowData> out, RowKind rowKind, RowData changedRow, RowData prevAggValue, RowData currAggValue) {
        for (int j = 0; j < ids.size(); ++j) {
            if (j != idxOfChangedRow) continue;
            this.sendUpdateForChangedRow(out, rowKind, changedRow, prevAggValue, currAggValue);
            break;
        }
    }

    @Override
    protected void processRemainingElements(List<Tuple2<RowData, List<Long>>> sortedList, int startPos, RowData currAcc, Collector<RowData> out) throws Exception {
        this.aggFuncs.setAccumulators(currAcc);
        for (int i = startPos; i < sortedList.size(); ++i) {
            Tuple2<RowData, List<Long>> sortKeyAndIds = sortedList.get(i);
            List ids = (List)sortKeyAndIds.f1;
            for (int j = 0; j < ids.size(); ++j) {
                RowData value = (RowData)this.valueMapState.get((Object)((Long)ids.get(j)));
                this.aggFuncs.accumulate(value);
                RowData accData = (RowData)this.accMapState.get((Object)GenericRowData.of((Object[])new Object[]{ids.get(j)}));
                if (this.aggFuncs.getValue().equals(accData)) {
                    LOG.debug("Prev accumulator is same as curr accumulator. Skipping further updates.");
                    return;
                }
                this.collectUpdateBefore(out, value, accData);
                this.collectUpdateAfter(out, value, this.aggFuncs.getValue());
                this.accMapState.put((Object)GenericRowData.of((Object[])new Object[]{ids.get(j)}), (Object)this.aggFuncs.getValue());
            }
        }
    }

    @Override
    void removeFromSortedList(RowData delRow, Collector<RowData> out) throws Exception {
        delRow.setRowKind(RowKind.INSERT);
        RowData inputSortKey = (RowData)this.sortKeySelector.getKey((Object)delRow);
        List<Tuple2<RowData, List<Long>>> sortedList = this.getSortedList();
        int idxOfSortKey = (Integer)this.findIndexOfSortKey(sortedList, (RowData)inputSortKey, (boolean)true).f0;
        if (idxOfSortKey == -1) {
            LOG.debug("Could not find matching sort key. Skipping delete.");
            this.numOfSortKeysNotFound.inc();
            return;
        }
        RowData curSortKey = (RowData)sortedList.get((int)idxOfSortKey).f0;
        ArrayList<Long> ids = new ArrayList<Long>((Collection)sortedList.get((int)idxOfSortKey).f1);
        int removeIndex = this.findIndexOfIdToBeRemoved(ids, delRow);
        if (removeIndex == -1) {
            LOG.info("Could not find matching row to remove. Missing id from sortKey ids list.");
            this.numOfIdsNotFound.inc();
            return;
        }
        RowData prevAcc = this.getPreviousAccumulator(sortedList, idxOfSortKey, removeIndex);
        if (prevAcc == null) {
            prevAcc = this.aggFuncs.createAccumulators();
        }
        this.aggFuncs.setAccumulators(prevAcc);
        this.reAccumulateIdsAndEmitUpdates(ids, removeIndex, out);
        Long deletedId = (Long)ids.remove(removeIndex);
        idxOfSortKey = this.removeIdFromSortedList(sortedList, idxOfSortKey, ids, curSortKey);
        this.valueMapState.remove((Object)deletedId);
        this.accMapState.remove((Object)GenericRowData.of((Object[])new Object[]{deletedId}));
        this.sortedListState.update(sortedList);
        this.processRemainingElements(sortedList, idxOfSortKey, this.aggFuncs.getAccumulators(), out);
    }

    private int findIndexOfIdToBeRemoved(List<Long> ids, RowData delRow) throws Exception {
        for (int j = 0; j < ids.size(); ++j) {
            RowData curValue = (RowData)this.valueMapState.get((Object)ids.get(j));
            if (!this.valueEqualiser.equals(curValue, delRow)) continue;
            return j;
        }
        return -1;
    }

    private RowData getPreviousAccumulator(List<Tuple2<RowData, List<Long>>> sortedList, int i, int j) throws Exception {
        if (j == 0) {
            if (i - 1 < 0) {
                return null;
            }
            Long prevId = (Long)((List)sortedList.get((int)(i - 1)).f1).get(((List)sortedList.get((int)(i - 1)).f1).size() - 1);
            return (RowData)this.accMapState.get((Object)GenericRowData.of((Object[])new Object[]{prevId}));
        }
        return (RowData)this.accMapState.get((Object)GenericRowData.of((Object[])new Object[]{((List)sortedList.get((int)i).f1).get(j - 1)}));
    }

    private void reAccumulateIdsAndEmitUpdates(List<Long> ids, int removeIndex, Collector<RowData> out) throws Exception {
        for (int j = removeIndex; j < ids.size(); ++j) {
            RowData value = (RowData)this.valueMapState.get((Object)ids.get(j));
            if (j == removeIndex) {
                this.collectDelete(out, value, (RowData)this.accMapState.get((Object)GenericRowData.of((Object[])new Object[]{ids.get(j)})));
                continue;
            }
            this.aggFuncs.accumulate(value);
            if (this.aggFuncs.getValue().equals(this.accMapState.get((Object)GenericRowData.of((Object[])new Object[]{ids.get(j)})))) break;
            this.collectUpdateBefore(out, value, (RowData)this.accMapState.get((Object)GenericRowData.of((Object[])new Object[]{ids.get(j)})));
            this.collectUpdateAfter(out, value, this.aggFuncs.getValue());
            this.accMapState.put((Object)GenericRowData.of((Object[])new Object[]{ids.get(j)}), (Object)this.aggFuncs.getValue());
        }
    }
}

