/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.collector.ListenableCollector;
import org.apache.flink.table.runtime.generated.FilterCondition;
import org.apache.flink.table.runtime.generated.GeneratedCollector;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.operators.AbstractFunctionRunner;
import org.apache.flink.util.Collector;

public class LookupJoinRunner
extends AbstractFunctionRunner {
    private static final long serialVersionUID = -4521543015709964733L;
    private final GeneratedCollector<ListenableCollector<RowData>> generatedCollector;
    private final GeneratedFunction<FilterCondition> generatedPreFilterCondition;
    protected final boolean isLeftOuterJoin;
    protected final int tableFieldsCount;
    protected transient ListenableCollector<RowData> collector;
    protected transient JoinedRowData outRow;
    protected transient FilterCondition preFilterCondition;
    protected transient GenericRowData nullRow;

    public LookupJoinRunner(GeneratedFunction<FlatMapFunction<RowData, RowData>> generatedFetcher, GeneratedCollector<ListenableCollector<RowData>> generatedCollector, GeneratedFunction<FilterCondition> generatedPreFilterCondition, boolean isLeftOuterJoin, int tableFieldsCount) {
        super(generatedFetcher);
        this.generatedCollector = generatedCollector;
        this.generatedPreFilterCondition = generatedPreFilterCondition;
        this.isLeftOuterJoin = isLeftOuterJoin;
        this.tableFieldsCount = tableFieldsCount;
    }

    @Override
    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        this.collector = (ListenableCollector)((Object)this.generatedCollector.newInstance(this.getRuntimeContext().getUserCodeClassLoader()));
        this.preFilterCondition = (FilterCondition)this.generatedPreFilterCondition.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        FunctionUtils.setFunctionRuntimeContext(this.collector, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.setFunctionRuntimeContext((Function)this.preFilterCondition, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.collector, (OpenContext)openContext);
        FunctionUtils.openFunction((Function)this.preFilterCondition, (OpenContext)openContext);
        this.nullRow = new GenericRowData(this.tableFieldsCount);
        this.outRow = new JoinedRowData();
    }

    public void processElement(RowData in, ProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        this.prepareCollector(in, out);
        if (this.preFilter(FilterCondition.Context.of(ctx), in)) {
            this.doFetch(in);
        }
        this.padNullForLeftJoin(in, out);
    }

    public void prepareCollector(RowData in, Collector<RowData> out) {
        this.collector.setCollector(out);
        this.collector.setInput(in);
        this.collector.reset();
    }

    public boolean preFilter(FilterCondition.Context ctx, RowData in) throws Exception {
        return this.preFilterCondition.apply(ctx, in);
    }

    public void doFetch(RowData in) throws Exception {
        this.fetcher.flatMap((Object)in, this.getFetcherCollector());
    }

    public void padNullForLeftJoin(RowData in, Collector<RowData> out) {
        if (this.isLeftOuterJoin && !this.collector.isCollected()) {
            this.outRow.replace(in, (RowData)this.nullRow);
            this.outRow.setRowKind(in.getRowKind());
            out.collect((Object)this.outRow);
        }
    }

    public Collector<RowData> getFetcherCollector() {
        return this.collector;
    }

    @Override
    public void close() throws Exception {
        if (this.collector != null) {
            FunctionUtils.closeFunction(this.collector);
        }
        if (this.preFilterCondition != null) {
            FunctionUtils.closeFunction((Function)this.preFilterCondition);
        }
        super.close();
    }
}

