/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.util.Preconditions;

@Internal
public final class ExplicitArgumentTypeStrategy
implements ArgumentTypeStrategy {
    private final DataType expectedDataType;

    public ExplicitArgumentTypeStrategy(DataType expectedDataType) {
        this.expectedDataType = (DataType)Preconditions.checkNotNull((Object)expectedDataType);
    }

    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        LogicalType expectedType = this.expectedDataType.getLogicalType();
        LogicalType actualType = callContext.getArgumentDataTypes().get(argumentPos).getLogicalType();
        if (LogicalTypeCasts.supportsAvoidingCast(actualType, expectedType)) {
            return Optional.of(this.expectedDataType);
        }
        if (!LogicalTypeCasts.supportsImplicitCast(actualType, expectedType)) {
            return callContext.fail(throwOnFailure, "Unsupported argument type. Expected type '%s' but actual type was '%s'.", expectedType, actualType);
        }
        return Optional.of(this.expectedDataType);
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        return Signature.Argument.of(this.expectedDataType.getLogicalType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExplicitArgumentTypeStrategy that = (ExplicitArgumentTypeStrategy)o;
        return Objects.equals(this.expectedDataType, that.expectedDataType);
    }

    public int hashCode() {
        return Objects.hash(this.expectedDataType);
    }
}

