/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sink.constraint;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.sink.constraint.Constraint;
import org.apache.flink.table.runtime.operators.sink.constraint.EnforcerException;

@Internal
final class NestedMapConstraint
implements Constraint {
    private final int[] nestedMapFieldIndices;
    private final String[] nestedMapFieldNames;
    private final Constraint[][] nestedElementsConstraints;
    private final ArrayData.ElementGetter[] valueGetters;
    private final ArrayData.ElementGetter[] keyGetters;

    NestedMapConstraint(int[] nestedMapFieldIndices, String[] nestedMapFieldNames, Constraint[][] nestedElementsConstraints, ArrayData.ElementGetter[] valueGetters, ArrayData.ElementGetter[] keyGetters) {
        this.nestedMapFieldIndices = nestedMapFieldIndices;
        this.nestedMapFieldNames = nestedMapFieldNames;
        this.nestedElementsConstraints = nestedElementsConstraints;
        this.valueGetters = valueGetters;
        this.keyGetters = keyGetters;
    }

    @Override
    @Nullable
    public RowData enforce(RowData input) {
        for (int i = 0; i < this.nestedMapFieldIndices.length; ++i) {
            int index = this.nestedMapFieldIndices[i];
            if (input.isNullAt(index)) continue;
            MapData nestedMap = input.getMap(index);
            Constraint[] nestedConstraints = this.nestedElementsConstraints[i];
            ArrayData.ElementGetter keyGetter = this.keyGetters[i];
            ArrayData.ElementGetter valueGetter = this.valueGetters[i];
            ArrayData keys = nestedMap.keyArray();
            ArrayData values = nestedMap.valueArray();
            for (int entryIdx = 0; entryIdx < nestedMap.size(); ++entryIdx) {
                Object key = keyGetter.getElementOrNull(keys, entryIdx);
                Object value = valueGetter.getElementOrNull(values, entryIdx);
                for (Constraint nestedConstraint : nestedConstraints) {
                    if (this.enforce(nestedConstraint, key, value, i) != null) continue;
                    return null;
                }
            }
        }
        return input;
    }

    private RowData enforce(Constraint nestedConstraint, Object key, Object value, int i) {
        try {
            return nestedConstraint.enforce((RowData)GenericRowData.of((Object[])new Object[]{key, value}));
        }
        catch (EnforcerException e) {
            String adjustedNestedColumnName = NestedMapConstraint.getAdjustedNestedColumnName(e);
            throw new EnforcerException(e.getFormat(), String.format("%s[%s", this.nestedMapFieldNames[i], adjustedNestedColumnName));
        }
    }

    private static String getAdjustedNestedColumnName(EnforcerException e) {
        Object adjustedNestedColumnName = "key".equals(e.getColumnName()) || "value".equals(e.getColumnName()) ? e.getColumnName() + "]" : e.getColumnName().replaceFirst("\\.", "]");
        return adjustedNestedColumnName;
    }

    public String toString() {
        return String.format("NestedMapEnforcer(constraints=[%s])", IntStream.range(0, this.nestedMapFieldIndices.length).mapToObj(idx -> String.format("{%s==%s}", this.nestedMapFieldNames[idx], Arrays.toString(this.nestedElementsConstraints[idx]))).collect(Collectors.joining(", ")));
    }
}

