/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.util.Preconditions;

@Internal
public final class FirstTypeStrategy
implements TypeStrategy {
    private final List<? extends TypeStrategy> typeStrategies;

    public FirstTypeStrategy(List<? extends TypeStrategy> typeStrategies) {
        Preconditions.checkArgument((typeStrategies.size() > 0 ? 1 : 0) != 0);
        this.typeStrategies = typeStrategies;
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        for (TypeStrategy typeStrategy : this.typeStrategies) {
            Optional<DataType> inferredDataType = typeStrategy.inferType(callContext);
            if (!inferredDataType.isPresent()) continue;
            return inferredDataType;
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FirstTypeStrategy that = (FirstTypeStrategy)o;
        return this.typeStrategies.equals(that.typeStrategies);
    }

    public int hashCode() {
        return Objects.hash(this.typeStrategies);
    }
}

