/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class ChangelogMode {
    private static final ChangelogMode INSERT_ONLY = ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).build();
    private static final ChangelogMode UPSERT = ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).keyOnlyDeletes(true).build();
    private static final ChangelogMode UPSERT_WITH_FULL_DELETES = ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).keyOnlyDeletes(false).build();
    private static final ChangelogMode ALL = ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    private final Set<RowKind> kinds;
    private final boolean keyOnlyDeletes;

    private ChangelogMode(Set<RowKind> kinds, boolean keyOnlyDeletes) {
        Preconditions.checkArgument((kinds.size() > 0 ? 1 : 0) != 0, (Object)"At least one kind of row should be contained in a changelog.");
        this.kinds = Collections.unmodifiableSet(kinds);
        this.keyOnlyDeletes = keyOnlyDeletes;
    }

    public static ChangelogMode insertOnly() {
        return INSERT_ONLY;
    }

    public static ChangelogMode upsert() {
        return ChangelogMode.upsert(true);
    }

    public static ChangelogMode upsert(boolean keyOnlyDeletes) {
        if (keyOnlyDeletes) {
            return UPSERT;
        }
        return UPSERT_WITH_FULL_DELETES;
    }

    public static ChangelogMode all() {
        return ALL;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Set<RowKind> getContainedKinds() {
        return this.kinds;
    }

    public boolean contains(RowKind kind) {
        return this.kinds.contains(kind);
    }

    public boolean containsOnly(RowKind kind) {
        return this.kinds.size() == 1 && this.kinds.contains(kind);
    }

    public boolean keyOnlyDeletes() {
        return this.keyOnlyDeletes;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangelogMode that = (ChangelogMode)o;
        return this.keyOnlyDeletes == that.keyOnlyDeletes && this.kinds.equals(that.kinds);
    }

    public int hashCode() {
        int result = this.kinds.hashCode();
        result = 31 * result + Boolean.hashCode(this.keyOnlyDeletes);
        return result;
    }

    public String toString() {
        if (!this.keyOnlyDeletes) {
            return this.kinds.toString();
        }
        return this.kinds.stream().map(kind -> kind == RowKind.DELETE ? "~DELETE" : kind.toString()).collect(Collectors.joining(", ", "[", "]"));
    }

    @PublicEvolving
    public static class Builder {
        private final Set<RowKind> kinds = EnumSet.noneOf(RowKind.class);
        private boolean keyOnlyDeletes = false;

        private Builder() {
        }

        public Builder addContainedKind(RowKind kind) {
            this.kinds.add(kind);
            return this;
        }

        public Builder keyOnlyDeletes(boolean flag) {
            this.keyOnlyDeletes = flag;
            return this;
        }

        public ChangelogMode build() {
            return new ChangelogMode(this.kinds, this.keyOnlyDeletes);
        }
    }
}

