/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.window;

import java.time.ZoneId;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.JoinCondition;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.runtime.operators.join.JoinConditionWithNullFilters;
import org.apache.flink.table.runtime.operators.window.slicing.WindowTimerService;
import org.apache.flink.table.runtime.operators.window.slicing.WindowTimerServiceImpl;
import org.apache.flink.table.runtime.operators.window.state.WindowListState;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.types.RowKind;

public abstract class WindowJoinOperator
extends TableStreamOperator<RowData>
implements TwoInputStreamOperator<RowData, RowData, RowData>,
Triggerable<RowData, Long>,
KeyContext {
    private static final long serialVersionUID = 1L;
    private static final String LEFT_LATE_ELEMENTS_DROPPED_METRIC_NAME = "leftNumLateRecordsDropped";
    private static final String LEFT_LATE_ELEMENTS_DROPPED_RATE_METRIC_NAME = "leftLateRecordsDroppedRate";
    private static final String RIGHT_LATE_ELEMENTS_DROPPED_METRIC_NAME = "rightNumLateRecordsDropped";
    private static final String RIGHT_LATE_ELEMENTS_DROPPED_RATE_METRIC_NAME = "rightLateRecordsDroppedRate";
    private static final String WATERMARK_LATENCY_METRIC_NAME = "watermarkLatency";
    private static final String LEFT_RECORDS_STATE_NAME = "left-records";
    private static final String RIGHT_RECORDS_STATE_NAME = "right-records";
    protected final RowDataSerializer leftSerializer;
    protected final RowDataSerializer rightSerializer;
    private final GeneratedJoinCondition generatedJoinCondition;
    private final int leftWindowEndIndex;
    private final int rightWindowEndIndex;
    private final boolean[] filterNullKeys;
    private final ZoneId shiftTimeZone;
    private transient WindowTimerService<Long> windowTimerService;
    protected transient JoinConditionWithNullFilters joinCondition;
    protected transient TimestampedCollector<RowData> collector;
    private transient WindowListState<Long> leftWindowState;
    private transient WindowListState<Long> rightWindowState;
    private transient Counter leftNumLateRecordsDropped;
    private transient Meter leftLateRecordsDroppedRate;
    private transient Counter rightNumLateRecordsDropped;
    private transient Meter rightLateRecordsDroppedRate;
    private transient Gauge<Long> watermarkLatency;

    WindowJoinOperator(TypeSerializer<RowData> leftSerializer, TypeSerializer<RowData> rightSerializer, GeneratedJoinCondition generatedJoinCondition, int leftWindowEndIndex, int rightWindowEndIndex, boolean[] filterNullKeys, ZoneId shiftTimeZone) {
        this.leftSerializer = (RowDataSerializer)leftSerializer;
        this.rightSerializer = (RowDataSerializer)rightSerializer;
        this.generatedJoinCondition = generatedJoinCondition;
        this.leftWindowEndIndex = leftWindowEndIndex;
        this.rightWindowEndIndex = rightWindowEndIndex;
        this.filterNullKeys = filterNullKeys;
        this.shiftTimeZone = shiftTimeZone;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.collector = new TimestampedCollector(this.output);
        this.collector.eraseTimestamp();
        LongSerializer windowSerializer = LongSerializer.INSTANCE;
        InternalTimerService internalTimerService = this.getInternalTimerService("window-timers", (TypeSerializer)windowSerializer, this);
        this.windowTimerService = new WindowTimerServiceImpl((InternalTimerService<Long>)internalTimerService, this.shiftTimeZone);
        JoinCondition condition = (JoinCondition)this.generatedJoinCondition.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.joinCondition = new JoinConditionWithNullFilters(condition, this.filterNullKeys, this);
        this.joinCondition.setRuntimeContext((RuntimeContext)this.getRuntimeContext());
        this.joinCondition.open(new Configuration());
        ListStateDescriptor leftRecordStateDesc = new ListStateDescriptor(LEFT_RECORDS_STATE_NAME, (TypeSerializer)this.leftSerializer);
        ListState leftListState = (ListState)this.getOrCreateKeyedState((TypeSerializer)windowSerializer, (StateDescriptor)leftRecordStateDesc);
        this.leftWindowState = new WindowListState((InternalListState)leftListState);
        ListStateDescriptor rightRecordStateDesc = new ListStateDescriptor(RIGHT_RECORDS_STATE_NAME, (TypeSerializer)this.rightSerializer);
        ListState rightListState = (ListState)this.getOrCreateKeyedState((TypeSerializer)windowSerializer, (StateDescriptor)rightRecordStateDesc);
        this.rightWindowState = new WindowListState((InternalListState)rightListState);
        this.leftNumLateRecordsDropped = this.metrics.counter(LEFT_LATE_ELEMENTS_DROPPED_METRIC_NAME);
        this.leftLateRecordsDroppedRate = this.metrics.meter(LEFT_LATE_ELEMENTS_DROPPED_RATE_METRIC_NAME, (Meter)new MeterView(this.leftNumLateRecordsDropped));
        this.rightNumLateRecordsDropped = this.metrics.counter(RIGHT_LATE_ELEMENTS_DROPPED_METRIC_NAME);
        this.rightLateRecordsDroppedRate = this.metrics.meter(RIGHT_LATE_ELEMENTS_DROPPED_RATE_METRIC_NAME, (Meter)new MeterView(this.rightNumLateRecordsDropped));
        this.watermarkLatency = this.metrics.gauge(WATERMARK_LATENCY_METRIC_NAME, () -> {
            long watermark = this.windowTimerService.currentWatermark();
            if (watermark < 0L) {
                return 0L;
            }
            return this.windowTimerService.currentProcessingTime() - watermark;
        });
    }

    public void close() throws Exception {
        super.close();
        this.collector = null;
        if (this.joinCondition != null) {
            this.joinCondition.close();
        }
    }

    public void processElement1(StreamRecord<RowData> element) throws Exception {
        this.processElement(element, this.leftWindowEndIndex, this.leftLateRecordsDroppedRate, this.leftWindowState);
    }

    public void processElement2(StreamRecord<RowData> element) throws Exception {
        this.processElement(element, this.rightWindowEndIndex, this.rightLateRecordsDroppedRate, this.rightWindowState);
    }

    private void processElement(StreamRecord<RowData> element, int windowEndIndex, Meter lateRecordsDroppedRate, WindowListState<Long> recordState) throws Exception {
        RowData inputRow = (RowData)element.getValue();
        long windowEnd = inputRow.getLong(windowEndIndex);
        if (TimeWindowUtil.isWindowFired(windowEnd, this.windowTimerService.currentWatermark(), this.shiftTimeZone)) {
            lateRecordsDroppedRate.markEvent();
            return;
        }
        if (!RowDataUtil.isAccumulateMsg(inputRow)) {
            throw new UnsupportedOperationException("This is a bug and should not happen. Please file an issue.");
        }
        recordState.add(windowEnd, inputRow);
        this.windowTimerService.registerEventTimeWindowTimer(windowEnd);
    }

    public void onProcessingTime(InternalTimer<RowData, Long> timer) throws Exception {
        throw new UnsupportedOperationException("This is a bug and should not happen. Please file an issue.");
    }

    public void onEventTime(InternalTimer<RowData, Long> timer) throws Exception {
        this.setCurrentKey(timer.getKey());
        Long window = (Long)timer.getNamespace();
        List<RowData> leftData = this.leftWindowState.get(window);
        List<RowData> rightData = this.rightWindowState.get(window);
        this.join(leftData, rightData);
        if (leftData != null) {
            this.leftWindowState.clear(window);
        }
        if (rightData != null) {
            this.rightWindowState.clear(window);
        }
    }

    public abstract void join(Iterable<RowData> var1, Iterable<RowData> var2);

    static class FullOuterJoinOperator
    extends AbstractOuterJoinOperator {
        private static final long serialVersionUID = 1L;

        FullOuterJoinOperator(TypeSerializer<RowData> leftSerializer, TypeSerializer<RowData> rightSerializer, GeneratedJoinCondition generatedJoinCondition, int leftWindowEndIndex, int rightWindowEndIndex, boolean[] filterNullKeys, ZoneId shiftTimeZone) {
            super(leftSerializer, rightSerializer, generatedJoinCondition, leftWindowEndIndex, rightWindowEndIndex, filterNullKeys, shiftTimeZone);
        }

        @Override
        public void join(Iterable<RowData> leftRecords, Iterable<RowData> rightRecords) {
            if (leftRecords == null && rightRecords == null) {
                return;
            }
            if (rightRecords == null) {
                this.outputNullPadding(leftRecords, true);
            } else if (leftRecords == null) {
                this.outputNullPadding(rightRecords, false);
            } else {
                IdentityHashMap<RowData, Boolean> emittedRightRecords = new IdentityHashMap<RowData, Boolean>();
                for (RowData leftRecord : leftRecords) {
                    boolean matches = false;
                    for (RowData rightRecord : rightRecords) {
                        if (!this.joinCondition.apply(leftRecord, rightRecord)) continue;
                        this.output(leftRecord, rightRecord, true);
                        matches = true;
                        emittedRightRecords.put(rightRecord, Boolean.TRUE);
                    }
                    if (matches) continue;
                    this.outputNullPadding(leftRecord, true);
                }
                for (RowData rightRecord : rightRecords) {
                    if (emittedRightRecords.containsKey(rightRecord)) continue;
                    this.outputNullPadding(rightRecord, false);
                }
            }
        }
    }

    static class RightOuterJoinOperator
    extends AbstractOuterJoinOperator {
        private static final long serialVersionUID = 1L;

        RightOuterJoinOperator(TypeSerializer<RowData> leftSerializer, TypeSerializer<RowData> rightSerializer, GeneratedJoinCondition generatedJoinCondition, int leftWindowEndIndex, int rightWindowEndIndex, boolean[] filterNullKeys, ZoneId shiftTimeZone) {
            super(leftSerializer, rightSerializer, generatedJoinCondition, leftWindowEndIndex, rightWindowEndIndex, filterNullKeys, shiftTimeZone);
        }

        @Override
        public void join(Iterable<RowData> leftRecords, Iterable<RowData> rightRecords) {
            if (rightRecords == null) {
                return;
            }
            if (leftRecords == null) {
                this.outputNullPadding(rightRecords, false);
            } else {
                for (RowData rightRecord : rightRecords) {
                    boolean matches = false;
                    for (RowData leftRecord : leftRecords) {
                        if (!this.joinCondition.apply(leftRecord, rightRecord)) continue;
                        this.output(leftRecord, rightRecord, true);
                        matches = true;
                    }
                    if (matches) continue;
                    this.outputNullPadding(rightRecord, false);
                }
            }
        }
    }

    static class LeftOuterJoinOperator
    extends AbstractOuterJoinOperator {
        private static final long serialVersionUID = 1L;

        LeftOuterJoinOperator(TypeSerializer<RowData> leftSerializer, TypeSerializer<RowData> rightSerializer, GeneratedJoinCondition generatedJoinCondition, int leftWindowEndIndex, int rightWindowEndIndex, boolean[] filterNullKeys, ZoneId shiftTimeZone) {
            super(leftSerializer, rightSerializer, generatedJoinCondition, leftWindowEndIndex, rightWindowEndIndex, filterNullKeys, shiftTimeZone);
        }

        @Override
        public void join(Iterable<RowData> leftRecords, Iterable<RowData> rightRecords) {
            if (leftRecords == null) {
                return;
            }
            if (rightRecords == null) {
                this.outputNullPadding(leftRecords, true);
            } else {
                for (RowData leftRecord : leftRecords) {
                    boolean matches = false;
                    for (RowData rightRecord : rightRecords) {
                        if (!this.joinCondition.apply(leftRecord, rightRecord)) continue;
                        this.output(leftRecord, rightRecord, true);
                        matches = true;
                    }
                    if (matches) continue;
                    this.outputNullPadding(leftRecord, true);
                }
            }
        }
    }

    private static abstract class AbstractOuterJoinOperator
    extends WindowJoinOperator {
        private static final long serialVersionUID = 1L;
        private transient RowData leftNullRow;
        private transient RowData rightNullRow;
        private transient JoinedRowData outRow;

        AbstractOuterJoinOperator(TypeSerializer<RowData> leftSerializer, TypeSerializer<RowData> rightSerializer, GeneratedJoinCondition generatedJoinCondition, int leftWindowEndIndex, int rightWindowEndIndex, boolean[] filterNullKeys, ZoneId shiftTimeZone) {
            super(leftSerializer, rightSerializer, generatedJoinCondition, leftWindowEndIndex, rightWindowEndIndex, filterNullKeys, shiftTimeZone);
        }

        @Override
        public void open() throws Exception {
            super.open();
            this.leftNullRow = new GenericRowData(this.leftSerializer.getArity());
            this.rightNullRow = new GenericRowData(this.rightSerializer.getArity());
            this.outRow = new JoinedRowData();
        }

        protected void outputNullPadding(RowData row, boolean isLeft) {
            if (isLeft) {
                this.outRow.replace(row, this.rightNullRow);
            } else {
                this.outRow.replace(this.leftNullRow, row);
            }
            this.outRow.setRowKind(RowKind.INSERT);
            this.collector.collect((Object)this.outRow);
        }

        protected void outputNullPadding(Iterable<RowData> rows, boolean isLeft) {
            for (RowData row : rows) {
                this.outputNullPadding(row, isLeft);
            }
        }

        protected void output(RowData inputRow, RowData otherRow, boolean inputIsLeft) {
            if (inputIsLeft) {
                this.outRow.replace(inputRow, otherRow);
            } else {
                this.outRow.replace(otherRow, inputRow);
            }
            this.outRow.setRowKind(RowKind.INSERT);
            this.collector.collect((Object)this.outRow);
        }
    }

    static class InnerJoinOperator
    extends WindowJoinOperator {
        private transient JoinedRowData outRow;

        InnerJoinOperator(TypeSerializer<RowData> leftSerializer, TypeSerializer<RowData> rightSerializer, GeneratedJoinCondition generatedJoinCondition, int leftWindowEndIndex, int rightWindowEndIndex, boolean[] filterNullKeys, ZoneId shiftTimeZone) {
            super(leftSerializer, rightSerializer, generatedJoinCondition, leftWindowEndIndex, rightWindowEndIndex, filterNullKeys, shiftTimeZone);
        }

        @Override
        public void open() throws Exception {
            super.open();
            this.outRow = new JoinedRowData();
        }

        @Override
        public void join(Iterable<RowData> leftRecords, Iterable<RowData> rightRecords) {
            if (leftRecords == null || rightRecords == null) {
                return;
            }
            for (RowData leftRecord : leftRecords) {
                for (RowData rightRecord : rightRecords) {
                    if (!this.joinCondition.apply(leftRecord, rightRecord)) continue;
                    this.outRow.setRowKind(RowKind.INSERT);
                    this.outRow.replace(leftRecord, rightRecord);
                    this.collector.collect((Object)this.outRow);
                }
            }
        }
    }

    static class SemiAntiJoinOperator
    extends WindowJoinOperator {
        private final boolean isAntiJoin;

        SemiAntiJoinOperator(TypeSerializer<RowData> leftSerializer, TypeSerializer<RowData> rightSerializer, GeneratedJoinCondition generatedJoinCondition, int leftWindowEndIndex, int rightWindowEndIndex, boolean[] filterNullKeys, boolean isAntiJoin, ZoneId shiftTimeZone) {
            super(leftSerializer, rightSerializer, generatedJoinCondition, leftWindowEndIndex, rightWindowEndIndex, filterNullKeys, shiftTimeZone);
            this.isAntiJoin = isAntiJoin;
        }

        @Override
        public void join(Iterable<RowData> leftRecords, Iterable<RowData> rightRecords) {
            if (leftRecords == null) {
                return;
            }
            if (rightRecords == null) {
                if (this.isAntiJoin) {
                    for (RowData leftRecord : leftRecords) {
                        this.collector.collect((Object)leftRecord);
                    }
                }
                return;
            }
            for (RowData leftRecord : leftRecords) {
                boolean matches = false;
                for (RowData rightRecord : rightRecords) {
                    if (!this.joinCondition.apply(leftRecord, rightRecord)) continue;
                    matches = true;
                    break;
                }
                if (matches) {
                    if (this.isAntiJoin) continue;
                    this.collector.collect((Object)leftRecord);
                    continue;
                }
                if (!this.isAntiJoin) continue;
                this.collector.collect((Object)leftRecord);
            }
        }
    }
}

