/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.reader.splitreader;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.splitreader.SplitsChange;

@PublicEvolving
public interface SplitReader<E, SplitT extends SourceSplit> {
    public RecordsWithSplitIds<E> fetch() throws IOException;

    public void handleSplitsChanges(SplitsChange<SplitT> var1);

    public void wakeUp();

    public void close() throws Exception;

    default public void pauseOrResumeSplits(Collection<SplitT> splitsToPause, Collection<SplitT> splitsToResume) {
        throw new UnsupportedOperationException("This split reader does not support pausing or resuming splits which can lead to unaligned splits.\nUnaligned splits are splits where the output watermarks of the splits have diverged more than the allowed limit.\nIt is highly discouraged to use unaligned source splits, as this leads to unpredictable\nwatermark alignment if there is more than a single split per reader. It is recommended to implement pausing splits\nfor this source. At your own risk, you can allow unaligned source splits by setting the\nconfiguration parameter `pipeline.watermark-alignment.allow-unaligned-source-splits' to true.\nBeware that this configuration parameter will be dropped in a future Flink release.");
    }
}

