/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.datagen.table.types;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.streaming.api.functions.source.datagen.DataGenerator;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.util.Preconditions;

@Internal
public class DecimalDataRandomGenerator
implements DataGenerator<DecimalData> {
    private final int precision;
    private final int scale;
    private final double min;
    private final double max;

    public DecimalDataRandomGenerator(int precision, int scale, double min, double max) {
        Preconditions.checkState((min < max ? 1 : 0) != 0, (Object)String.format("min bound must be less than max [%f, %f]", min, max));
        double largest = Math.pow(10.0, precision - scale) - Math.pow(10.0, -scale);
        this.precision = precision;
        this.scale = scale;
        this.min = Math.max(-1.0 * largest, min);
        this.max = Math.min(largest, max);
    }

    public void open(String name, FunctionInitializationContext context, RuntimeContext runtimeContext) throws Exception {
    }

    public boolean hasNext() {
        return true;
    }

    public DecimalData next() {
        BigDecimal decimal = new BigDecimal(ThreadLocalRandom.current().nextDouble(this.min, this.max), new MathContext(this.precision, RoundingMode.DOWN));
        return DecimalData.fromBigDecimal(decimal, this.precision, this.scale);
    }
}

