/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.obr.internal;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.StringWriter;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Property;
import org.apache.felix.bundlerepository.Reason;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.felix.webconsole.plugins.obr.internal.AbstractBundleRepositoryRenderHelper;
import org.apache.felix.webconsole.plugins.obr.internal.FelixDeployer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

class FelixBundleRepositoryRenderHelper
extends AbstractBundleRepositoryRenderHelper {
    FelixBundleRepositoryRenderHelper(BundleContext bundleContext) {
        super(bundleContext, RepositoryAdmin.class.getName());
    }

    @Override
    String getData(String filter, boolean details, Bundle[] bundles) {
        RepositoryAdmin admin = (RepositoryAdmin)this.getRepositoryAdmin();
        if (admin != null) {
            StringWriter sw = new StringWriter();
            JSONWriter json = new JSONWriter(sw);
            try {
                Resource[] resources;
                json.object();
                json.key("status");
                json.value(true);
                json.key("details");
                json.value(details);
                Repository[] repositories = admin.listRepositories();
                if (repositories != null) {
                    json.key("repositories");
                    json.array();
                    for (int i = 0; repositories != null && i < repositories.length; ++i) {
                        json.object();
                        json.key("lastModified");
                        json.value(repositories[i].getLastModified());
                        json.key("name");
                        json.value(repositories[i].getName());
                        json.key("url");
                        json.value(repositories[i].getURI());
                        json.endObject();
                    }
                    json.endArray();
                }
                if ((resources = admin.discoverResources(filter)) != null) {
                    json.key("resources");
                    json.array();
                    for (int i = 0; i < resources.length; ++i) {
                        this.toJSON(json, resources[i], bundles, details);
                    }
                    json.endArray();
                }
                json.endObject();
                json.flush();
            }
            catch (IOException e) {
                this.logger.info("Failed to serialize repository to JSON object.", (Throwable)e);
            }
            catch (Exception e) {
                this.logger.info("Failed to parse filter '" + filter + "'", (Throwable)e);
                try {
                    String reason = "filter=" + filter;
                    if (e.getMessage() != null) {
                        reason = e.getMessage() + "(" + reason + ")";
                    }
                    json.key("error");
                    json.value(reason);
                    json.endObject();
                    json.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return sw.toString();
        }
        return "{}";
    }

    @Override
    final void doAction(String action, String urlParam) throws IOException, ServletException {
        String uri;
        RepositoryAdmin admin = (RepositoryAdmin)this.getRepositoryAdmin();
        Repository[] repos = admin.listRepositories();
        Repository repo = this.getRepository(repos, urlParam);
        String string = uri = repo != null ? repo.getURI() : urlParam;
        if ("delete".equals(action)) {
            if (!admin.removeRepository(uri)) {
                throw new ServletException("Failed to remove repository with URL " + uri);
            }
        } else if ("add".equals(action) || "refresh".equals(action)) {
            try {
                admin.addRepository(uri);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException("Failed to " + action + " repository " + uri + ": " + e.toString());
            }
        }
    }

    @Override
    final void doDeploy(String[] bundles, boolean start, boolean optional) {
        try {
            if (bundles == null || bundles.length == 0) {
                this.logger.info("No resources to deploy");
                return;
            }
            RepositoryAdmin repoAdmin = (RepositoryAdmin)this.getRepositoryAdmin();
            Resolver resolver = repoAdmin.resolver();
            for (int i = 0; i < bundles.length; ++i) {
                String filter;
                Resource[] resources;
                String bundle = bundles[i];
                if (bundle == null || bundle.equals("-") || (resources = repoAdmin.discoverResources(filter = "(id=" + bundle + ")")) == null || resources.length <= 0) continue;
                resolver.add(resources[0]);
            }
            FelixDeployer.deploy(resolver, start, optional);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private final Repository getRepository(Repository[] repos, String repositoryUrl) {
        if (repositoryUrl == null || repositoryUrl.length() == 0) {
            return null;
        }
        for (int i = 0; i < repos.length; ++i) {
            if (!repositoryUrl.equals(repos[i].getURI())) continue;
            return repos[i];
        }
        return null;
    }

    private final void toJSON(JSONWriter writer, Resource resource, Bundle[] bundles, boolean details) throws IOException {
        String symbolicName = resource.getSymbolicName();
        Version version = resource.getVersion();
        String installed = "";
        for (int i = 0; symbolicName != null && installed.length() == 0 && bundles != null && i < bundles.length; ++i) {
            Version ver = bundles[i].getVersion();
            if (!symbolicName.equals(bundles[i].getSymbolicName())) continue;
            installed = ver.toString();
        }
        writer.object();
        writer.key("id");
        writer.value(resource.getId());
        writer.key("presentationname");
        writer.value(resource.getPresentationName());
        writer.key("symbolicname");
        writer.value(symbolicName);
        writer.key("url");
        writer.value(resource.getURI());
        writer.key("version");
        writer.value(version);
        writer.key("categories");
        writer.value(resource.getCategories());
        writer.key("installed");
        writer.value(installed);
        if (details) {
            Reason[] unsatisfied;
            Resource[] optional;
            Requirement[] reqs;
            Capability[] caps = resource.getCapabilities();
            if (caps != null) {
                writer.key("capabilities");
                writer.array();
                for (int i = 0; i < caps.length; ++i) {
                    writer.object();
                    writer.key("name");
                    writer.value(caps[i].getName());
                    writer.key("properties");
                    this.toJSON(writer, caps[i].getProperties());
                    writer.endObject();
                }
                writer.endArray();
            }
            if ((reqs = resource.getRequirements()) != null) {
                writer.key("requirements");
                writer.array();
                for (int i = 0; i < reqs.length; ++i) {
                    writer.object();
                    writer.key("name");
                    writer.value(reqs[i].getName());
                    writer.key("filter");
                    writer.value(reqs[i].getFilter());
                    writer.key("optional");
                    writer.value(reqs[i].isOptional());
                    writer.endObject();
                }
                writer.endArray();
            }
            RepositoryAdmin admin = (RepositoryAdmin)this.getRepositoryAdmin();
            Resolver resolver = admin.resolver();
            resolver.add(resource);
            resolver.resolve(1);
            Resource[] required = resolver.getRequiredResources();
            if (required != null) {
                writer.key("required");
                writer.array();
                for (int i = 0; required != null && i < required.length; ++i) {
                    this.toJSON(writer, required[i], bundles, false);
                }
                writer.endArray();
            }
            if ((optional = resolver.getOptionalResources()) != null) {
                writer.key("optional");
                writer.array();
                for (int i = 0; optional != null && i < optional.length; ++i) {
                    this.toJSON(writer, optional[i], bundles, false);
                }
                writer.endArray();
            }
            if ((unsatisfied = resolver.getUnsatisfiedRequirements()) != null) {
                writer.key("unsatisfied");
                writer.array();
                for (int i = 0; unsatisfied != null && i < unsatisfied.length; ++i) {
                    writer.object();
                    writer.key("name");
                    writer.value(unsatisfied[i].getRequirement().getName());
                    writer.key("filter");
                    writer.value(unsatisfied[i].getRequirement().getFilter());
                    writer.key("optional");
                    writer.value(unsatisfied[i].getRequirement().isOptional());
                    writer.endObject();
                }
                writer.endArray();
            }
        }
        writer.endObject();
    }

    private void toJSON(JSONWriter writer, Property[] props) throws IOException {
        writer.object();
        for (int i = 0; props != null && i < props.length; ++i) {
            writer.key(props[i].getName());
            writer.value(props[i].getValue());
        }
        writer.endObject();
    }
}

