/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.tester.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import org.apache.felix.upnp.tester.Mediator;
import org.apache.felix.upnp.tester.discovery.DeviceNode;
import org.apache.felix.upnp.tester.gui.ActionPanel;
import org.apache.felix.upnp.tester.gui.DataModel;
import org.apache.felix.upnp.tester.gui.LinkCellRenderer;
import org.apache.felix.upnp.tester.gui.SubscriptionPanel;
import org.apache.felix.upnp.tester.gui.UPnPDeviceTreeNode;
import org.apache.felix.upnp.tester.gui.Util;
import org.osgi.service.upnp.UPnPAction;

public class PropertiesViewer
extends JPanel {
    ActionPanel actionsPanel;
    SubscriptionPanel subscriptionPanel;
    DataModel dataModel;
    JTable table;

    public PropertiesViewer() {
        super(new GridBagLayout());
        this.buildTable();
        this.actionsPanel = new ActionPanel();
        this.subscriptionPanel = new SubscriptionPanel();
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setPreferredSize(new Dimension(500, 200));
        this.actionsPanel.setPreferredSize(new Dimension(500, 200));
        this.add((Component)scroll, Util.setConstrains(0, 0, 6, 2, 100, 50));
        this.add((Component)this.actionsPanel, Util.setConstrains(0, 2, 6, 1, 100, 20));
        this.add((Component)this.subscriptionPanel, Util.setConstrains(0, 3, 6, 1, 100, 5));
        this.showActionPanel(false);
        this.showSubscriptionPanel(false);
        this.table.addMouseMotionListener(new MouseMotionListener(){
            private final Cursor handCursor = new Cursor(12);

            public void mouseDragged(MouseEvent e) {
            }

            public void mouseMoved(MouseEvent e) {
                String link = PropertiesViewer.this.getDataLink(e.getPoint());
                if (link != null) {
                    PropertiesViewer.this.table.setCursor(this.handCursor);
                } else {
                    PropertiesViewer.this.table.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                String link = PropertiesViewer.this.getDataLink(e.getPoint());
                if (link != null) {
                    Util.openUrl(link);
                }
            }
        });
    }

    public String getDataLink(Point p) {
        int col = this.table.columnAtPoint(p);
        if (col != 1) {
            return null;
        }
        int row = this.table.rowAtPoint(p);
        String data = (String)this.dataModel.getValueAt(row, col);
        if (data == null) {
            return null;
        }
        if (data.length() < 4) {
            return null;
        }
        String begin = data.substring(0, 4);
        if (begin.equalsIgnoreCase("http")) {
            return data;
        }
        String propertyName = (String)this.dataModel.getValueAt(row, 0);
        if (propertyName.equalsIgnoreCase("UPnP.presentationURL") || propertyName.equalsIgnoreCase("UPnP.device.manufacturerURL") || propertyName.equalsIgnoreCase("UPnP.device.modelURL")) {
            JTree tree = Mediator.getUPnPDeviceTree();
            UPnPDeviceTreeNode selectedNode = (UPnPDeviceTreeNode)tree.getLastSelectedPathComponent();
            String url = "";
            if (selectedNode.category.equals("DeviceNode")) {
                UPnPDeviceTreeNode parent = (UPnPDeviceTreeNode)selectedNode.getParent();
                while (parent.category != "RootDeviceNode") {
                    parent = (UPnPDeviceTreeNode)parent.getParent();
                }
                DeviceNode device = (DeviceNode)parent.getUserObject();
                String udn = (String)device.getReference().getProperty("UPnP.device.UDN");
                url = Mediator.getDriverProxy().resolveRelativeUrl(udn, data);
                return url;
            }
            if (selectedNode.category.equals("RootDeviceNode")) {
                DeviceNode node = (DeviceNode)selectedNode.getUserObject();
                String udn = (String)node.getReference().getProperty("UPnP.device.UDN");
                url = Mediator.getDriverProxy().resolveRelativeUrl(udn, data);
                return url;
            }
        }
        return null;
    }

    public void setProperties(String[] name, String[] values) {
        this.dataModel.setData(name, values);
    }

    public void setAction(UPnPAction action) {
        this.actionsPanel.setArguments(action);
    }

    public void showActionPanel(boolean show) {
        this.actionsPanel.setVisible(show);
    }

    public void showSubscriptionPanel(boolean show) {
        this.subscriptionPanel.setVisible(show);
    }

    private void buildTable() {
        this.dataModel = new DataModel();
        this.table = new JTable(this.dataModel);
        this.table.setDefaultRenderer(this.table.getColumnClass(1), new LinkCellRenderer());
    }
}

