/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handler.temporal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.FieldInterceptor;
import org.apache.felix.ipojo.MethodInterceptor;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.handler.temporal.TemporalDependency;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.FieldMetadata;
import org.apache.felix.ipojo.parser.MethodMetadata;
import org.apache.felix.ipojo.parser.PojoMetadata;
import org.apache.felix.ipojo.util.DependencyModel;
import org.apache.felix.ipojo.util.DependencyStateListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public class TemporalHandler
extends PrimitiveHandler
implements DependencyStateListener {
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int NO_POLICY = 0;
    public static final int NULLABLE = 1;
    public static final int DEFAULT_IMPLEMENTATION = 2;
    public static final int EMPTY = 3;
    public static final int NULL = 4;
    public static final String NAMESPACE = "org.apache.felix.ipojo.handler.temporal";
    private List m_dependencies = new ArrayList(1);
    static /* synthetic */ Class class$java$util$Collection;

    public void start() {
        for (int i = 0; i < this.m_dependencies.size(); ++i) {
            ((TemporalDependency)((Object)this.m_dependencies.get(i))).start();
        }
    }

    public void stop() {
        for (int i = 0; i < this.m_dependencies.size(); ++i) {
            ((TemporalDependency)((Object)this.m_dependencies.get(i))).stop();
        }
        this.m_dependencies.clear();
    }

    public void configure(Element meta, Dictionary dictionary) throws ConfigurationException {
        PojoMetadata manipulation = this.getFactory().getPojoMetadata();
        Element[] deps = meta.getElements("requires", NAMESPACE);
        for (int i = 0; i < deps.length; ++i) {
            boolean proxy;
            if (!deps[i].containsAttribute("field") || this.m_dependencies.contains(deps[i].getAttribute("field"))) {
                this.error("One temporal dependency must be attached to a field or the field is already used");
                return;
            }
            String field = deps[i].getAttribute("field");
            FieldMetadata fieldmeta = manipulation.getField(field);
            if (fieldmeta == null) {
                this.error("The field " + field + " does not exist in the class " + this.getInstanceManager().getClassName());
                return;
            }
            String fil = deps[i].getAttribute("filter");
            Filter filter = null;
            if (fil != null) {
                try {
                    filter = this.getInstanceManager().getContext().createFilter(fil);
                }
                catch (InvalidSyntaxException e) {
                    this.error("Cannot create the field from " + fil + ": " + e.getMessage());
                    return;
                }
            }
            boolean agg = false;
            boolean collection = false;
            String spec = fieldmeta.getFieldType();
            if (spec.endsWith("[]")) {
                agg = true;
                spec = spec.substring(0, spec.length() - 2);
            } else if ((class$java$util$Collection == null ? TemporalHandler.class$("java.util.Collection") : class$java$util$Collection).getName().equals(spec)) {
                agg = true;
                collection = true;
                spec = deps[i].getAttribute("specification");
                if (spec == null) {
                    this.error("A dependency injected inside a Collection must contain the 'specification' attribute");
                }
            }
            String prox = deps[i].getAttribute("proxy");
            boolean bl = proxy = prox != null && prox.equals("true");
            if (proxy && agg && !collection) {
                this.error("Proxied aggregate temporal dependencies cannot be an array. Only collections are supported");
            }
            long timeout = 3000L;
            if (deps[i].containsAttribute("timeout")) {
                String to = deps[i].getAttribute("timeout");
                timeout = to.equalsIgnoreCase("infinite") || to.equalsIgnoreCase("-1") ? Long.MAX_VALUE : new Long(deps[i].getAttribute("timeout"));
            }
            int policy = 0;
            String di = null;
            String onTimeout = deps[i].getAttribute("onTimeout");
            if (onTimeout != null) {
                if (onTimeout.equalsIgnoreCase("nullable")) {
                    policy = 1;
                } else if (onTimeout.equalsIgnoreCase("empty-array") || onTimeout.equalsIgnoreCase("empty")) {
                    policy = 3;
                    if (!agg) {
                        this.error("Cannot use the empty array policy for " + field + " : non aggregate dependency.");
                    }
                } else if (onTimeout.equalsIgnoreCase("null")) {
                    policy = 4;
                } else if (onTimeout.length() > 0) {
                    di = onTimeout;
                    policy = 2;
                }
            }
            Class specification = DependencyModel.loadSpecification((String)spec, (BundleContext)this.getInstanceManager().getContext());
            TemporalDependency dep = new TemporalDependency(specification, agg, collection, proxy, filter, this.getInstanceManager().getContext(), timeout, policy, di, this);
            this.m_dependencies.add(dep);
            if (!proxy) {
                MethodMetadata[] methods = manipulation.getMethods();
                for (int k = 0; k < methods.length; ++k) {
                    this.getInstanceManager().register(methods[k], (MethodInterceptor)dep);
                }
            }
            this.getInstanceManager().register(fieldmeta, (FieldInterceptor)dep);
        }
    }

    public void invalidate(DependencyModel dependencymodel) {
    }

    public void validate(DependencyModel dependencymodel) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

