/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.component;

import aQute.bnd.component.ReferenceDef;
import aQute.lib.collections.MultiMap;
import aQute.lib.osgi.Analyzer;
import aQute.lib.tag.Tag;
import aQute.libg.version.Version;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.osgi.service.component.annotations.ConfigurationPolicy;

class ComponentDef {
    static final String NAMESPACE_STEM = "http://www.osgi.org/xmlns/scr";
    Version version = new Version("1.1.0");
    String name;
    String factory;
    Boolean immediate;
    Boolean servicefactory;
    ConfigurationPolicy configurationPolicy;
    String implementation;
    String[] service;
    String activate;
    String deactivate;
    String modified;
    Boolean enabled;
    final List<String> properties = new ArrayList<String>();
    final MultiMap<String, String> property = new MultiMap();
    final Map<String, ReferenceDef> references = new TreeMap<String, ReferenceDef>();

    ComponentDef() {
    }

    void prepare(Analyzer analyzer) {
        for (ReferenceDef ref : this.references.values()) {
            ref.prepare(analyzer);
            if (ref.version.compareTo(this.version) <= 0) continue;
            this.version = ref.version;
        }
        if (this.implementation == null) {
            analyzer.error("No Implementation defined for component " + this.name, new Object[0]);
        } else {
            analyzer.referTo(this.implementation);
        }
        this.name = this.implementation;
        if (this.service != null && this.service.length > 0) {
            String[] stringArray = this.service;
            int n = this.service.length;
            int n2 = 0;
            while (n2 < n) {
                String interfaceName = stringArray[n2];
                analyzer.referTo(interfaceName);
                ++n2;
            }
        } else if (this.servicefactory != null && this.servicefactory.booleanValue()) {
            analyzer.warning("The servicefactory:=true directive is set but no service is provided, ignoring it", new Object[0]);
        }
    }

    Tag getTag() {
        Tag component = new Tag("scr:component", new Object[0]);
        component.addAttribute("xmlns:scr", "http://www.osgi.org/xmlns/scr/" + this.version);
        component.addAttribute("name", this.name);
        if (this.servicefactory != null) {
            component.addAttribute("servicefactory", this.servicefactory);
        }
        if (this.configurationPolicy != null) {
            component.addAttribute("configuration-policy", this.configurationPolicy.toString().toLowerCase());
        }
        if (this.enabled != null) {
            component.addAttribute("enabled", this.enabled);
        }
        if (this.immediate != null) {
            component.addAttribute("immediate", this.immediate);
        }
        if (this.factory != null) {
            component.addAttribute("factory", this.factory);
        }
        if (this.activate != null) {
            component.addAttribute("activate", this.activate);
        }
        if (this.deactivate != null) {
            component.addAttribute("deactivate", this.deactivate);
        }
        if (this.modified != null) {
            component.addAttribute("modified", this.modified);
        }
        Tag impl = new Tag(component, "implementation", new Object[0]);
        impl.addAttribute("class", this.implementation);
        if (this.service != null && this.service.length != 0) {
            Tag tag = new Tag(component, "service", new Object[0]);
            if (this.servicefactory != null && this.servicefactory.booleanValue()) {
                tag.addAttribute("servicefactory", true);
            }
            String[] stringArray = this.service;
            int n = this.service.length;
            int n2 = 0;
            while (n2 < n) {
                String ss = stringArray[n2];
                Tag provide = new Tag(tag, "provide", new Object[0]);
                provide.addAttribute("interface", ss);
                ++n2;
            }
        }
        for (ReferenceDef referenceDef : this.references.values()) {
            Tag refTag = referenceDef.getTag();
            component.addContent(refTag);
        }
        for (Map.Entry entry : this.property.entrySet()) {
            Tag property = new Tag(component, "property", new Object[0]);
            String name = (String)entry.getKey();
            String type = null;
            int n = name.indexOf(58);
            if (n > 0) {
                type = name.substring(n + 1);
                name = name.substring(0, n);
            }
            property.addAttribute("name", name);
            if (type != null) {
                property.addAttribute("type", type);
            }
            StringBuffer sb = new StringBuffer();
            String del = "";
            for (String v : (Set)entry.getValue()) {
                sb.append(del);
                sb.append(v);
                del = "\n";
            }
            property.addContent(sb.toString());
        }
        for (String string : this.properties) {
            Tag properties = new Tag(component, "properties", new Object[0]);
            properties.addAttribute("entry", string);
        }
        return component;
    }
}

