/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.extender.internal.queue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.felix.ipojo.extender.internal.LifecycleQueueService;
import org.apache.felix.ipojo.extender.internal.queue.AbstractQueueService;
import org.apache.felix.ipojo.extender.internal.queue.JobInfoCallable;
import org.apache.felix.ipojo.extender.internal.queue.Statistic;
import org.apache.felix.ipojo.extender.queue.Callback;
import org.apache.felix.ipojo.extender.queue.Job;
import org.apache.felix.ipojo.extender.queue.JobInfo;
import org.apache.felix.ipojo.extender.queue.QueueService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorQueueService
extends AbstractQueueService
implements LifecycleQueueService,
ManagedService {
    public static final String THREADPOOL_SIZE_PROPERTY = "org.apache.felix.ipojo.extender.ThreadPoolSize";
    public static final String EXECUTOR_QUEUE_SERVICE_PID = "org.apache.felix.ipojo.extender.ExecutorQueueService";
    private static final int DEFAULT_QUEUE_SIZE = 3;
    private final ThreadPoolExecutor m_executorService;
    private final Statistic m_statistic = new Statistic();
    private Hashtable<String, Object> m_properties;
    private final int initialSize;

    public ExecutorQueueService(BundleContext bundleContext) {
        this(bundleContext, 3);
    }

    public ExecutorQueueService(BundleContext bundleContext, int size) {
        this(bundleContext, (ThreadPoolExecutor)Executors.newFixedThreadPool(size));
    }

    public ExecutorQueueService(BundleContext bundleContext, int size, ThreadFactory threadFactory) {
        this(bundleContext, (ThreadPoolExecutor)Executors.newFixedThreadPool(size, threadFactory));
    }

    private ExecutorQueueService(BundleContext bundleContext, ThreadPoolExecutor executorService) {
        super(bundleContext, QueueService.class);
        this.m_executorService = executorService;
        this.initialSize = executorService.getCorePoolSize();
        this.m_properties = this.getDefaultProperties();
    }

    @Override
    protected ServiceRegistration<?> registerService() {
        return this.getBundleContext().registerService(new String[]{QueueService.class.getName(), ManagedService.class.getName()}, (Object)this, this.getServiceProperties());
    }

    @Override
    public void stop() {
        this.m_executorService.shutdown();
        try {
            this.m_executorService.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.stop();
    }

    @Override
    protected Dictionary<String, ?> getServiceProperties() {
        return this.m_properties;
    }

    private Hashtable<String, Object> getDefaultProperties() {
        Hashtable<String, Object> initial = new Hashtable<String, Object>();
        initial.put("service.pid", EXECUTOR_QUEUE_SERVICE_PID);
        initial.put("ipojo.queue.mode", "async");
        initial.put(THREADPOOL_SIZE_PROPERTY, this.initialSize);
        return initial;
    }

    @Override
    public int getFinished() {
        return this.m_statistic.getFinishedCounter().get();
    }

    @Override
    public int getWaiters() {
        return this.m_statistic.getWaiters().size();
    }

    @Override
    public int getCurrents() {
        return this.m_statistic.getCurrentsCounter().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JobInfo> getWaitersInfo() {
        ArrayList<JobInfo> snapshot;
        List<JobInfo> list = this.m_statistic.getWaiters();
        synchronized (list) {
            snapshot = new ArrayList<JobInfo>(this.m_statistic.getWaiters());
        }
        return Collections.unmodifiableList(snapshot);
    }

    @Override
    public <T> Future<T> submit(Job<T> callable, Callback<T> callback, String description) {
        JobInfoCallable<T> task = new JobInfoCallable<T>(this, this.m_statistic, callable, callback, description);
        return this.m_executorService.submit(task);
    }

    @Override
    public <T> Future<T> submit(Job<T> callable, String description) {
        return this.submit(callable, null, description);
    }

    @Override
    public <T> Future<T> submit(Job<T> callable) {
        return this.submit(callable, "No description");
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        Integer newSize;
        if (properties == null) {
            properties = this.getDefaultProperties();
        }
        boolean changed = false;
        Object o = ((Dictionary)properties).get(THREADPOOL_SIZE_PROPERTY);
        if (o != null && (newSize = this.getIntegerProperty(o, 3)).intValue() != this.m_executorService.getMaximumPoolSize()) {
            this.m_executorService.setCorePoolSize(newSize);
            this.m_executorService.setMaximumPoolSize(newSize);
            this.m_properties.put(THREADPOOL_SIZE_PROPERTY, newSize);
            changed = true;
        }
        if (changed) {
            for (Object key : Collections.list(((Dictionary)properties).keys())) {
                if (THREADPOOL_SIZE_PROPERTY.equals(key)) continue;
                this.m_properties.put(key.toString(), ((Dictionary)properties).get(key));
            }
            this.getRegistration().setProperties(this.m_properties);
        }
    }

    private Integer getIntegerProperty(Object value, Integer defaultValue) throws ConfigurationException {
        Integer newSize = null;
        if (value instanceof Integer) {
            newSize = (Integer)value;
        } else {
            try {
                newSize = Integer.parseInt(value.toString());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return newSize;
    }
}

