/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.bundle.internal;

import org.apache.felix.http.bridge.internal.BridgeActivator;
import org.apache.felix.http.cometd.internal.CometdActivator;
import org.apache.felix.http.jetty.internal.JettyActivator;
import org.apache.felix.http.whiteboard.internal.WhiteboardActivator;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public final class CombinedActivator
implements BundleActivator {
    private static final String JETTY_ENABLED_PROP = "org.apache.felix.http.jettyEnabled";
    private static final String WHITEBOARD_ENABLED_PROP = "org.apache.felix.http.whiteboardEnabled";
    private static final String COMETD_ENABLED_PROP = "org.apache.felix.http.cometdEnabled";
    private BundleActivator jettyActivator;
    private BundleActivator bridgeActivator;
    private BundleActivator whiteboardActivator;
    private BundleActivator cometdActivator;

    public void start(BundleContext context) throws Exception {
        if ("true".equals(context.getProperty(JETTY_ENABLED_PROP))) {
            this.jettyActivator = new JettyActivator();
        } else {
            this.bridgeActivator = new BridgeActivator();
        }
        if ("true".equals(context.getProperty(WHITEBOARD_ENABLED_PROP))) {
            this.whiteboardActivator = new WhiteboardActivator();
        }
        if ("true".equals(context.getProperty(COMETD_ENABLED_PROP))) {
            this.cometdActivator = new CometdActivator();
        }
        if (this.jettyActivator != null) {
            this.jettyActivator.start(context);
        }
        if (this.bridgeActivator != null) {
            this.bridgeActivator.start(context);
        }
        if (this.whiteboardActivator != null) {
            this.whiteboardActivator.start(context);
        }
        if (this.cometdActivator != null) {
            this.cometdActivator.start(context);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.cometdActivator != null) {
            this.cometdActivator.stop(context);
        }
        if (this.whiteboardActivator != null) {
            this.whiteboardActivator.stop(context);
        }
        if (this.jettyActivator != null) {
            this.jettyActivator.stop(context);
        }
        if (this.bridgeActivator != null) {
            this.bridgeActivator.stop(context);
        }
    }
}

