SELECT * 
    FROM
    ( 
        SELECT 
            SUM(c2) OVER w, 
            MIN(c2) OVER (PARTITION BY c8 ORDER BY c2 DESC NULLS FIRST RANGE BETWEEN CURRENT ROW AND CURRENT ROW), 
            MAX(c2) OVER (PARTITION BY c8 ORDER BY c2 ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW), 
            AVG(c2) OVER (PARTITION BY c8 ORDER BY c2 DESC NULLS FIRST RANGE BETWEEN CURRENT ROW AND CURRENT ROW), 
            COUNT(c2) OVER w as w_count,
            FIRST_VALUE(c2) OVER (PARTITION BY c8 ORDER BY c2 ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW),
            LAST_VALUE(c2) OVER w as w_lval_c2
        FROM
            "t_alltype.parquet"
        WHERE
            c8 IS not NULL    
        WINDOW w AS (PARTITION BY c8 ORDER BY c2 DESC NULLS FIRST RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING)
    ) subqry
    WHERE subqry.w_count > 67
