/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.protobuf;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Duration;
import com.google.protobuf.FieldMask;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ListValue;
import com.google.protobuf.Message;
import com.google.protobuf.StringValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.Value;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.FieldMaskUtil;
import com.google.protobuf.util.JsonFormat;
import com.google.protobuf.util.Timestamps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProtobufConverter {
    private static final Map<String, SpecializedConverter> SPECIAL_CONVERSIONS = ProtobufConverter.buildSpecializedConversions();

    @Nullable
    public static Map<String, Object> convertMessage(Message msg) throws InvalidProtocolBufferException {
        if (msg == null) {
            return null;
        }
        Map<Descriptors.FieldDescriptor, Object> fields = msg.getAllFields();
        HashMap converted = Maps.newHashMapWithExpectedSize((int)fields.size());
        for (Map.Entry<Descriptors.FieldDescriptor, Object> field : fields.entrySet()) {
            converted.put(field.getKey().getJsonName(), ProtobufConverter.convertField(field.getKey(), field.getValue()));
        }
        return converted;
    }

    @Nullable
    private static Object convertField(Descriptors.FieldDescriptor field, Object value) throws InvalidProtocolBufferException {
        Message msg;
        String typeName;
        SpecializedConverter converter;
        if (value instanceof Message && (converter = SPECIAL_CONVERSIONS.get(typeName = (msg = (Message)value).getDescriptorForType().getFullName())) != null) {
            return converter.convert(msg);
        }
        if (field.isMapField()) {
            return ProtobufConverter.convertMap(field, value);
        }
        if (field.isRepeated()) {
            return ProtobufConverter.convertList(field, (List)value);
        }
        return ProtobufConverter.convertSingleValue(field, value);
    }

    @Nonnull
    private static List<Object> convertList(Descriptors.FieldDescriptor field, List<?> value) throws InvalidProtocolBufferException {
        ArrayList theList = Lists.newArrayListWithExpectedSize((int)value.size());
        for (Object element : value) {
            theList.add(ProtobufConverter.convertSingleValue(field, element));
        }
        return theList;
    }

    @Nullable
    private static Object convertMap(Descriptors.FieldDescriptor field, Object value) throws InvalidProtocolBufferException {
        Descriptors.Descriptor type = field.getMessageType();
        Descriptors.FieldDescriptor keyField = type.findFieldByName("key");
        Descriptors.FieldDescriptor valueField = type.findFieldByName("value");
        if (keyField == null || valueField == null) {
            throw new InvalidProtocolBufferException("Invalid map field.");
        }
        List elements = (List)value;
        HashMap theMap = Maps.newHashMapWithExpectedSize((int)elements.size());
        for (Object element : elements) {
            Message entry = (Message)element;
            theMap.put((String)ProtobufConverter.convertSingleValue(keyField, entry.getField(keyField)), ProtobufConverter.convertSingleValue(valueField, entry.getField(valueField)));
        }
        return theMap;
    }

    @Nullable
    private static Object convertSingleValue(Descriptors.FieldDescriptor field, Object value) throws InvalidProtocolBufferException {
        switch (field.getType()) {
            case BYTES: {
                return ((ByteString)value).toByteArray();
            }
            case ENUM: {
                if ("google.protobuf.NullValue".equals(field.getEnumType().getFullName())) {
                    return null;
                }
                return ((Descriptors.EnumValueDescriptor)value).getName();
            }
            case MESSAGE: 
            case GROUP: {
                return ProtobufConverter.convertMessage((Message)value);
            }
        }
        return value;
    }

    private static Map<String, SpecializedConverter> buildSpecializedConversions() {
        HashMap<String, SpecializedConverter> converters = new HashMap<String, SpecializedConverter>();
        SpecializedConverter parappaTheWrappa = msg -> {
            Descriptors.Descriptor descriptor = msg.getDescriptorForType();
            Descriptors.FieldDescriptor valueField = descriptor.findFieldByName("value");
            if (valueField == null) {
                throw new InvalidProtocolBufferException("Invalid Wrapper type.");
            }
            return ProtobufConverter.convertSingleValue(valueField, msg.getField(valueField));
        };
        converters.put(BoolValue.getDescriptor().getFullName(), parappaTheWrappa);
        converters.put(Int32Value.getDescriptor().getFullName(), parappaTheWrappa);
        converters.put(UInt32Value.getDescriptor().getFullName(), parappaTheWrappa);
        converters.put(Int64Value.getDescriptor().getFullName(), parappaTheWrappa);
        converters.put(UInt64Value.getDescriptor().getFullName(), parappaTheWrappa);
        converters.put(StringValue.getDescriptor().getFullName(), parappaTheWrappa);
        converters.put(BytesValue.getDescriptor().getFullName(), parappaTheWrappa);
        converters.put(FloatValue.getDescriptor().getFullName(), parappaTheWrappa);
        converters.put(DoubleValue.getDescriptor().getFullName(), parappaTheWrappa);
        converters.put(Any.getDescriptor().getFullName(), msg -> JsonFormat.printer().print(msg));
        converters.put(Timestamp.getDescriptor().getFullName(), msg -> {
            Timestamp ts = Timestamp.parseFrom(msg.toByteString());
            return Timestamps.toString(ts);
        });
        converters.put(Duration.getDescriptor().getFullName(), msg -> {
            Duration duration = Duration.parseFrom(msg.toByteString());
            return Durations.toString(duration);
        });
        converters.put(FieldMask.getDescriptor().getFullName(), msg -> FieldMaskUtil.toJsonString(FieldMask.parseFrom(msg.toByteString())));
        converters.put(Struct.getDescriptor().getFullName(), msg -> {
            Descriptors.Descriptor descriptor = msg.getDescriptorForType();
            Descriptors.FieldDescriptor field = descriptor.findFieldByName("fields");
            if (field == null) {
                throw new InvalidProtocolBufferException("Invalid Struct type.");
            }
            return ProtobufConverter.convertSingleValue(field, msg.getField(field));
        });
        converters.put(Value.getDescriptor().getFullName(), msg -> {
            Map<Descriptors.FieldDescriptor, Object> fields = msg.getAllFields();
            if (fields.isEmpty()) {
                return null;
            }
            if (fields.size() != 1) {
                throw new InvalidProtocolBufferException("Invalid Value type.");
            }
            Map.Entry entry = (Map.Entry)fields.entrySet().stream().findFirst().get();
            return ProtobufConverter.convertSingleValue((Descriptors.FieldDescriptor)entry.getKey(), entry.getValue());
        });
        converters.put(ListValue.getDescriptor().getFullName(), msg -> {
            Descriptors.Descriptor descriptor = msg.getDescriptorForType();
            Descriptors.FieldDescriptor field = descriptor.findFieldByName("values");
            if (field == null) {
                throw new InvalidProtocolBufferException("Invalid ListValue type.");
            }
            return ProtobufConverter.convertList(field, (List)msg.getField(field));
        });
        return converters;
    }

    @FunctionalInterface
    static interface SpecializedConverter {
        @Nullable
        public Object convert(Message var1) throws InvalidProtocolBufferException;
    }
}

