/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Doubles;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchEstimateWithErrorBounds;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolder;
import org.apache.druid.query.aggregation.datasketches.theta.SketchModule;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

public class SketchEstimatePostAggregator
implements PostAggregator {
    private final String name;
    private final PostAggregator field;
    @Nullable
    private final Integer errorBoundsStdDev;

    @JsonCreator
    public SketchEstimatePostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="field") PostAggregator field, @JsonProperty(value="errorBoundsStdDev") @Nullable Integer errorBoundsStdDev) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.field = (PostAggregator)Preconditions.checkNotNull((Object)field, (Object)"field is null");
        this.errorBoundsStdDev = errorBoundsStdDev;
    }

    public Set<String> getDependentFields() {
        return new HashSet<String>(this.field.getDependentFields());
    }

    public Comparator getComparator() {
        if (this.errorBoundsStdDev == null) {
            return Ordering.natural();
        }
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return Doubles.compare((double)((SketchEstimateWithErrorBounds)o1).getEstimate(), (double)((SketchEstimateWithErrorBounds)o2).getEstimate());
            }
        };
    }

    public Object compute(Map<String, Object> combinedAggregators) {
        SketchHolder holder = (SketchHolder)this.field.compute(combinedAggregators);
        if (this.errorBoundsStdDev != null) {
            return holder.getEstimateWithErrorBounds(this.errorBoundsStdDev);
        }
        return holder.getEstimate();
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public ColumnType getType(ColumnInspector signature) {
        return this.errorBoundsStdDev != null ? SketchModule.MERGE_TYPE : ColumnType.DOUBLE;
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    @JsonProperty
    public PostAggregator getField() {
        return this.field;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getErrorBoundsStdDev() {
        return this.errorBoundsStdDev;
    }

    public String toString() {
        return "SketchEstimatePostAggregator{name='" + this.name + "', field=" + String.valueOf(this.field) + ", errorBoundsStdDev=" + this.errorBoundsStdDev + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SketchEstimatePostAggregator that = (SketchEstimatePostAggregator)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.errorBoundsStdDev == null ^ that.errorBoundsStdDev == null) {
            return false;
        }
        if (this.errorBoundsStdDev != null && that.errorBoundsStdDev != null && this.errorBoundsStdDev.intValue() != that.errorBoundsStdDev.intValue()) {
            return false;
        }
        return this.field.equals((Object)that.field);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + (this.errorBoundsStdDev != null ? this.errorBoundsStdDev.hashCode() : 0);
        return result;
    }

    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(17).appendCacheable((Cacheable)this.field);
        return this.errorBoundsStdDev == null ? builder.build() : builder.appendInt(this.errorBoundsStdDev.intValue()).build();
    }
}

