/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.kll;

import javax.annotation.Nullable;
import org.apache.datasketches.kll.KllSketch;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.kll.KllSketchNoOpAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllSketchNoOpBufferAggregator;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.NilColumnValueSelector;

abstract class KllSketchMergeAggregatorFactory<SketchType extends KllSketch, ValueType>
extends KllSketchAggregatorFactory<SketchType, ValueType> {
    public KllSketchMergeAggregatorFactory(String name, String fieldName, @Nullable Integer k, @Nullable Long maxStreamLength, byte cacheTypeId) {
        super(name, fieldName, k, maxStreamLength, cacheTypeId);
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.getFieldName());
        if (selector instanceof NilColumnValueSelector) {
            return new KllSketchNoOpAggregator(this.getEmptySketch());
        }
        return this.getMergeAggregator(selector);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.getFieldName());
        if (selector instanceof NilColumnValueSelector) {
            return new KllSketchNoOpBufferAggregator(this.getEmptySketch());
        }
        return this.getMergeBufferAggregator(selector);
    }
}

