/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kinesis.model.MetricsName;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DisableEnhancedMonitoringResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String streamName;
    private SdkInternalList<String> currentShardLevelMetrics;
    private SdkInternalList<String> desiredShardLevelMetrics;
    private String streamARN;

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public DisableEnhancedMonitoringResult withStreamName(String streamName) {
        this.setStreamName(streamName);
        return this;
    }

    public List<String> getCurrentShardLevelMetrics() {
        if (this.currentShardLevelMetrics == null) {
            this.currentShardLevelMetrics = new SdkInternalList();
        }
        return this.currentShardLevelMetrics;
    }

    public void setCurrentShardLevelMetrics(Collection<String> currentShardLevelMetrics) {
        if (currentShardLevelMetrics == null) {
            this.currentShardLevelMetrics = null;
            return;
        }
        this.currentShardLevelMetrics = new SdkInternalList(currentShardLevelMetrics);
    }

    public DisableEnhancedMonitoringResult withCurrentShardLevelMetrics(String ... currentShardLevelMetrics) {
        if (this.currentShardLevelMetrics == null) {
            this.setCurrentShardLevelMetrics((Collection<String>)new SdkInternalList(currentShardLevelMetrics.length));
        }
        for (String ele : currentShardLevelMetrics) {
            this.currentShardLevelMetrics.add((Object)ele);
        }
        return this;
    }

    public DisableEnhancedMonitoringResult withCurrentShardLevelMetrics(Collection<String> currentShardLevelMetrics) {
        this.setCurrentShardLevelMetrics(currentShardLevelMetrics);
        return this;
    }

    public DisableEnhancedMonitoringResult withCurrentShardLevelMetrics(MetricsName ... currentShardLevelMetrics) {
        SdkInternalList currentShardLevelMetricsCopy = new SdkInternalList(currentShardLevelMetrics.length);
        for (MetricsName value : currentShardLevelMetrics) {
            currentShardLevelMetricsCopy.add((Object)value.toString());
        }
        if (this.getCurrentShardLevelMetrics() == null) {
            this.setCurrentShardLevelMetrics((Collection<String>)currentShardLevelMetricsCopy);
        } else {
            this.getCurrentShardLevelMetrics().addAll((Collection<String>)currentShardLevelMetricsCopy);
        }
        return this;
    }

    public List<String> getDesiredShardLevelMetrics() {
        if (this.desiredShardLevelMetrics == null) {
            this.desiredShardLevelMetrics = new SdkInternalList();
        }
        return this.desiredShardLevelMetrics;
    }

    public void setDesiredShardLevelMetrics(Collection<String> desiredShardLevelMetrics) {
        if (desiredShardLevelMetrics == null) {
            this.desiredShardLevelMetrics = null;
            return;
        }
        this.desiredShardLevelMetrics = new SdkInternalList(desiredShardLevelMetrics);
    }

    public DisableEnhancedMonitoringResult withDesiredShardLevelMetrics(String ... desiredShardLevelMetrics) {
        if (this.desiredShardLevelMetrics == null) {
            this.setDesiredShardLevelMetrics((Collection<String>)new SdkInternalList(desiredShardLevelMetrics.length));
        }
        for (String ele : desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics.add((Object)ele);
        }
        return this;
    }

    public DisableEnhancedMonitoringResult withDesiredShardLevelMetrics(Collection<String> desiredShardLevelMetrics) {
        this.setDesiredShardLevelMetrics(desiredShardLevelMetrics);
        return this;
    }

    public DisableEnhancedMonitoringResult withDesiredShardLevelMetrics(MetricsName ... desiredShardLevelMetrics) {
        SdkInternalList desiredShardLevelMetricsCopy = new SdkInternalList(desiredShardLevelMetrics.length);
        for (MetricsName value : desiredShardLevelMetrics) {
            desiredShardLevelMetricsCopy.add((Object)value.toString());
        }
        if (this.getDesiredShardLevelMetrics() == null) {
            this.setDesiredShardLevelMetrics((Collection<String>)desiredShardLevelMetricsCopy);
        } else {
            this.getDesiredShardLevelMetrics().addAll((Collection<String>)desiredShardLevelMetricsCopy);
        }
        return this;
    }

    public void setStreamARN(String streamARN) {
        this.streamARN = streamARN;
    }

    public String getStreamARN() {
        return this.streamARN;
    }

    public DisableEnhancedMonitoringResult withStreamARN(String streamARN) {
        this.setStreamARN(streamARN);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStreamName() != null) {
            sb.append("StreamName: ").append(this.getStreamName()).append(",");
        }
        if (this.getCurrentShardLevelMetrics() != null) {
            sb.append("CurrentShardLevelMetrics: ").append(this.getCurrentShardLevelMetrics()).append(",");
        }
        if (this.getDesiredShardLevelMetrics() != null) {
            sb.append("DesiredShardLevelMetrics: ").append(this.getDesiredShardLevelMetrics()).append(",");
        }
        if (this.getStreamARN() != null) {
            sb.append("StreamARN: ").append(this.getStreamARN());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableEnhancedMonitoringResult)) {
            return false;
        }
        DisableEnhancedMonitoringResult other = (DisableEnhancedMonitoringResult)obj;
        if (other.getStreamName() == null ^ this.getStreamName() == null) {
            return false;
        }
        if (other.getStreamName() != null && !other.getStreamName().equals(this.getStreamName())) {
            return false;
        }
        if (other.getCurrentShardLevelMetrics() == null ^ this.getCurrentShardLevelMetrics() == null) {
            return false;
        }
        if (other.getCurrentShardLevelMetrics() != null && !other.getCurrentShardLevelMetrics().equals(this.getCurrentShardLevelMetrics())) {
            return false;
        }
        if (other.getDesiredShardLevelMetrics() == null ^ this.getDesiredShardLevelMetrics() == null) {
            return false;
        }
        if (other.getDesiredShardLevelMetrics() != null && !other.getDesiredShardLevelMetrics().equals(this.getDesiredShardLevelMetrics())) {
            return false;
        }
        if (other.getStreamARN() == null ^ this.getStreamARN() == null) {
            return false;
        }
        return other.getStreamARN() == null || other.getStreamARN().equals(this.getStreamARN());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStreamName() == null ? 0 : this.getStreamName().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentShardLevelMetrics() == null ? 0 : this.getCurrentShardLevelMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredShardLevelMetrics() == null ? 0 : this.getDesiredShardLevelMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getStreamARN() == null ? 0 : this.getStreamARN().hashCode());
        return hashCode;
    }

    public DisableEnhancedMonitoringResult clone() {
        try {
            return (DisableEnhancedMonitoringResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

