/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup.namespace;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.query.lookup.namespace.ExtractionNamespace;
import org.apache.druid.server.initialization.JdbcAccessSecurityConfig;
import org.apache.druid.utils.ConnectionUriUtils;
import org.joda.time.Period;

@JsonTypeName(value="jdbc")
public class JdbcExtractionNamespace
implements ExtractionNamespace {
    private static final Logger LOG = new Logger(JdbcExtractionNamespace.class);
    long DEFAULT_MAX_HEAP_PERCENTAGE = 10L;
    long DEFAULT_LOOKUP_LOAD_TIME_SECONDS = 120L;
    @JsonProperty
    private final MetadataStorageConnectorConfig connectorConfig;
    @JsonProperty
    private final String table;
    @JsonProperty
    private final String keyColumn;
    @JsonProperty
    private final String valueColumn;
    @JsonProperty
    private final String tsColumn;
    @JsonProperty
    private final String filter;
    @JsonProperty
    private final Period pollPeriod;
    @JsonProperty
    private final long maxHeapPercentage;
    @JsonProperty
    private final long loadTimeoutSeconds;
    @JsonProperty
    private final int jitterSeconds;

    @JsonCreator
    public JdbcExtractionNamespace(@NotNull @JsonProperty(value="connectorConfig", required=true) MetadataStorageConnectorConfig connectorConfig, @NotNull @JsonProperty(value="table", required=true) String table, @NotNull @JsonProperty(value="keyColumn", required=true) String keyColumn, @NotNull @JsonProperty(value="valueColumn", required=true) String valueColumn, @JsonProperty(value="tsColumn") @Nullable String tsColumn, @JsonProperty(value="filter") @Nullable String filter, @Min(value=0L) @JsonProperty(value="pollPeriod") @Nullable @Min(value=0L) Period pollPeriod, @JsonProperty(value="maxHeapPercentage") @Nullable Long maxHeapPercentage, @JsonProperty(value="jitterSeconds") @Nullable Integer jitterSeconds, @JsonProperty(value="loadTimeoutSeconds") @Nullable Long loadTimeoutSeconds, @JacksonInject JdbcAccessSecurityConfig securityConfig) {
        this.connectorConfig = (MetadataStorageConnectorConfig)Preconditions.checkNotNull((Object)connectorConfig, (Object)"connectorConfig");
        JdbcExtractionNamespace.checkConnectionURL(connectorConfig.getConnectURI(), securityConfig);
        this.table = (String)Preconditions.checkNotNull((Object)table, (Object)"table");
        this.keyColumn = (String)Preconditions.checkNotNull((Object)keyColumn, (Object)"keyColumn");
        this.valueColumn = (String)Preconditions.checkNotNull((Object)valueColumn, (Object)"valueColumn");
        this.tsColumn = tsColumn;
        this.filter = filter;
        if (pollPeriod == null) {
            LOG.warn("No pollPeriod configured for JdbcExtractionNamespace - entries will be loaded only once at startup", new Object[0]);
            this.pollPeriod = new Period(0L);
        } else {
            this.pollPeriod = pollPeriod;
        }
        this.jitterSeconds = jitterSeconds == null ? 0 : jitterSeconds;
        this.maxHeapPercentage = maxHeapPercentage == null ? this.DEFAULT_MAX_HEAP_PERCENTAGE : maxHeapPercentage;
        this.loadTimeoutSeconds = loadTimeoutSeconds == null ? this.DEFAULT_LOOKUP_LOAD_TIME_SECONDS : loadTimeoutSeconds;
    }

    private static void checkConnectionURL(String url, JdbcAccessSecurityConfig securityConfig) {
        Preconditions.checkNotNull((Object)url, (Object)"connectorConfig.connectURI");
        if (!securityConfig.isEnforceAllowedProperties()) {
            return;
        }
        ConnectionUriUtils.throwIfPropertiesAreNotAllowed((Set)ConnectionUriUtils.tryParseJdbcUriParameters((String)url, (boolean)securityConfig.isAllowUnknownJdbcUrlFormat()), (Set)securityConfig.getSystemPropertyPrefixes(), (Set)securityConfig.getAllowedProperties());
    }

    public MetadataStorageConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public String getTable() {
        return this.table;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public String getValueColumn() {
        return this.valueColumn;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getTsColumn() {
        return this.tsColumn;
    }

    @Override
    public long getPollMs() {
        return this.pollPeriod.toStandardDuration().getMillis();
    }

    @Override
    public long getMaxHeapPercentage() {
        return this.maxHeapPercentage;
    }

    @Override
    public long getJitterMills() {
        if (this.jitterSeconds == 0) {
            return this.jitterSeconds;
        }
        return 1000L * (long)ThreadLocalRandom.current().nextInt(this.jitterSeconds + 1);
    }

    @Override
    public long getLoadTimeoutMills() {
        return 1000L * this.loadTimeoutSeconds;
    }

    public String toString() {
        return "JdbcExtractionNamespace{connectorConfig=" + String.valueOf(this.connectorConfig) + ", table='" + this.table + "', keyColumn='" + this.keyColumn + "', valueColumn='" + this.valueColumn + "', tsColumn='" + this.tsColumn + "', filter='" + this.filter + "', pollPeriod=" + String.valueOf(this.pollPeriod) + ", jitterSeconds=" + this.jitterSeconds + ", loadTimeoutSeconds=" + this.loadTimeoutSeconds + ", maxHeapPercentage=" + this.maxHeapPercentage + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcExtractionNamespace that = (JdbcExtractionNamespace)o;
        return Objects.equals(this.connectorConfig, that.connectorConfig) && Objects.equals(this.table, that.table) && Objects.equals(this.filter, that.filter) && Objects.equals(this.keyColumn, that.keyColumn) && Objects.equals(this.valueColumn, that.valueColumn) && Objects.equals(this.tsColumn, that.tsColumn) && Objects.equals(this.pollPeriod, that.pollPeriod) && Objects.equals(this.maxHeapPercentage, that.maxHeapPercentage);
    }

    public int hashCode() {
        return Objects.hash(this.connectorConfig, this.table, this.filter, this.keyColumn, this.valueColumn, this.tsColumn, this.pollPeriod, this.maxHeapPercentage);
    }
}

