/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.ScalingConfigurationInfo;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ScalingConfigurationInfoStaxUnmarshaller
implements Unmarshaller<ScalingConfigurationInfo, StaxUnmarshallerContext> {
    private static ScalingConfigurationInfoStaxUnmarshaller instance;

    public ScalingConfigurationInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        ScalingConfigurationInfo scalingConfigurationInfo = new ScalingConfigurationInfo();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return scalingConfigurationInfo;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("MinCapacity", targetDepth)) {
                    scalingConfigurationInfo.setMinCapacity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxCapacity", targetDepth)) {
                    scalingConfigurationInfo.setMaxCapacity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AutoPause", targetDepth)) {
                    scalingConfigurationInfo.setAutoPause(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SecondsUntilAutoPause", targetDepth)) {
                    scalingConfigurationInfo.setSecondsUntilAutoPause(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TimeoutAction", targetDepth)) {
                    scalingConfigurationInfo.setTimeoutAction(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SecondsBeforeTimeout", targetDepth)) continue;
                scalingConfigurationInfo.setSecondsBeforeTimeout(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return scalingConfigurationInfo;
    }

    public static ScalingConfigurationInfoStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ScalingConfigurationInfoStaxUnmarshaller();
        }
        return instance;
    }
}

