/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.DocLink;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class DocLinkStaxUnmarshaller
implements Unmarshaller<DocLink, StaxUnmarshallerContext> {
    private static DocLinkStaxUnmarshaller instance;

    public DocLink unmarshall(StaxUnmarshallerContext context) throws Exception {
        DocLink docLink = new DocLink();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return docLink;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Text", targetDepth)) {
                    docLink.setText(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Url", targetDepth)) continue;
                docLink.setUrl(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return docLink;
    }

    public static DocLinkStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DocLinkStaxUnmarshaller();
        }
        return instance;
    }
}

