/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Random;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.quantiles.ClassicUtil;
import org.apache.datasketches.quantiles.ItemsByteArrayImpl;
import org.apache.datasketches.quantiles.ItemsMergeImpl;
import org.apache.datasketches.quantiles.ItemsUtil;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantiles.QuantilesItemsSketchIterator;
import org.apache.datasketches.quantilescommon.GenericPartitionBoundaries;
import org.apache.datasketches.quantilescommon.ItemsSketchSortedView;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesGenericAPI;
import org.apache.datasketches.quantilescommon.QuantilesGenericSketchIteratorAPI;

public final class QuantilesItemsSketch<T>
implements QuantilesGenericAPI<T> {
    final Class<T> clazz;
    private final Comparator<? super T> comparator_;
    final int k_;
    long n_;
    T maxItem_;
    T minItem_;
    int combinedBufferItemCapacity_;
    int baseBufferCount_;
    long bitPattern_;
    Object[] combinedBuffer_;
    ItemsSketchSortedView<T> classicQisSV = null;
    public static final Random rand = new Random();

    private QuantilesItemsSketch(int k, Class<T> clazz, Comparator<? super T> comparator) {
        Objects.requireNonNull(clazz, "Class<T> must not be null.");
        Objects.requireNonNull(comparator, "Comparator must not be null.");
        ClassicUtil.checkK(k);
        this.k_ = k;
        this.clazz = clazz;
        this.comparator_ = comparator;
    }

    public static <T> QuantilesItemsSketch<T> getInstance(Class<T> clazz, Comparator<? super T> comparator) {
        return QuantilesItemsSketch.getInstance(clazz, 128, comparator);
    }

    public static <T> QuantilesItemsSketch<T> getInstance(Class<T> clazz, int k, Comparator<? super T> comparator) {
        QuantilesItemsSketch<? super T> qs = new QuantilesItemsSketch<T>(k, clazz, comparator);
        int bufAlloc = 2 * Math.min(2, k);
        qs.n_ = 0L;
        qs.combinedBufferItemCapacity_ = bufAlloc;
        qs.combinedBuffer_ = new Object[bufAlloc];
        qs.baseBufferCount_ = 0;
        qs.bitPattern_ = 0L;
        qs.minItem_ = null;
        qs.maxItem_ = null;
        return qs;
    }

    public static <T> QuantilesItemsSketch<T> heapify(Class<T> clazz, MemorySegment srcSeg, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        long segCapBytes = srcSeg.byteSize();
        if (segCapBytes < 8L) {
            throw new SketchesArgumentException("MemorySegment too small: " + segCapBytes);
        }
        int preambleLongs = PreambleUtil.extractPreLongs(srcSeg);
        int serVer = PreambleUtil.extractSerVer(srcSeg);
        int familyID = PreambleUtil.extractFamilyID(srcSeg);
        int flags = PreambleUtil.extractFlags(srcSeg);
        int k = PreambleUtil.extractK(srcSeg);
        ItemsUtil.checkItemsSerVer(serVer);
        if (serVer == 3 && (flags & 8) == 0) {
            throw new SketchesArgumentException("Non-compact MemorySegment images are not supported.");
        }
        boolean empty = ClassicUtil.checkPreLongsFlagsCap(preambleLongs, flags, segCapBytes);
        ClassicUtil.checkFamilyID(familyID);
        QuantilesItemsSketch<T> sk = QuantilesItemsSketch.getInstance(clazz, k, comparator);
        if (empty) {
            return sk;
        }
        long n = PreambleUtil.extractN(srcSeg);
        int extra = 2;
        int numSegItems = ClassicUtil.computeRetainedItems(k, n) + 2;
        sk.n_ = n;
        sk.combinedBufferItemCapacity_ = ClassicUtil.computeCombinedBufferItemCapacity(k, n);
        sk.baseBufferCount_ = ClassicUtil.computeBaseBufferItems(k, n);
        sk.bitPattern_ = ClassicUtil.computeBitPattern(k, n);
        sk.combinedBuffer_ = new Object[sk.combinedBufferItemCapacity_];
        int srcSegItemsOffsetBytes = preambleLongs * 8;
        MemorySegment slice = srcSeg.asSlice((long)srcSegItemsOffsetBytes, srcSeg.byteSize() - (long)srcSegItemsOffsetBytes);
        T[] itemsArray = serDe.deserializeFromMemorySegment(slice, 0L, numSegItems);
        sk.itemsArrayToCombinedBuffer(itemsArray);
        return sk;
    }

    static <T> QuantilesItemsSketch<T> copy(QuantilesItemsSketch<T> sketch) {
        QuantilesItemsSketch<? super T> qsCopy = QuantilesItemsSketch.getInstance(sketch.clazz, sketch.k_, sketch.comparator_);
        qsCopy.n_ = sketch.n_;
        qsCopy.minItem_ = sketch.isEmpty() ? null : sketch.getMinItem();
        qsCopy.maxItem_ = sketch.isEmpty() ? null : sketch.getMaxItem();
        qsCopy.combinedBufferItemCapacity_ = sketch.getCombinedBufferAllocatedCount();
        qsCopy.baseBufferCount_ = sketch.getBaseBufferCount();
        qsCopy.bitPattern_ = sketch.getBitPattern();
        Object[] combBuf = sketch.getCombinedBuffer();
        qsCopy.combinedBuffer_ = Arrays.copyOf(combBuf, combBuf.length);
        return qsCopy;
    }

    @Override
    public double[] getCDF(T[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.classicQisSV.getCDF(splitPoints, searchCrit);
    }

    @Override
    public Class<T> getClassOfT() {
        return this.clazz;
    }

    @Override
    public Comparator<? super T> getComparator() {
        return this.comparator_;
    }

    @Override
    public T getMaxItem() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.maxItem_;
    }

    @Override
    public T getMinItem() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.minItem_;
    }

    @Override
    public GenericPartitionBoundaries<T> getPartitionBoundariesFromNumParts(int numEquallySizedParts, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.classicQisSV.getPartitionBoundariesFromNumParts(numEquallySizedParts, searchCrit);
    }

    @Override
    public GenericPartitionBoundaries<T> getPartitionBoundariesFromPartSize(long nominalPartSizeItems, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.classicQisSV.getPartitionBoundariesFromPartSize(nominalPartSizeItems, searchCrit);
    }

    @Override
    public double[] getPMF(T[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.classicQisSV.getPMF(splitPoints, searchCrit);
    }

    @Override
    public T getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.classicQisSV.getQuantile(rank, searchCrit);
    }

    @Override
    public T getQuantileLowerBound(double rank) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.getQuantile(Math.max(0.0, rank - QuantilesItemsSketch.getNormalizedRankError(this.k_, false)));
    }

    @Override
    public T getQuantileUpperBound(double rank) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.getQuantile(Math.min(1.0, rank + QuantilesItemsSketch.getNormalizedRankError(this.k_, false)));
    }

    @Override
    public T[] getQuantiles(double[] ranks, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.classicQisSV.getQuantiles(ranks, searchCrit);
    }

    @Override
    public double getRank(T quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.classicQisSV.getRank(quantile, searchCrit);
    }

    @Override
    public double getRankLowerBound(double rank) {
        return Math.max(0.0, rank - QuantilesItemsSketch.getNormalizedRankError(this.k_, false));
    }

    @Override
    public double getRankUpperBound(double rank) {
        return Math.min(1.0, rank + QuantilesItemsSketch.getNormalizedRankError(this.k_, false));
    }

    @Override
    public double[] getRanks(T[] quantiles, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = quantiles.length;
        double[] ranks = new double[len];
        for (int i = 0; i < len; ++i) {
            ranks[i] = this.classicQisSV.getRank(quantiles[i], searchCrit);
        }
        return ranks;
    }

    @Override
    public QuantilesGenericSketchIteratorAPI<T> iterator() {
        return new QuantilesItemsSketchIterator(this, this.bitPattern_);
    }

    @Override
    public int getK() {
        return this.k_;
    }

    @Override
    public long getN() {
        return this.n_;
    }

    @Override
    public double getNormalizedRankError(boolean pmf) {
        return QuantilesItemsSketch.getNormalizedRankError(this.k_, pmf);
    }

    public static double getNormalizedRankError(int k, boolean pmf) {
        return ClassicUtil.getNormalizedRankError(k, pmf);
    }

    public static int getKFromEpsilon(double epsilon, boolean pmf) {
        return ClassicUtil.getKFromEpsilon(epsilon, pmf);
    }

    @Override
    public boolean isEmpty() {
        return this.getN() == 0L;
    }

    @Override
    public boolean isEstimationMode() {
        return this.getN() >= 2L * (long)this.k_;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void reset() {
        this.n_ = 0L;
        this.combinedBufferItemCapacity_ = 2 * Math.min(2, this.k_);
        this.combinedBuffer_ = new Object[this.combinedBufferItemCapacity_];
        this.baseBufferCount_ = 0;
        this.bitPattern_ = 0L;
        this.minItem_ = null;
        this.maxItem_ = null;
        this.classicQisSV = null;
    }

    public byte[] toByteArray(ArrayOfItemsSerDe<T> serDe) {
        return this.toByteArray(false, serDe);
    }

    public byte[] toByteArray(boolean ordered, ArrayOfItemsSerDe<T> serDe) {
        return ItemsByteArrayImpl.toByteArray(this, ordered, serDe);
    }

    @Override
    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean withLevels, boolean withLevelsAndItems) {
        return ItemsUtil.toString(withLevels, withLevelsAndItems, this);
    }

    public static String toString(byte[] byteArr) {
        return PreambleUtil.toString(byteArr, false);
    }

    public static String toString(MemorySegment seg) {
        return PreambleUtil.toString(seg, false);
    }

    public QuantilesItemsSketch<T> downSample(int newK) {
        QuantilesItemsSketch<? super T> newSketch = QuantilesItemsSketch.getInstance(this.clazz, newK, this.comparator_);
        ItemsMergeImpl.downSamplingMergeInto(this, newSketch);
        return newSketch;
    }

    @Override
    public int getNumRetained() {
        return ClassicUtil.computeRetainedItems(this.getK(), this.getN());
    }

    public void putIntoMemorySegment(MemorySegment dstSeg, ArrayOfItemsSerDe<T> serDe) {
        byte[] byteArr = this.toByteArray(serDe);
        long segCap = dstSeg.byteSize();
        if (segCap < (long)byteArr.length) {
            throw new SketchesArgumentException("Destination MemorySegment not large enough: " + segCap + " < " + byteArr.length);
        }
        MemorySegment.copy(byteArr, 0, dstSeg, ValueLayout.JAVA_BYTE, 0L, byteArr.length);
    }

    @Override
    public void update(T item) {
        if (item == null) {
            return;
        }
        if (this.maxItem_ == null || this.comparator_.compare(item, this.maxItem_) > 0) {
            this.maxItem_ = item;
        }
        if (this.minItem_ == null || this.comparator_.compare(item, this.minItem_) < 0) {
            this.minItem_ = item;
        }
        if (this.baseBufferCount_ + 1 > this.combinedBufferItemCapacity_) {
            QuantilesItemsSketch.growBaseBuffer(this);
        }
        this.combinedBuffer_[this.baseBufferCount_++] = item;
        ++this.n_;
        if (this.baseBufferCount_ == 2 * this.k_) {
            ItemsUtil.processFullBaseBuffer(this);
        }
        this.classicQisSV = null;
    }

    int getBaseBufferCount() {
        return this.baseBufferCount_;
    }

    int getCombinedBufferAllocatedCount() {
        return this.combinedBufferItemCapacity_;
    }

    long getBitPattern() {
        return this.bitPattern_;
    }

    Object[] getCombinedBuffer() {
        return this.combinedBuffer_;
    }

    QuantilesItemsSketch<T> getSketchAndReset() {
        QuantilesItemsSketch<T> skCopy = QuantilesItemsSketch.copy(this);
        this.reset();
        return skCopy;
    }

    private void itemsArrayToCombinedBuffer(T[] itemsArray) {
        long bits;
        int extra = 2;
        this.minItem_ = itemsArray[0];
        this.maxItem_ = itemsArray[1];
        System.arraycopy(itemsArray, 2, this.combinedBuffer_, 0, this.baseBufferCount_);
        if (bits > 0L) {
            int index = 2 + this.baseBufferCount_;
            int level = 0;
            for (bits = this.bitPattern_; bits != 0L; bits >>>= 1) {
                if ((bits & 1L) > 0L) {
                    System.arraycopy(itemsArray, index, this.combinedBuffer_, (2 + level) * this.k_, this.k_);
                    index += this.k_;
                }
                ++level;
            }
        }
    }

    private static <T> void growBaseBuffer(QuantilesItemsSketch<T> sketch) {
        int newSize;
        Object[] baseBuffer = sketch.getCombinedBuffer();
        int oldSize = sketch.getCombinedBufferAllocatedCount();
        int k = sketch.getK();
        assert (oldSize < 2 * k);
        sketch.combinedBufferItemCapacity_ = newSize = Math.max(Math.min(2 * k, 2 * oldSize), 1);
        sketch.combinedBuffer_ = Arrays.copyOf(baseBuffer, newSize);
    }

    @Override
    public ItemsSketchSortedView<T> getSortedView() {
        return this.refreshSortedView();
    }

    private ItemsSketchSortedView<T> refreshSortedView() {
        return this.classicQisSV == null ? (this.classicQisSV = QuantilesItemsSketch.getSV(this)) : this.classicQisSV;
    }

    private static <T> ItemsSketchSortedView<T> getSV(QuantilesItemsSketch<T> sk) {
        long totalN = sk.getN();
        if (sk.isEmpty() || totalN == 0L) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        int k = sk.getK();
        int numQuantiles = sk.getNumRetained();
        Object[] svQuantiles = (Object[])Array.newInstance(sk.clazz, numQuantiles);
        long[] svCumWeights = new long[numQuantiles];
        Comparator<? super T> comparator = sk.comparator_;
        Object[] combinedBuffer = sk.getCombinedBuffer();
        int baseBufferCount = sk.getBaseBufferCount();
        QuantilesItemsSketch.populateFromItemsSketch(k, totalN, sk.getBitPattern(), combinedBuffer, baseBufferCount, numQuantiles, svQuantiles, svCumWeights, sk.getComparator());
        ItemsMergeImpl.blockyTandemMergeSort(svQuantiles, svCumWeights, numQuantiles, k, comparator);
        if (QuantilesItemsSketch.convertToCumulative(svCumWeights) != totalN) {
            throw new SketchesStateException("Sorted View is misconfigured. TotalN does not match cumWeights.");
        }
        return new ItemsSketchSortedView<Object>(svQuantiles, svCumWeights, sk);
    }

    private static <T> void populateFromItemsSketch(int k, long totalN, long bitPattern, T[] combinedBuffer, int baseBufferCount, int numQuantiles, T[] svQuantiles, long[] svCumWeights, Comparator<? super T> comparator) {
        long bits;
        long weight = 1L;
        int index = 0;
        assert (bits == totalN / (2L * (long)k));
        int lvl = 0;
        for (bits = bitPattern; bits != 0L; bits >>>= 1) {
            weight <<= 1;
            if ((bits & 1L) > 0L) {
                int offset = (2 + lvl) * k;
                for (int i = 0; i < k; ++i) {
                    svQuantiles[index] = combinedBuffer[i + offset];
                    svCumWeights[index] = weight;
                    ++index;
                }
            }
            ++lvl;
        }
        weight = 1L;
        int startOfBaseBufferBlock = index;
        for (int i = 0; i < baseBufferCount; ++i) {
            svQuantiles[index] = combinedBuffer[i];
            svCumWeights[index] = weight;
            ++index;
        }
        assert (index == numQuantiles);
        Arrays.sort(svQuantiles, startOfBaseBufferBlock, numQuantiles, comparator);
    }

    private static long convertToCumulative(long[] array) {
        long subtotal = 0L;
        for (int i = 0; i < array.length; ++i) {
            long newSubtotal;
            subtotal = array[i] = (newSubtotal = subtotal + array[i]);
        }
        return subtotal;
    }
}

