/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.hll.AuxHashMap;
import org.apache.datasketches.hll.HeapAuxHashMap;
import org.apache.datasketches.hll.Hll4Update;
import org.apache.datasketches.hll.HllArray;
import org.apache.datasketches.hll.HllPairIterator;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.ToByteArrayImpl;
import org.apache.datasketches.memory.Memory;

final class Hll4Array
extends HllArray {
    Hll4Array(int lgConfigK) {
        super(lgConfigK, TgtHllType.HLL_4);
        this.hllByteArr = new byte[Hll4Array.hll4ArrBytes(lgConfigK)];
    }

    Hll4Array(Hll4Array that) {
        super(that);
    }

    static final Hll4Array heapify(Memory mem) {
        int lgConfigK = PreambleUtil.extractLgK(mem);
        Hll4Array hll4Array = new Hll4Array(lgConfigK);
        HllArray.extractCommonHll(mem, hll4Array);
        int auxStart = hll4Array.auxStart;
        int auxCount = PreambleUtil.extractAuxCount(mem);
        boolean compact = PreambleUtil.extractCompactFlag(mem);
        HeapAuxHashMap auxHashMap = null;
        if (auxCount > 0) {
            auxHashMap = HeapAuxHashMap.heapify(mem, auxStart, lgConfigK, auxCount, compact);
        }
        hll4Array.putAuxHashMap(auxHashMap, false);
        return hll4Array;
    }

    @Override
    Hll4Array copy() {
        return new Hll4Array(this);
    }

    @Override
    HllSketchImpl couponUpdate(int coupon) {
        int newValue = coupon >>> 26;
        int configKmask = (1 << this.getLgConfigK()) - 1;
        int slotNo = coupon & configKmask;
        this.updateSlotWithKxQ(slotNo, newValue);
        return this;
    }

    @Override
    int getNibble(int slotNo) {
        int theByte = this.hllByteArr[slotNo >>> 1];
        if ((slotNo & 1) > 0) {
            theByte >>>= 4;
        }
        return theByte & 0xF;
    }

    @Override
    int getSlotValue(int slotNo) {
        int nib = this.getNibble(slotNo);
        if (nib == 15) {
            AuxHashMap auxHashMap = this.getAuxHashMap();
            return auxHashMap.mustFindValueFor(slotNo);
        }
        return nib + this.getCurMin();
    }

    @Override
    int getUpdatableSerializationBytes() {
        AuxHashMap auxHashMap = this.getAuxHashMap();
        int auxBytes = auxHashMap == null ? 4 << HllUtil.LG_AUX_ARR_INTS[this.lgConfigK] : 4 << auxHashMap.getLgAuxArrInts();
        return PreambleUtil.HLL_BYTE_ARR_START + this.getHllByteArrBytes() + auxBytes;
    }

    @Override
    PairIterator iterator() {
        return new HeapHll4Iterator(1 << this.lgConfigK);
    }

    @Override
    void putNibble(int slotNo, int nibValue) {
        int byteno = slotNo >>> 1;
        byte oldValue = this.hllByteArr[byteno];
        this.hllByteArr[byteno] = (slotNo & 1) == 0 ? (byte)(oldValue & 0xF0 | nibValue & 0xF) : (byte)(oldValue & 0xF | nibValue << 4 & 0xF0);
    }

    @Override
    void updateSlotNoKxQ(int slotNo, int newValue) {
        throw new SketchesStateException("Improper access.");
    }

    @Override
    void updateSlotWithKxQ(int slotNo, int newValue) {
        Hll4Update.internalHll4Update(this, slotNo, newValue);
    }

    @Override
    byte[] toCompactByteArray() {
        return ToByteArrayImpl.toHllByteArray(this, true);
    }

    final class HeapHll4Iterator
    extends HllPairIterator {
        HeapHll4Iterator(int lengthPairs) {
            super(lengthPairs);
        }

        @Override
        int value() {
            return Hll4Array.this.getSlotValue(this.index);
        }
    }
}

