<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

# Apache DataFusion 50.1.0 Changelog

This release consists of 4 commits from 4 contributors. See credits at the end of this changelog for more information.

See the [upgrade guide](https://datafusion.apache.org/library-user-guide/upgrading.html) for information on how to upgrade from previous versions.

**Other:**

- [branch-50] fix: ignore non-existent columns when adding filter equivalence info in FileScanConfig (#17546) [#17600](https://github.com/apache/datafusion/pull/17600) (rkrishn7)
- [branch-50] fix: Ensure the CachedParquetFileReader respects the metadata prefetch hint (#17302) [#17613](https://github.com/apache/datafusion/pull/17613) (shehabgamin)
- [branch-50] Partial AggregateMode will generate duplicate field names which will fail DFSchema construct to branch-50 [#17717](https://github.com/apache/datafusion/pull/17717) (zhuqi-lucas)
- [branch-50]: feat: expose `udafs` and `udwfs` methods on `FunctionRegistry` (#17650) [#17725](https://github.com/apache/datafusion/pull/17725) (milenkovicm)
- [branch-50] Backport change to avoid debug symbols in ci builds to 50.0.0 [#17795](https://github.com/apache/datafusion/pull/17795) (alamb)
- [branch-50] Backport Prevent exponential planning time for Window functions - v2 #17684 [#17778](https://github.com/apache/datafusion/pull/17778) (alamb)
- [branch-50] Fix potential overflow when we print verbose physical plan [#17804](https://github.com/apache/datafusion/pull/17804) (zhuqi-lucas)

## Credits

Thank you to everyone who contributed to this release. Here is a breakdown of commits (PRs merged) per contributor.

```
     1	Marko Milenković
     1	Qi Zhu
     1	Rohan Krishnaswamy
     1	Shehab Amin
```

Thank you also to everyone who contributed in other ways such as filing issues, reviewing PRs, and providing feedback on this release.
