/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.main.api.xmlpull;

import com.siemens.ct.exi.core.EXIBodyEncoder;
import com.siemens.ct.exi.core.EXIFactory;
import com.siemens.ct.exi.core.EXIStreamEncoder;
import com.siemens.ct.exi.core.attributes.AttributeFactory;
import com.siemens.ct.exi.core.attributes.AttributeList;
import com.siemens.ct.exi.core.container.NamespaceDeclaration;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.values.StringValue;
import com.siemens.ct.exi.core.values.Value;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlSerializer;

public class EXISerializer
implements XmlSerializer {
    protected final EXIFactory factory;
    protected final EXIStreamEncoder exiStream;
    protected EXIBodyEncoder exiBody;
    protected OutputStream outputStream;
    protected List<NamespaceDeclaration> nsDecls;
    String currentNamespace;
    String currentName;
    protected boolean pendingATs;
    protected AttributeList exiAttributes;

    public EXISerializer(EXIFactory factory) throws EXIException {
        this.factory = factory;
        this.exiStream = factory.createEXIStreamEncoder();
        AttributeFactory attFactory = AttributeFactory.newInstance();
        this.exiAttributes = attFactory.createAttributeListInstance(factory);
        this.nsDecls = new ArrayList<NamespaceDeclaration>();
    }

    public void setFeature(String name, boolean state) throws IllegalArgumentException, IllegalStateException {
        throw new IllegalStateException("EXI does not support setting feature " + name + " to " + state);
    }

    public boolean getFeature(String name) {
        return false;
    }

    public void setProperty(String name, Object value) throws IllegalArgumentException, IllegalStateException {
        throw new IllegalStateException("EXI does not support setting property " + name + " to " + value);
    }

    public Object getProperty(String name) {
        return null;
    }

    public void setOutput(OutputStream os, String encoding) throws IOException, IllegalArgumentException, IllegalStateException {
        try {
            this.outputStream = os;
            this.exiBody = this.exiStream.encodeHeader(os);
        }
        catch (EXIException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setOutput(Writer writer) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new IllegalArgumentException("EXI requires byte-based stream. Consider using OutputStream");
    }

    protected void init() {
        this.pendingATs = false;
        this.exiAttributes.clear();
    }

    public void startDocument(String encoding, Boolean standalone) throws IOException, IllegalArgumentException, IllegalStateException {
        try {
            this.init();
            this.exiBody.encodeStartDocument();
        }
        catch (EXIException e) {
            throw new IOException(e);
        }
    }

    public void endDocument() throws IOException, IllegalArgumentException, IllegalStateException {
        try {
            this.checkPendingATEvents();
            this.exiBody.encodeEndDocument();
            this.exiBody.flush();
        }
        catch (EXIException e) {
            throw new IOException(e);
        }
    }

    public void setPrefix(String prefix, String namespace) throws IOException, IllegalArgumentException, IllegalStateException {
        this.nsDecls.add(new NamespaceDeclaration(namespace, prefix));
    }

    public String getPrefix(String namespace, boolean generatePrefix) throws IllegalArgumentException {
        return null;
    }

    public int getDepth() {
        return 0;
    }

    public String getNamespace() {
        return this.currentNamespace;
    }

    public String getName() {
        return this.currentName;
    }

    public XmlSerializer startTag(String namespace, String name) throws IOException, IllegalArgumentException, IllegalStateException {
        try {
            this.checkPendingATEvents();
            this.currentNamespace = namespace;
            this.currentName = name;
            this.exiBody.encodeStartElement(namespace, name, null);
            for (int i = 0; i < this.nsDecls.size(); ++i) {
                NamespaceDeclaration ns = this.nsDecls.get(i);
                this.exiBody.encodeNamespaceDeclaration(ns.namespaceURI, ns.prefix);
            }
            this.nsDecls.clear();
            return this;
        }
        catch (EXIException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void checkPendingATEvents() throws IOException {
        try {
            if (this.pendingATs) {
                this.exiBody.encodeAttributeList(this.exiAttributes);
                this.exiAttributes.clear();
                this.pendingATs = false;
            }
        }
        catch (EXIException e) {
            throw new IOException(e);
        }
    }

    public XmlSerializer attribute(String namespace, String name, String value) throws IOException, IllegalArgumentException, IllegalStateException {
        this.exiAttributes.addAttribute(namespace, name, null, value);
        return this;
    }

    public XmlSerializer endTag(String namespace, String name) throws IOException, IllegalArgumentException, IllegalStateException {
        try {
            this.checkPendingATEvents();
            this.exiBody.encodeEndElement();
            return this;
        }
        catch (EXIException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public XmlSerializer text(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        try {
            this.checkPendingATEvents();
            this.exiBody.encodeCharacters((Value)new StringValue(text));
            return this;
        }
        catch (EXIException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public XmlSerializer text(char[] buf, int start, int len) throws IOException, IllegalArgumentException, IllegalStateException {
        return this.text(new String(buf, start, len));
    }

    public void cdsect(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        this.checkPendingATEvents();
        this.text("<![CDATA[" + text + "]]>");
    }

    public void entityRef(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        try {
            this.checkPendingATEvents();
            this.exiBody.encodeEntityReference(text);
        }
        catch (EXIException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void processingInstruction(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        this.checkPendingATEvents();
        this.text("<?" + text + "?>");
    }

    public void comment(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        try {
            this.checkPendingATEvents();
            char[] ch = text.toCharArray();
            this.exiBody.encodeComment(ch, 0, ch.length);
        }
        catch (EXIException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void docdecl(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        this.checkPendingATEvents();
        this.text("<!DOCTYPE " + text + ">");
    }

    public void ignorableWhitespace(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        this.text(text);
    }

    public void flush() throws IOException {
        this.exiBody.flush();
    }
}

