/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.impl.journal.AbstractJournalStorageManager;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public final class ReplicationSyncFileMessage
extends PacketImpl {
    private AbstractJournalStorageManager.JournalContent journalType;
    private long fileId;
    private int dataSize;
    private ByteBuf byteBuffer;
    private byte[] byteArray;
    private SimpleString pageStoreName;
    private FileType fileType;

    public ReplicationSyncFileMessage() {
        super((byte)103);
    }

    public ReplicationSyncFileMessage(AbstractJournalStorageManager.JournalContent content, SimpleString storeName, long id, int size, ByteBuf buffer) {
        this();
        this.byteBuffer = buffer;
        this.pageStoreName = storeName;
        this.dataSize = size;
        this.fileId = id;
        this.journalType = content;
        this.determineType();
    }

    private void determineType() {
        this.fileType = this.journalType != null ? FileType.JOURNAL : (this.pageStoreName != null ? FileType.PAGE : FileType.LARGE_MESSAGE);
    }

    public int expectedEncodeSize() {
        int size = 21;
        if (this.fileId == -1L) {
            return size;
        }
        ++size;
        switch (this.fileType) {
            case JOURNAL: {
                ++size;
                break;
            }
            case PAGE: {
                size += SimpleString.sizeofString((SimpleString)this.pageStoreName);
                break;
            }
        }
        size += 4;
        if (this.dataSize > 0) {
            size += this.byteBuffer.writerIndex();
        }
        return size;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeLong(this.fileId);
        if (this.fileId == -1L) {
            return;
        }
        buffer.writeByte(this.fileType.code);
        switch (this.fileType) {
            case JOURNAL: {
                buffer.writeByte(this.journalType.typeByte);
                break;
            }
            case PAGE: {
                buffer.writeSimpleString(this.pageStoreName);
                break;
            }
        }
        buffer.writeInt(this.dataSize);
        if (this.dataSize > 0) {
            buffer.writeBytes(this.byteBuffer, 0, this.byteBuffer.writerIndex());
        }
        this.release();
    }

    public void release() {
        if (this.byteBuffer != null) {
            this.byteBuffer.release();
            this.byteBuffer = null;
        }
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.fileId = buffer.readLong();
        switch (FileType.getFileType(buffer.readByte())) {
            case JOURNAL: {
                this.journalType = AbstractJournalStorageManager.JournalContent.getType(buffer.readByte());
                this.fileType = FileType.JOURNAL;
                break;
            }
            case PAGE: {
                this.pageStoreName = buffer.readSimpleString();
                this.fileType = FileType.PAGE;
                break;
            }
            case LARGE_MESSAGE: {
                this.fileType = FileType.LARGE_MESSAGE;
            }
        }
        int size = buffer.readInt();
        if (size > 0) {
            this.byteArray = new byte[size];
            buffer.readBytes(this.byteArray);
        }
    }

    public long getId() {
        return this.fileId;
    }

    public AbstractJournalStorageManager.JournalContent getJournalContent() {
        return this.journalType;
    }

    public byte[] getData() {
        return this.byteArray;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public SimpleString getPageStore() {
        return this.pageStoreName;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), Arrays.hashCode(this.byteArray), this.byteBuffer, this.dataSize, this.fileId, this.fileType, this.journalType, this.pageStoreName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReplicationSyncFileMessage)) {
            return false;
        }
        ReplicationSyncFileMessage other = (ReplicationSyncFileMessage)((Object)obj);
        return Arrays.equals(this.byteArray, other.byteArray) && Objects.equals(this.byteBuffer, other.byteBuffer) && this.dataSize == other.dataSize && this.fileId == other.fileId && this.fileType == other.fileType && this.journalType == other.journalType && Objects.equals(this.pageStoreName, other.pageStoreName);
    }

    protected String getPacketString() {
        return super.getPacketString() + ", fileType=" + String.valueOf((Object)this.fileType) + (String)(this.journalType != null ? ", " + String.valueOf((Object)this.journalType) : "") + ", id=" + this.fileId;
    }

    public static enum FileType {
        JOURNAL(0),
        PAGE(1),
        LARGE_MESSAGE(2);

        private byte code;
        private static final Set<FileType> ALL_OF;

        private FileType(int code) {
            this.code = (byte)code;
        }

        public static FileType getFileType(byte readByte) {
            for (FileType type : ALL_OF) {
                if (type.code != readByte) continue;
                return type;
            }
            throw new InternalError("Unsupported byte value for " + String.valueOf(FileType.class));
        }

        static {
            ALL_OF = EnumSet.allOf(FileType.class);
        }
    }
}

