/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.activemq.artemis.logs.ActiveMQUtilLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void makeExec(File file) throws IOException {
        try {
            Files.setPosixFilePermissions(file.toPath(), new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final boolean deleteDirectory(File directory) {
        if (directory.isDirectory()) {
            String[] files = directory.list();
            int num = 5;
            for (int attempts = 0; files == null && attempts < num; ++attempts) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                files = directory.list();
            }
            if (files == null) {
                ActiveMQUtilLogger.LOGGER.failedListFilesToCleanup(directory.getAbsolutePath());
            } else {
                for (String file : files) {
                    File f = new File(directory, file);
                    if (FileUtil.deleteDirectory(f)) continue;
                    ActiveMQUtilLogger.LOGGER.failedToCleanupFile(f.getAbsolutePath());
                }
            }
        }
        return directory.delete();
    }

    public static final void copyDirectory(File directorySource, File directoryTarget) throws Exception {
        final Path sourcePath = directorySource.toPath();
        final Path targetPath = directoryTarget.toPath();
        Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path targetDir = targetPath.resolve(sourcePath.relativize(dir));
                Files.createDirectories(targetDir, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, targetPath.resolve(sourcePath.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static boolean findReplace(File file, String find, String replace) throws Exception {
        String newContent;
        if (!file.exists()) {
            return false;
        }
        String original = Files.readString(file.toPath());
        if (!original.equals(newContent = original.replace(find, replace))) {
            Files.writeString(file.toPath(), (CharSequence)newContent, new OpenOption[0]);
            return true;
        }
        return false;
    }

    public static String readFile(InputStream inputStream) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String fileOutput = bufferedReader.lines().collect(Collectors.joining(System.lineSeparator()));
        return fileOutput;
    }

    public static boolean find(File file, Predicate<String> search) throws Exception {
        AtomicBoolean found = new AtomicBoolean(false);
        try (Stream<String> lines = Files.lines(file.toPath());){
            lines.filter(search::test).findFirst().ifPresent(line -> {
                logger.info("pattern found at {}", line);
                found.set(true);
            });
        }
        return found.get();
    }
}

