/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.provider.FormEncodingProvider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;

public final class FormUtils {
    public static final String FORM_PARAMS_FROM_HTTP_PARAMS = "set.form.parameters.from.http.parameters";
    public static final String FORM_PARAM_MAP = "org.apache.cxf.form_data";
    public static final String FORM_PARAM_MAP_DECODED = "org.apache.cxf.form_data.decoded";
    private static final Logger LOG = LogUtils.getL7dLogger(FormUtils.class);
    private static final String MULTIPART_FORM_DATA_TYPE = "form-data";
    private static final String MAX_FORM_PARAM_COUNT = "maxFormParameterCount";
    private static final String CONTENT_DISPOSITION_FILES_PARAM = "files";

    private FormUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String formToString(Form form) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            FormUtils.writeMapToOutputStream((Map<String, List<String>>)form.asMap(), bos, StandardCharsets.UTF_8.name(), false);
            String string = bos.toString(StandardCharsets.UTF_8.name());
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void restoreForm(FormEncodingProvider<Form> provider, Form form, Message message) throws Exception {
        CachedOutputStream os = new CachedOutputStream();
        FormUtils.writeForm(provider, form, (OutputStream)os);
        message.setContent(InputStream.class, (Object)os.getInputStream());
    }

    public static void writeForm(FormEncodingProvider<Form> provider, Form form, OutputStream os) throws Exception {
        provider.writeTo(form, Form.class, (Type)((Object)Form.class), new Annotation[0], MediaType.APPLICATION_FORM_URLENCODED_TYPE, (MultivaluedMap<String, Object>)new MetadataMap<String, Object>(), os);
    }

    public static Form readForm(FormEncodingProvider<Form> provider, Message message) throws Exception {
        return provider.readFrom(Form.class, (Type)((Object)Form.class), new Annotation[0], MediaType.APPLICATION_FORM_URLENCODED_TYPE, (MultivaluedMap<String, String>)new MetadataMap<String, String>(), (InputStream)message.getContent(InputStream.class));
    }

    public static void addPropertyToForm(MultivaluedMap<String, String> map, String name, Object value) {
        if (!"".equals(name)) {
            map.add((Object)name, (Object)value.toString());
        } else {
            MultivaluedMap<String, Object> values = InjectionUtils.extractValuesFromBean(value, "");
            for (Map.Entry entry : values.entrySet()) {
                for (Object v : (List)entry.getValue()) {
                    map.add(entry.getKey(), (Object)v.toString());
                }
            }
        }
    }

    public static String readBody(InputStream is, String encoding) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)bos, (int)1024);
            return new String(bos.toByteArray(), encoding);
        }
        catch (Exception ex) {
            throw ExceptionUtils.toInternalServerErrorException(ex, null);
        }
    }

    public static void populateMapFromString(MultivaluedMap<String, String> params, Message m, String postBody, String enc, boolean decode) {
        if (StringUtils.isEmpty((String)postBody)) {
            return;
        }
        String[] parts = postBody.split("&");
        FormUtils.checkNumberOfParts(m, parts.length);
        for (String part : parts) {
            String[] keyValue = new String[2];
            int index = part.indexOf(61);
            if (index != -1) {
                keyValue[0] = part.substring(0, index);
                keyValue[1] = index + 1 < part.length() ? part.substring(index + 1) : "";
            } else {
                keyValue[0] = part;
                keyValue[1] = "";
            }
            String name = HttpUtils.urlDecode(keyValue[0], enc);
            if (decode) {
                params.add((Object)name, (Object)HttpUtils.urlDecode(keyValue[1], enc));
                continue;
            }
            params.add((Object)name, (Object)keyValue[1]);
        }
    }

    public static void populateMapFromStringOrHttpRequest(MultivaluedMap<String, String> params, Message m, String postBody, String enc, boolean decode) {
        HttpServletRequest request = (HttpServletRequest)m.get((Object)"HTTP.REQUEST");
        FormUtils.populateMapFromString(params, m, postBody, enc, decode, request);
    }

    public static void populateMapFromString(MultivaluedMap<String, String> params, Message m, String postBody, String enc, boolean decode, HttpServletRequest request) {
        if (!StringUtils.isEmpty((String)postBody)) {
            FormUtils.populateMapFromString(params, m, postBody, enc, decode);
        } else if (request != null && MessageUtils.getContextualBoolean((Message)m, (String)FORM_PARAMS_FROM_HTTP_PARAMS, (boolean)true)) {
            Enumeration en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String paramName = (String)en.nextElement();
                String[] values = request.getParameterValues(paramName);
                params.put((Object)HttpUtils.urlDecode(paramName), Arrays.asList(values));
            }
            FormUtils.logRequestParametersIfNeeded(params, enc);
            m.put((Object)FORM_PARAM_MAP_DECODED, (Object)true);
        }
    }

    public static void logRequestParametersIfNeeded(Map<String, List<String>> params, String enc) {
        if (PhaseInterceptorChain.getCurrentMessage() == null || PhaseInterceptorChain.getCurrentMessage().getInterceptorChain() == null) {
            return;
        }
        String chain = PhaseInterceptorChain.getCurrentMessage().getInterceptorChain().toString();
        if (chain.contains("LoggingInInterceptor")) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                FormUtils.writeMapToOutputStream(params, bos, enc, false);
                LOG.info(bos.toString(enc));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void writeMapToOutputStream(Map<String, List<String>> map, OutputStream os, String enc, boolean encoded) throws IOException {
        Iterator<Map.Entry<String, List<String>>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<String>> entry = it.next();
            String key = entry.getKey();
            if (!encoded) {
                key = HttpUtils.urlEncode(key, enc);
            }
            Iterator<String> entryIterator = entry.getValue().iterator();
            while (entryIterator.hasNext()) {
                os.write(key.getBytes(enc));
                os.write(61);
                String value = entryIterator.next();
                if (!encoded) {
                    value = HttpUtils.urlEncode(value, enc);
                }
                os.write(value.getBytes(enc));
                if (!entryIterator.hasNext()) continue;
                os.write(38);
            }
            if (!it.hasNext()) continue;
            os.write(38);
        }
    }

    public static void populateMapFromMultipart(MultivaluedMap<String, String> params, MultipartBody body, Message m, boolean decode) {
        List<Attachment> atts = body.getAllAttachments();
        FormUtils.checkNumberOfParts(m, atts.size());
        for (Attachment a : atts) {
            String name;
            ContentDisposition cd = a.getContentDisposition();
            if (cd != null && !MULTIPART_FORM_DATA_TYPE.equalsIgnoreCase(cd.getType())) continue;
            String cdName = cd == null ? null : cd.getParameter("name");
            String contentId = a.getContentId();
            String string = name = StringUtils.isEmpty((String)cdName) ? contentId : cdName.replace("\"", "").replace("'", "");
            if (StringUtils.isEmpty((String)name)) {
                throw ExceptionUtils.toBadRequestException(null, null);
            }
            if (CONTENT_DISPOSITION_FILES_PARAM.equals(name)) continue;
            try {
                String value = IOUtils.toString((InputStream)a.getDataHandler().getInputStream());
                params.add((Object)HttpUtils.urlDecode(name), (Object)(decode ? HttpUtils.urlDecode(value) : value));
            }
            catch (IllegalArgumentException ex) {
                LOG.warning("Illegal URL-encoded characters, make sure that no @FormParam and @Multipart annotations are mixed up");
                throw ExceptionUtils.toInternalServerErrorException(ex, null);
            }
            catch (IOException ex) {
                throw ExceptionUtils.toBadRequestException(null, null);
            }
        }
    }

    private static void checkNumberOfParts(Message m, int numberOfParts) {
        if (m == null || m.getExchange() == null || m.getExchange().getInMessage() == null) {
            return;
        }
        String maxPartsCountProp = (String)m.getExchange().getInMessage().getContextualProperty(MAX_FORM_PARAM_COUNT);
        if (maxPartsCountProp == null) {
            return;
        }
        try {
            int maxPartsCount = Integer.parseInt(maxPartsCountProp);
            if (maxPartsCount != -1 && numberOfParts >= maxPartsCount) {
                throw new WebApplicationException(413);
            }
        }
        catch (NumberFormatException ex) {
            throw ExceptionUtils.toInternalServerErrorException(ex, null);
        }
    }

    public static boolean isFormPostRequest(Message m) {
        return "application/x-www-form-urlencoded".equals(m.get((Object)"Content-Type")) && "POST".equals(m.get((Object)"org.apache.cxf.request.method"));
    }
}

