/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.neuralnet;

import org.apache.commons.math4.neuralnet.DistanceMeasure;
import org.apache.commons.math4.neuralnet.internal.NeuralNetException;

public class EuclideanDistance
implements DistanceMeasure {
    @Override
    public double applyAsDouble(double[] a, double[] b) {
        int len = a.length;
        if (len != b.length) {
            throw new NeuralNetException("Size mismatch: {0} != {1}", len, b.length);
        }
        double sum = 0.0;
        for (int i = 0; i < len; ++i) {
            double diff = a[i] - b[i];
            sum += diff * diff;
        }
        return Math.sqrt(sum);
    }
}

