/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat;

import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public final class StatUtilsTest {
    private static final double ONE = 1.0;
    private static final float TWO = 2.0f;
    private static final int THREE = 3;
    private static final double MEAN = 2.0;
    private static final double SUMSQ = 18.0;
    private static final double SUM = 8.0;
    private static final double VAR = 0.6666666666666666;
    private static final double MIN = 1.0;
    private static final double MAX = 3.0;
    private static final double TOLERANCE = 1.0E-14;
    private static final double NAN = Double.NaN;

    @Test
    public void testStats() {
        double[] values = new double[]{1.0, 2.0, 2.0, 3.0};
        Assert.assertEquals((String)"sum", (double)8.0, (double)StatUtils.sum((double[])values), (double)1.0E-14);
        Assert.assertEquals((String)"sumsq", (double)18.0, (double)StatUtils.sumSq((double[])values), (double)1.0E-14);
        Assert.assertEquals((String)"var", (double)0.6666666666666666, (double)StatUtils.variance((double[])values), (double)1.0E-14);
        Assert.assertEquals((String)"var with mean", (double)0.6666666666666666, (double)StatUtils.variance((double[])values, (double)2.0), (double)1.0E-14);
        Assert.assertEquals((String)"mean", (double)2.0, (double)StatUtils.mean((double[])values), (double)1.0E-14);
        Assert.assertEquals((String)"min", (double)1.0, (double)StatUtils.min((double[])values), (double)1.0E-14);
        Assert.assertEquals((String)"max", (double)3.0, (double)StatUtils.max((double[])values), (double)1.0E-14);
    }

    @Test
    public void testN0andN1Conditions() {
        double[] values = new double[]{};
        Assert.assertTrue((String)"Mean of n = 0 set should be NaN", (boolean)Double.isNaN(StatUtils.mean((double[])values)));
        Assert.assertTrue((String)"Variance of n = 0 set should be NaN", (boolean)Double.isNaN(StatUtils.variance((double[])values)));
        values = new double[]{1.0};
        Assert.assertTrue((String)"Mean of n = 1 set should be value of single item n1", (StatUtils.mean((double[])values) == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Variance of n = 1 set should be zero", (StatUtils.variance((double[])values) == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testArrayIndexConditions() {
        double[] values = new double[]{1.0, 2.0, 3.0, 4.0};
        Assert.assertEquals((String)"Sum not expected", (double)5.0, (double)StatUtils.sum((double[])values, (int)1, (int)2), (double)Double.MIN_VALUE);
        Assert.assertEquals((String)"Sum not expected", (double)3.0, (double)StatUtils.sum((double[])values, (int)0, (int)2), (double)Double.MIN_VALUE);
        Assert.assertEquals((String)"Sum not expected", (double)7.0, (double)StatUtils.sum((double[])values, (int)2, (int)2), (double)Double.MIN_VALUE);
        try {
            StatUtils.sum((double[])values, (int)2, (int)3);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            StatUtils.sum((double[])values, (int)-1, (int)2);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testSumSq() {
        double[] x = null;
        try {
            StatUtils.sumSq(x);
            Assert.fail((String)"null is not a valid data array.");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            StatUtils.sumSq(x, (int)0, (int)4);
            Assert.fail((String)"null is not a valid data array.");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        x = new double[]{};
        TestUtils.assertEquals(0.0, StatUtils.sumSq((double[])x), 1.0E-14);
        TestUtils.assertEquals(0.0, StatUtils.sumSq((double[])x, (int)0, (int)0), 1.0E-14);
        x = new double[]{2.0};
        TestUtils.assertEquals(4.0, StatUtils.sumSq((double[])x), 1.0E-14);
        TestUtils.assertEquals(4.0, StatUtils.sumSq((double[])x, (int)0, (int)1), 1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        TestUtils.assertEquals(18.0, StatUtils.sumSq((double[])x), 1.0E-14);
        TestUtils.assertEquals(8.0, StatUtils.sumSq((double[])x, (int)1, (int)2), 1.0E-14);
    }

    @Test
    public void testProduct() {
        double[] x = null;
        try {
            StatUtils.product(x);
            Assert.fail((String)"null is not a valid data array.");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            StatUtils.product(x, (int)0, (int)4);
            Assert.fail((String)"null is not a valid data array.");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        x = new double[]{};
        TestUtils.assertEquals(1.0, StatUtils.product((double[])x), 1.0E-14);
        TestUtils.assertEquals(1.0, StatUtils.product((double[])x, (int)0, (int)0), 1.0E-14);
        x = new double[]{2.0};
        TestUtils.assertEquals(2.0, StatUtils.product((double[])x), 1.0E-14);
        TestUtils.assertEquals(2.0, StatUtils.product((double[])x, (int)0, (int)1), 1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        TestUtils.assertEquals(12.0, StatUtils.product((double[])x), 1.0E-14);
        TestUtils.assertEquals(4.0, StatUtils.product((double[])x, (int)1, (int)2), 1.0E-14);
    }

    @Test
    public void testSumLog() {
        double[] x = null;
        try {
            StatUtils.sumLog(x);
            Assert.fail((String)"null is not a valid data array.");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            StatUtils.sumLog(x, (int)0, (int)4);
            Assert.fail((String)"null is not a valid data array.");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        x = new double[]{};
        TestUtils.assertEquals(0.0, StatUtils.sumLog((double[])x), 1.0E-14);
        TestUtils.assertEquals(0.0, StatUtils.sumLog((double[])x, (int)0, (int)0), 1.0E-14);
        x = new double[]{2.0};
        TestUtils.assertEquals(FastMath.log((double)2.0), StatUtils.sumLog((double[])x), 1.0E-14);
        TestUtils.assertEquals(FastMath.log((double)2.0), StatUtils.sumLog((double[])x, (int)0, (int)1), 1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        TestUtils.assertEquals(FastMath.log((double)1.0) + 2.0 * FastMath.log((double)2.0) + FastMath.log((double)3.0), StatUtils.sumLog((double[])x), 1.0E-14);
        TestUtils.assertEquals(2.0 * FastMath.log((double)2.0), StatUtils.sumLog((double[])x, (int)1, (int)2), 1.0E-14);
    }

    @Test
    public void testMean() {
        double[] x = null;
        try {
            StatUtils.mean(x, (int)0, (int)4);
            Assert.fail((String)"null is not a valid data array.");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        x = new double[]{};
        TestUtils.assertEquals(Double.NaN, StatUtils.mean((double[])x, (int)0, (int)0), 1.0E-14);
        x = new double[]{2.0};
        TestUtils.assertEquals(2.0, StatUtils.mean((double[])x, (int)0, (int)1), 1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        TestUtils.assertEquals(2.5, StatUtils.mean((double[])x, (int)2, (int)2), 1.0E-14);
    }

    @Test
    public void testVariance() {
        double[] x = null;
        try {
            StatUtils.variance(x, (int)0, (int)4);
            Assert.fail((String)"null is not a valid data array.");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        x = new double[]{};
        TestUtils.assertEquals(Double.NaN, StatUtils.variance((double[])x, (int)0, (int)0), 1.0E-14);
        x = new double[]{2.0};
        TestUtils.assertEquals(0.0, StatUtils.variance((double[])x, (int)0, (int)1), 1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        TestUtils.assertEquals(0.5, StatUtils.variance((double[])x, (int)2, (int)2), 1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        TestUtils.assertEquals(0.5, StatUtils.variance((double[])x, (double)2.5, (int)2, (int)2), 1.0E-14);
    }

    @Test
    public void testPopulationVariance() {
        double[] x = null;
        try {
            StatUtils.variance(x, (int)0, (int)4);
            Assert.fail((String)"null is not a valid data array.");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        x = new double[]{};
        TestUtils.assertEquals(Double.NaN, StatUtils.populationVariance((double[])x, (int)0, (int)0), 1.0E-14);
        x = new double[]{2.0};
        TestUtils.assertEquals(0.0, StatUtils.populationVariance((double[])x, (int)0, (int)1), 1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        TestUtils.assertEquals(0.25, StatUtils.populationVariance((double[])x, (int)0, (int)2), 1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        TestUtils.assertEquals(0.25, StatUtils.populationVariance((double[])x, (double)2.5, (int)2, (int)2), 1.0E-14);
    }

    @Test
    public void testMax() {
        double[] x = null;
        try {
            StatUtils.max(x, (int)0, (int)4);
            Assert.fail((String)"null is not a valid data array.");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        x = new double[]{};
        TestUtils.assertEquals(Double.NaN, StatUtils.max((double[])x, (int)0, (int)0), 1.0E-14);
        x = new double[]{2.0};
        TestUtils.assertEquals(2.0, StatUtils.max((double[])x, (int)0, (int)1), 1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        TestUtils.assertEquals(3.0, StatUtils.max((double[])x, (int)1, (int)3), 1.0E-14);
        x = new double[]{Double.NaN, 2.0, 3.0};
        TestUtils.assertEquals(3.0, StatUtils.max((double[])x), 1.0E-14);
        x = new double[]{1.0, Double.NaN, 3.0};
        TestUtils.assertEquals(3.0, StatUtils.max((double[])x), 1.0E-14);
        x = new double[]{1.0, 2.0, Double.NaN};
        TestUtils.assertEquals(2.0, StatUtils.max((double[])x), 1.0E-14);
        x = new double[]{Double.NaN, Double.NaN, Double.NaN};
        TestUtils.assertEquals(Double.NaN, StatUtils.max((double[])x), 1.0E-14);
    }

    @Test
    public void testMin() {
        double[] x = null;
        try {
            StatUtils.min(x, (int)0, (int)4);
            Assert.fail((String)"null is not a valid data array.");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        x = new double[]{};
        TestUtils.assertEquals(Double.NaN, StatUtils.min((double[])x, (int)0, (int)0), 1.0E-14);
        x = new double[]{2.0};
        TestUtils.assertEquals(2.0, StatUtils.min((double[])x, (int)0, (int)1), 1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        TestUtils.assertEquals(2.0, StatUtils.min((double[])x, (int)1, (int)3), 1.0E-14);
        x = new double[]{Double.NaN, 2.0, 3.0};
        TestUtils.assertEquals(2.0, StatUtils.min((double[])x), 1.0E-14);
        x = new double[]{1.0, Double.NaN, 3.0};
        TestUtils.assertEquals(1.0, StatUtils.min((double[])x), 1.0E-14);
        x = new double[]{1.0, 2.0, Double.NaN};
        TestUtils.assertEquals(1.0, StatUtils.min((double[])x), 1.0E-14);
        x = new double[]{Double.NaN, Double.NaN, Double.NaN};
        TestUtils.assertEquals(Double.NaN, StatUtils.min((double[])x), 1.0E-14);
    }

    @Test
    public void testPercentile() {
        double[] x = null;
        try {
            StatUtils.percentile(x, (double)0.25);
            Assert.fail((String)"null is not a valid data array.");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            StatUtils.percentile(x, (int)0, (int)4, (double)0.25);
            Assert.fail((String)"null is not a valid data array.");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        x = new double[]{};
        TestUtils.assertEquals(Double.NaN, StatUtils.percentile((double[])x, (double)25.0), 1.0E-14);
        TestUtils.assertEquals(Double.NaN, StatUtils.percentile((double[])x, (int)0, (int)0, (double)25.0), 1.0E-14);
        x = new double[]{2.0};
        TestUtils.assertEquals(2.0, StatUtils.percentile((double[])x, (double)25.0), 1.0E-14);
        TestUtils.assertEquals(2.0, StatUtils.percentile((double[])x, (int)0, (int)1, (double)25.0), 1.0E-14);
        x = new double[]{1.0, 2.0, 2.0, 3.0};
        TestUtils.assertEquals(2.5, StatUtils.percentile((double[])x, (double)70.0), 1.0E-14);
        TestUtils.assertEquals(2.5, StatUtils.percentile((double[])x, (int)1, (int)3, (double)62.5), 1.0E-14);
    }

    @Test
    public void testDifferenceStats() {
        double[] sample1 = new double[]{1.0, 2.0, 3.0, 4.0};
        double[] sample2 = new double[]{1.0, 3.0, 4.0, 2.0};
        double[] diff = new double[]{0.0, -1.0, -1.0, 2.0};
        double[] small = new double[]{1.0, 4.0};
        double meanDifference = StatUtils.meanDifference((double[])sample1, (double[])sample2);
        Assert.assertEquals((double)StatUtils.sumDifference((double[])sample1, (double[])sample2), (double)StatUtils.sum((double[])diff), (double)1.0E-14);
        Assert.assertEquals((double)meanDifference, (double)StatUtils.mean((double[])diff), (double)1.0E-14);
        Assert.assertEquals((double)StatUtils.varianceDifference((double[])sample1, (double[])sample2, (double)meanDifference), (double)StatUtils.variance((double[])diff), (double)1.0E-14);
        try {
            StatUtils.meanDifference((double[])sample1, (double[])small);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            StatUtils.varianceDifference((double[])sample1, (double[])small, (double)meanDifference);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            double[] single = new double[]{1.0};
            StatUtils.varianceDifference((double[])single, (double[])single, (double)meanDifference);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGeometricMean() {
        double[] test = null;
        try {
            StatUtils.geometricMean(test);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        test = new double[]{2.0, 4.0, 6.0, 8.0};
        Assert.assertEquals((double)FastMath.exp((double)(0.25 * StatUtils.sumLog((double[])test))), (double)StatUtils.geometricMean((double[])test), (double)Double.MIN_VALUE);
        Assert.assertEquals((double)FastMath.exp((double)(0.5 * StatUtils.sumLog((double[])test, (int)0, (int)2))), (double)StatUtils.geometricMean((double[])test, (int)0, (int)2), (double)Double.MIN_VALUE);
    }

    @Test
    public void testNormalize1() {
        double[] sample = new double[]{50.0, 100.0};
        double[] expectedSample = new double[]{-25.0 / FastMath.sqrt((double)1250.0), 25.0 / FastMath.sqrt((double)1250.0)};
        double[] out = StatUtils.normalize((double[])sample);
        for (int i = 0; i < out.length; ++i) {
            Assert.assertTrue((boolean)Precision.equals((double)out[i], (double)expectedSample[i], (int)1));
        }
    }

    @Test
    public void testNormalize2() {
        int length = 77;
        double[] sample = new double[length];
        for (int i = 0; i < length; ++i) {
            sample[i] = FastMath.random();
        }
        double[] standardizedSample = StatUtils.normalize((double[])sample);
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int i = 0; i < length; ++i) {
            stats.addValue(standardizedSample[i]);
        }
        double distance = 1.0E-10;
        Assert.assertEquals((double)0.0, (double)stats.getMean(), (double)distance);
        Assert.assertEquals((double)1.0, (double)stats.getStandardDeviation(), (double)distance);
    }

    @Test
    public void testMode() {
        double[] singleMode = new double[]{0.0, 1.0, 0.0, 2.0, 7.0, 11.0, 12.0};
        double[] modeSingle = StatUtils.mode((double[])singleMode);
        Assert.assertEquals((double)0.0, (double)modeSingle[0], (double)Double.MIN_VALUE);
        Assert.assertEquals((long)1L, (long)modeSingle.length);
        double[] twoMode = new double[]{0.0, 1.0, 2.0, 0.0, 2.0, 3.0, 7.0, 11.0};
        double[] modeDouble = StatUtils.mode((double[])twoMode);
        Assert.assertEquals((double)0.0, (double)modeDouble[0], (double)Double.MIN_VALUE);
        Assert.assertEquals((double)2.0, (double)modeDouble[1], (double)Double.MIN_VALUE);
        Assert.assertEquals((long)2L, (long)modeDouble.length);
        double[] nanInfested = new double[]{0.0, 0.0, 0.0, Double.NaN, Double.NaN, Double.NaN, Double.NaN, 2.0, 2.0, 2.0, 3.0, 5.0};
        double[] modeNan = StatUtils.mode((double[])nanInfested);
        Assert.assertEquals((double)0.0, (double)modeNan[0], (double)Double.MIN_VALUE);
        Assert.assertEquals((double)2.0, (double)modeNan[1], (double)Double.MIN_VALUE);
        Assert.assertEquals((long)2L, (long)modeNan.length);
        double[] infInfested = new double[]{0.0, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, 2.0, 2.0, 3.0, 5.0};
        double[] modeInf = StatUtils.mode((double[])infInfested);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)modeInf[0], (double)Double.MIN_VALUE);
        Assert.assertEquals((double)0.0, (double)modeInf[1], (double)Double.MIN_VALUE);
        Assert.assertEquals((double)2.0, (double)modeInf[2], (double)Double.MIN_VALUE);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)modeInf[3], (double)Double.MIN_VALUE);
        Assert.assertEquals((long)4L, (long)modeInf.length);
        double[] noData = new double[]{};
        double[] modeNodata = StatUtils.mode((double[])noData);
        Assert.assertEquals((long)0L, (long)modeNodata.length);
        double[] nansOnly = new double[]{Double.NaN, Double.NaN};
        double[] modeNansOnly = StatUtils.mode((double[])nansOnly);
        Assert.assertEquals((long)0L, (long)modeNansOnly.length);
        double[] nullArray = null;
        try {
            StatUtils.mode(nullArray);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }
}

