/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class FastMathStrictComparisonTest {
    private static final Double[] DOUBLE_SPECIAL_VALUES = new Double[]{-0.0, 0.0, Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, -1.7976931348623157E308, Double.MAX_VALUE, -Precision.EPSILON, Precision.EPSILON, -Precision.SAFE_MIN, Precision.SAFE_MIN, -4.9E-324, Double.MIN_VALUE};
    private static final Float[] FLOAT_SPECIAL_VALUES = new Float[]{Float.valueOf(-0.0f), Float.valueOf(0.0f), Float.valueOf(Float.NaN), Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.valueOf(-1.4E-45f), Float.valueOf(-3.4028235E38f)};
    private static final Object[] LONG_SPECIAL_VALUES = new Object[]{-1, 0, 1, Long.MIN_VALUE, Long.MAX_VALUE};
    private static final Object[] INT_SPECIAL_VALUES = new Object[]{-1, 0, 1, Integer.MIN_VALUE, Integer.MAX_VALUE};
    private final Method mathMethod;
    private final Method fastMethod;
    private final Type[] types;
    private final Object[][] valueArrays;

    public FastMathStrictComparisonTest(Method m, Method f, Type[] types, Object[][] data) throws Exception {
        this.mathMethod = m;
        this.fastMethod = f;
        this.types = types;
        this.valueArrays = data;
    }

    @Test
    public void test1() throws Exception {
        FastMathStrictComparisonTest.setupMethodCall(this.mathMethod, this.fastMethod, this.types, this.valueArrays);
    }

    private static boolean isNumber(Double d) {
        return !d.isInfinite() && !d.isNaN();
    }

    private static boolean isNumber(Float f) {
        return !f.isInfinite() && !f.isNaN();
    }

    private static void reportFailedResults(Method mathMethod, Object[] params, Object expected, Object actual, int[] entries) {
        Number act;
        Number exp;
        String methodName = mathMethod.getName();
        String format = null;
        long actL = 0L;
        long expL = 0L;
        if (expected instanceof Double) {
            exp = (Double)expected;
            act = (Double)actual;
            if (FastMathStrictComparisonTest.isNumber((Double)exp) && FastMathStrictComparisonTest.isNumber((Double)act) && (Double)exp != 0.0) {
                actL = Double.doubleToLongBits((Double)act);
                if (Math.abs(actL - (expL = Double.doubleToLongBits((Double)exp))) == 1L && (methodName.equals("toRadians") || methodName.equals("atan2"))) {
                    return;
                }
                format = "%016x";
            }
        } else if (expected instanceof Float) {
            exp = (Float)expected;
            act = (Float)actual;
            if (FastMathStrictComparisonTest.isNumber((Float)exp) && FastMathStrictComparisonTest.isNumber((Float)act) && ((Float)exp).floatValue() != 0.0f) {
                actL = Float.floatToIntBits(((Float)act).floatValue());
                expL = Float.floatToIntBits(((Float)exp).floatValue());
                format = "%08x";
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(mathMethod.getReturnType().getSimpleName());
        sb.append(" ");
        sb.append(methodName);
        sb.append("(");
        String sep = "";
        for (Object o : params) {
            sb.append(sep);
            sb.append(o);
            sep = ", ";
        }
        sb.append(") expected ");
        if (format != null) {
            sb.append(String.format(format, expL));
        } else {
            sb.append(expected);
        }
        sb.append(" actual ");
        if (format != null) {
            sb.append(String.format(format, actL));
        } else {
            sb.append(actual);
        }
        sb.append(" entries ");
        sb.append(Arrays.toString(entries));
        String message = sb.toString();
        boolean fatal = true;
        Assert.fail((String)message);
    }

    private static void callMethods(Method mathMethod, Method fastMethod, Object[] params, int[] entries) throws IllegalAccessException {
        try {
            Object actual;
            Object expected;
            try {
                expected = mathMethod.invoke((Object)mathMethod, params);
            }
            catch (InvocationTargetException ite) {
                expected = ite.getCause();
            }
            try {
                actual = fastMethod.invoke((Object)mathMethod, params);
            }
            catch (InvocationTargetException ite) {
                actual = ite.getCause();
            }
            if (expected instanceof ArithmeticException) {
                Assert.assertEquals(MathArithmeticException.class, actual.getClass());
            } else if (!expected.equals(actual)) {
                FastMathStrictComparisonTest.reportFailedResults(mathMethod, params, expected, actual, entries);
            }
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)(mathMethod + " " + e));
        }
    }

    private static void setupMethodCall(Method mathMethod, Method fastMethod, Type[] types, Object[][] valueArrays) throws Exception {
        Object[] params = new Object[types.length];
        int entry1 = 0;
        int[] entries = new int[types.length];
        Object[] arr$ = valueArrays[0];
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Object d;
            params[0] = d = arr$[i$];
            entries[0] = ++entry1;
            if (params.length > 1) {
                int entry2 = 0;
                Object[] arr$2 = valueArrays[1];
                int len$2 = arr$2.length;
                for (int i$2 = 0; i$2 < len$2; ++i$2) {
                    Object d1;
                    params[1] = d1 = arr$2[i$2];
                    entries[1] = ++entry2;
                    FastMathStrictComparisonTest.callMethods(mathMethod, fastMethod, params, entries);
                }
                continue;
            }
            FastMathStrictComparisonTest.callMethods(mathMethod, fastMethod, params, entries);
        }
    }

    @Parameterized.Parameters
    public static List<Object[]> data() throws Exception {
        String singleMethod = System.getProperty("testMethod");
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        block2: for (Method mathMethod : StrictMath.class.getDeclaredMethods()) {
            Type[] types;
            if (!Modifier.isPublic(mathMethod.getModifiers()) || (types = mathMethod.getGenericParameterTypes()).length < 1) continue;
            try {
                Method fastMethod = FastMath.class.getDeclaredMethod(mathMethod.getName(), (Class[])types);
                if (Modifier.isPublic(fastMethod.getModifiers())) {
                    if (singleMethod != null && !fastMethod.getName().equals(singleMethod)) continue;
                    Object[][] values = new Object[types.length][];
                    int index = 0;
                    for (Type t : types) {
                        if (t.equals(Double.TYPE)) {
                            values[index] = DOUBLE_SPECIAL_VALUES;
                        } else if (t.equals(Float.TYPE)) {
                            values[index] = FLOAT_SPECIAL_VALUES;
                        } else if (t.equals(Long.TYPE)) {
                            values[index] = LONG_SPECIAL_VALUES;
                        } else if (t.equals(Integer.TYPE)) {
                            values[index] = INT_SPECIAL_VALUES;
                        } else {
                            System.out.println("Cannot handle class " + t + " for " + mathMethod);
                            continue block2;
                        }
                        ++index;
                    }
                    list.add(new Object[]{mathMethod, fastMethod, types, values});
                    continue;
                }
                System.out.println("Cannot find public FastMath method corresponding to: " + mathMethod);
            }
            catch (NoSuchMethodException e) {
                System.out.println("Cannot find FastMath method corresponding to: " + mathMethod);
            }
        }
        return list;
    }
}

