/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive;

import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.UnivariateStatisticAbstractTest;
import org.apache.commons.math3.stat.descriptive.moment.SecondMoment;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public abstract class StorelessUnivariateStatisticAbstractTest
extends UnivariateStatisticAbstractTest {
    protected double[][] smallSamples = new double[][]{new double[0], {1.0}, {1.0, 2.0}, {1.0, 2.0, 3.0}, {1.0, 2.0, 3.0, 4.0}};

    public abstract UnivariateStatistic getUnivariateStatistic();

    public abstract double expectedValue();

    @Test
    public void testIncrementation() {
        StorelessUnivariateStatistic statistic = (StorelessUnivariateStatistic)this.getUnivariateStatistic();
        for (int i = 0; i < this.testArray.length; ++i) {
            statistic.increment(this.testArray[i]);
        }
        Assert.assertEquals((double)this.expectedValue(), (double)statistic.getResult(), (double)this.getTolerance());
        Assert.assertEquals((long)this.testArray.length, (long)statistic.getN());
        statistic.clear();
        statistic.incrementAll(this.testArray);
        Assert.assertEquals((double)this.expectedValue(), (double)statistic.getResult(), (double)this.getTolerance());
        Assert.assertEquals((long)this.testArray.length, (long)statistic.getN());
        statistic.clear();
        this.checkClearValue(statistic);
        Assert.assertEquals((long)0L, (long)statistic.getN());
    }

    protected void checkClearValue(StorelessUnivariateStatistic statistic) {
        Assert.assertTrue((boolean)Double.isNaN(statistic.getResult()));
    }

    @Test
    public void testSerialization() {
        StorelessUnivariateStatistic statistic = (StorelessUnivariateStatistic)this.getUnivariateStatistic();
        TestUtils.checkSerializedEquality(statistic);
        statistic.clear();
        for (int i = 0; i < this.testArray.length; ++i) {
            statistic.increment(this.testArray[i]);
            if (i % 5 != 0) continue;
            statistic = (StorelessUnivariateStatistic)TestUtils.serializeAndRecover(statistic);
        }
        TestUtils.checkSerializedEquality(statistic);
        Assert.assertEquals((double)this.expectedValue(), (double)statistic.getResult(), (double)this.getTolerance());
        statistic.clear();
        this.checkClearValue(statistic);
    }

    @Test
    public void testEqualsAndHashCode() {
        StorelessUnivariateStatistic statistic2;
        StorelessUnivariateStatistic statistic = (StorelessUnivariateStatistic)this.getUnivariateStatistic();
        Assert.assertTrue((String)"non-null, compared to null", (!statistic.equals(statistic2 = null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"reflexive, non-null", (boolean)statistic.equals(statistic));
        int emptyHash = statistic.hashCode();
        statistic2 = (StorelessUnivariateStatistic)this.getUnivariateStatistic();
        Assert.assertTrue((String)"empty stats should be equal", (boolean)statistic.equals(statistic2));
        Assert.assertEquals((String)"empty stats should have the same hashcode", (long)emptyHash, (long)statistic2.hashCode());
        statistic.increment(1.0);
        Assert.assertTrue((String)"reflexive, non-empty", (boolean)statistic.equals(statistic));
        Assert.assertTrue((String)"non-empty, compared to empty", (!statistic.equals(statistic2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"non-empty, compared to empty", (!statistic2.equals(statistic) ? 1 : 0) != 0);
        Assert.assertTrue((String)"non-empty stat should have different hashcode from empty stat", (statistic.hashCode() != emptyHash ? 1 : 0) != 0);
        statistic2.increment(1.0);
        Assert.assertTrue((String)"stats with same data should be equal", (boolean)statistic.equals(statistic2));
        Assert.assertEquals((String)"stats with same data should have the same hashcode", (long)statistic.hashCode(), (long)statistic2.hashCode());
        statistic.increment(Double.POSITIVE_INFINITY);
        Assert.assertTrue((String)"stats with different n's should not be equal", (!statistic2.equals(statistic) ? 1 : 0) != 0);
        Assert.assertTrue((String)"stats with different n's should have different hashcodes", (statistic.hashCode() != statistic2.hashCode() ? 1 : 0) != 0);
        statistic2.increment(Double.POSITIVE_INFINITY);
        Assert.assertTrue((String)"stats with same data should be equal", (boolean)statistic.equals(statistic2));
        Assert.assertEquals((String)"stats with same data should have the same hashcode", (long)statistic.hashCode(), (long)statistic2.hashCode());
        statistic.clear();
        statistic2.clear();
        Assert.assertTrue((String)"cleared stats should be equal", (boolean)statistic.equals(statistic2));
        Assert.assertEquals((String)"cleared stats should have thashcode of empty stat", (long)emptyHash, (long)statistic2.hashCode());
        Assert.assertEquals((String)"cleared stats should have thashcode of empty stat", (long)emptyHash, (long)statistic.hashCode());
    }

    @Test
    public void testMomentSmallSamples() {
        UnivariateStatistic stat = this.getUnivariateStatistic();
        if (stat instanceof SecondMoment) {
            SecondMoment moment = (SecondMoment)this.getUnivariateStatistic();
            Assert.assertTrue((boolean)Double.isNaN(moment.getResult()));
            moment.increment(1.0);
            Assert.assertEquals((double)0.0, (double)moment.getResult(), (double)0.0);
        }
    }

    @Test
    public void testConsistency() {
        StorelessUnivariateStatistic stat = (StorelessUnivariateStatistic)this.getUnivariateStatistic();
        stat.incrementAll(this.testArray);
        Assert.assertEquals((double)stat.getResult(), (double)stat.evaluate(this.testArray), (double)this.getTolerance());
        for (int i = 0; i < this.smallSamples.length; ++i) {
            stat.clear();
            for (int j = 0; j < this.smallSamples[i].length; ++j) {
                stat.increment(this.smallSamples[i][j]);
            }
            TestUtils.assertEquals(stat.getResult(), stat.evaluate(this.smallSamples[i]), this.getTolerance());
        }
    }

    @Test
    public void testCopyConsistency() {
        StorelessUnivariateStatistic master = (StorelessUnivariateStatistic)this.getUnivariateStatistic();
        StorelessUnivariateStatistic replica = null;
        long index = FastMath.round((double)(FastMath.random() * (double)this.testArray.length));
        master.incrementAll(this.testArray, 0, (int)index);
        replica = master.copy();
        Assert.assertTrue((boolean)replica.equals(master));
        Assert.assertTrue((boolean)master.equals(replica));
        master.incrementAll(this.testArray, (int)index, (int)((long)this.testArray.length - index));
        replica.incrementAll(this.testArray, (int)index, (int)((long)this.testArray.length - index));
        Assert.assertTrue((boolean)replica.equals(master));
        Assert.assertTrue((boolean)master.equals(replica));
    }

    @Test
    public void testSerial() {
        StorelessUnivariateStatistic s = (StorelessUnivariateStatistic)this.getUnivariateStatistic();
        Assert.assertEquals((Object)s, (Object)TestUtils.serializeAndRecover(s));
    }
}

