/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.geometry.euclidean.twod.BoundarySource2D;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.LinecastPoint2D;
import org.apache.commons.geometry.euclidean.twod.Linecastable2D;
import org.apache.commons.geometry.euclidean.twod.Vector2D;

final class BoundarySourceLinecaster2D
implements Linecastable2D {
    private final BoundarySource2D boundarySrc;

    BoundarySourceLinecaster2D(BoundarySource2D boundarySrc) {
        this.boundarySrc = boundarySrc;
    }

    @Override
    public List<LinecastPoint2D> linecast(LineConvexSubset subset) {
        try (Stream<LinecastPoint2D> stream = this.getIntersectionStream(subset);){
            List results = stream.collect(Collectors.toCollection(ArrayList::new));
            LinecastPoint2D.sortAndFilter(results);
            List list = results;
            return list;
        }
    }

    @Override
    public LinecastPoint2D linecastFirst(LineConvexSubset subset) {
        try (Stream<LinecastPoint2D> stream = this.getIntersectionStream(subset);){
            LinecastPoint2D linecastPoint2D = stream.min(LinecastPoint2D.ABSCISSA_ORDER).orElse(null);
            return linecastPoint2D;
        }
    }

    private Stream<LinecastPoint2D> getIntersectionStream(LineConvexSubset subset) {
        return this.boundarySrc.boundaryStream().map(boundary -> this.computeIntersection((LineConvexSubset)boundary, subset)).filter(Objects::nonNull);
    }

    private LinecastPoint2D computeIntersection(LineConvexSubset boundary, LineConvexSubset subset) {
        Vector2D intersectionPt = boundary.intersection(subset);
        if (intersectionPt != null) {
            Vector2D normal = boundary.getLine().getOffsetDirection();
            return new LinecastPoint2D(intersectionPt, normal, subset.getLine());
        }
        return null;
    }
}

