/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.commons.beanutils.LazyDynaClass;
import org.apache.commons.beanutils.LazyDynaMap;
import org.apache.commons.beanutils.PropertyUtils;

public class LazyDynaBeanTestCase
extends TestCase {
    protected LazyDynaBean bean;
    protected LazyDynaClass dynaClass;
    protected String testProperty = "myProperty";
    protected String testPropertyA = "myProperty-A";
    protected String testPropertyB = "myProperty-B";
    protected String testString1 = "myStringValue-1";
    protected String testString2 = "myStringValue-2";
    protected Integer testInteger1 = 30;
    protected Integer testInteger2 = 40;
    protected String testKey = "myKey";

    public static void main(String[] args) {
        TestRunner.run((Test)LazyDynaBeanTestCase.suite());
    }

    public static Test suite() {
        return new TestSuite(LazyDynaBeanTestCase.class);
    }

    public LazyDynaBeanTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.bean = new LazyDynaBean();
        this.dynaClass = (LazyDynaClass)this.bean.getDynaClass();
        this.dynaClass.setReturnNull(true);
    }

    public void tearDown() {
        this.bean = null;
    }

    public void testIndexedDynaBeanArray() {
        int index = 3;
        LazyDynaMap[] objectArray = new LazyDynaMap[]{};
        LazyDynaBeanTestCase.assertNull((String)"Check Indexed Property doesn't exist", (Object)this.dynaClass.getDynaProperty(this.testProperty));
        LazyDynaBeanTestCase.assertNull((String)"Check Indexed Property is null", (Object)this.bean.get(this.testProperty));
        this.dynaClass.add(this.testProperty, objectArray.getClass());
        LazyDynaBeanTestCase.assertEquals((String)"Check Indexed Property exists", objectArray.getClass(), (Object)this.dynaClass.getDynaProperty(this.testProperty).getType());
        LazyDynaBeanTestCase.assertEquals((String)"Check Indexed Property is correct type", objectArray.getClass(), this.bean.get(this.testProperty).getClass());
        for (int i = 3; i >= 0; --i) {
            LazyDynaBeanTestCase.assertEquals((String)"Check Array Components initialized", LazyDynaMap.class, this.bean.get(this.testProperty, 3).getClass());
        }
        this.dynaClass.add(this.testPropertyB, objectArray.getClass());
        LazyDynaMap newMap = new LazyDynaMap();
        newMap.set(this.testPropertyB, (Object)this.testString2);
        this.bean.set(this.testPropertyA, 3, (Object)newMap);
        LazyDynaBeanTestCase.assertEquals((String)"Check Indexed Value is correct(a)", (Object)this.testString2, (Object)((DynaBean)this.bean.get(this.testPropertyA, 3)).get(this.testPropertyB));
    }

    public void testIndexedInvalidType() {
        int index = 3;
        this.dynaClass.add(this.testProperty, String.class);
        LazyDynaBeanTestCase.assertFalse((String)"Check Property is not indexed", (boolean)this.dynaClass.getDynaProperty(this.testProperty).isIndexed());
        try {
            this.bean.set(this.testProperty, 3, (Object)this.testString1);
            LazyDynaBeanTestCase.fail((String)"set(property, index, value) should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIndexedLinkedList() {
        int index = 3;
        LazyDynaBeanTestCase.assertNull((String)"Check Indexed Property doesn't exist", (Object)this.dynaClass.getDynaProperty(this.testProperty));
        LazyDynaBeanTestCase.assertNull((String)"Check Indexed Property is null", (Object)this.bean.get(this.testProperty));
        this.dynaClass.add(this.testProperty, LinkedList.class);
        LazyDynaBeanTestCase.assertTrue((String)"Check Property is indexed", (boolean)this.dynaClass.getDynaProperty(this.testProperty).isIndexed());
        LazyDynaBeanTestCase.assertEquals((String)"Check Property is correct type", LinkedList.class, (Object)this.dynaClass.getDynaProperty(this.testProperty).getType());
        LazyDynaBeanTestCase.assertEquals((String)"Check Property type is correct", LinkedList.class, this.bean.get(this.testProperty).getClass());
        this.bean.set(this.testProperty, index, (Object)this.testString1);
        LazyDynaBeanTestCase.assertEquals((String)"Check Property type is correct", LinkedList.class, this.bean.get(this.testProperty).getClass());
        LazyDynaBeanTestCase.assertEquals((String)"Check First Indexed Value is correct", (Object)this.testString1, (Object)this.bean.get(this.testProperty, index));
        LazyDynaBeanTestCase.assertEquals((String)"Check First Array length is correct", (Object)(index + 1), (Object)((LinkedList)this.bean.get(this.testProperty)).size());
        this.bean.set(this.testProperty, index += 2, (Object)this.testInteger1);
        LazyDynaBeanTestCase.assertEquals((String)"Check Second Indexed Value is correct", (Object)this.testInteger1, (Object)this.bean.get(this.testProperty, index));
        LazyDynaBeanTestCase.assertEquals((String)"Check Second Array length is correct", (Object)(index + 1), (Object)((LinkedList)this.bean.get(this.testProperty)).size());
    }

    public void testIndexedObjectArray() {
        int index = 3;
        String[] objectArray = new String[]{};
        LazyDynaBeanTestCase.assertNull((String)"Check Indexed Property doesn't exist", (Object)this.dynaClass.getDynaProperty(this.testProperty));
        LazyDynaBeanTestCase.assertNull((String)"Check Indexed Property is null", (Object)this.bean.get(this.testProperty));
        this.dynaClass.add(this.testProperty, objectArray.getClass());
        LazyDynaBeanTestCase.assertEquals((String)"Check Indexed Property exists", objectArray.getClass(), (Object)this.dynaClass.getDynaProperty(this.testProperty).getType());
        LazyDynaBeanTestCase.assertEquals((String)"Check Indexed Property is correct type", objectArray.getClass(), this.bean.get(this.testProperty).getClass());
        this.bean.set(this.testProperty, index, (Object)this.testString1);
        LazyDynaBeanTestCase.assertNotNull((String)"Check Indexed Property is not null", (Object)this.bean.get(this.testProperty));
        LazyDynaBeanTestCase.assertEquals((String)"Check Indexed Property is correct type", objectArray.getClass(), this.bean.get(this.testProperty).getClass());
        LazyDynaBeanTestCase.assertEquals((String)"Check First Indexed Value is correct(a)", (Object)this.testString1, (Object)this.bean.get(this.testProperty, index));
        LazyDynaBeanTestCase.assertEquals((String)"Check First Indexed Value is correct(b)", (String)this.testString1, (String)((String[])this.bean.get(this.testProperty))[index]);
        LazyDynaBeanTestCase.assertEquals((String)"Check Array length is correct", (Object)(index + 1), (Object)((String[])this.bean.get(this.testProperty)).length);
        this.bean.set(this.testProperty, index += 2, (Object)this.testString2);
        LazyDynaBeanTestCase.assertEquals((String)"Check Second Indexed Value is correct(a)", (Object)this.testString2, (Object)this.bean.get(this.testProperty, index));
        LazyDynaBeanTestCase.assertEquals((String)"Check Second Indexed Value is correct(b)", (String)this.testString2, (String)((String[])this.bean.get(this.testProperty))[index]);
        LazyDynaBeanTestCase.assertEquals((String)"Check Second Array length is correct", (Object)(index + 1), (Object)((String[])this.bean.get(this.testProperty)).length);
    }

    public void testIndexedPrimitiveArray() {
        int index = 3;
        int[] primitiveArray = new int[]{};
        LazyDynaBeanTestCase.assertNull((String)"Check Indexed Property doesn't exist", (Object)this.dynaClass.getDynaProperty(this.testProperty));
        LazyDynaBeanTestCase.assertNull((String)"Check Indexed Property is null", (Object)this.bean.get(this.testProperty));
        this.dynaClass.add(this.testProperty, primitiveArray.getClass());
        LazyDynaBeanTestCase.assertEquals((String)"Check Indexed Property exists", primitiveArray.getClass(), (Object)this.dynaClass.getDynaProperty(this.testProperty).getType());
        LazyDynaBeanTestCase.assertEquals((String)"Check Indexed Property is correct type", primitiveArray.getClass(), this.bean.get(this.testProperty).getClass());
        this.bean.set(this.testProperty, index, (Object)this.testInteger1);
        LazyDynaBeanTestCase.assertNotNull((String)"Check Indexed Property is not null", (Object)this.bean.get(this.testProperty));
        LazyDynaBeanTestCase.assertEquals((String)"Check Indexed Property is correct type", primitiveArray.getClass(), this.bean.get(this.testProperty).getClass());
        LazyDynaBeanTestCase.assertEquals((String)"Check First Indexed Value is correct(a)", (Object)this.testInteger1, (Object)this.bean.get(this.testProperty, index));
        LazyDynaBeanTestCase.assertEquals((String)"Check First Indexed Value is correct(b)", (Object)this.testInteger1, (Object)((int[])this.bean.get(this.testProperty))[index]);
        LazyDynaBeanTestCase.assertEquals((String)"Check Array length is correct", (Object)(index + 1), (Object)((int[])this.bean.get(this.testProperty)).length);
        this.bean.set(this.testProperty, index += 2, (Object)this.testInteger2);
        LazyDynaBeanTestCase.assertEquals((String)"Check Second Indexed Value is correct(a)", (Object)this.testInteger2, (Object)this.bean.get(this.testProperty, index));
        LazyDynaBeanTestCase.assertEquals((String)"Check Second Indexed Value is correct(b)", (Object)this.testInteger2, (Object)((int[])this.bean.get(this.testProperty))[index]);
        LazyDynaBeanTestCase.assertEquals((String)"Check Second Array length is correct", (Object)(index + 1), (Object)((int[])this.bean.get(this.testProperty)).length);
    }

    public void testIndexedPropertyDefault() {
        int index = 3;
        LazyDynaBeanTestCase.assertNull((String)"Check Indexed Property doesn't exist", (Object)this.dynaClass.getDynaProperty(this.testProperty));
        LazyDynaBeanTestCase.assertNull((String)"Check Indexed Property is null", (Object)this.bean.get(this.testProperty));
        LazyDynaBeanTestCase.assertNull((String)"Check Indexed value is null", (Object)this.bean.get(this.testProperty, index));
        this.bean.set(this.testProperty, index, (Object)this.testInteger1);
        LazyDynaBeanTestCase.assertNotNull((String)"Check Indexed Property is not null", (Object)this.bean.get(this.testProperty));
        LazyDynaBeanTestCase.assertEquals((String)"Check Indexed Property is correct type", ArrayList.class, this.bean.get(this.testProperty).getClass());
        LazyDynaBeanTestCase.assertEquals((String)"Check First Indexed Value is correct", (Object)this.testInteger1, (Object)this.bean.get(this.testProperty, index));
        LazyDynaBeanTestCase.assertEquals((String)"Check First Array length is correct", (Object)(index + 1), (Object)((ArrayList)this.bean.get(this.testProperty)).size());
        this.bean.set(this.testProperty, index += 2, (Object)this.testString1);
        LazyDynaBeanTestCase.assertEquals((String)"Check Second Indexed Value is correct", (Object)this.testString1, (Object)this.bean.get(this.testProperty, index));
        LazyDynaBeanTestCase.assertEquals((String)"Check Second Array length is correct", (Object)(index + 1), (Object)((ArrayList)this.bean.get(this.testProperty)).size());
    }

    public void testIndexedPropertyRestricted() {
        int index = 3;
        this.dynaClass.setRestricted(true);
        LazyDynaBeanTestCase.assertTrue((String)"Check MutableDynaClass is restricted", (boolean)this.dynaClass.isRestricted());
        LazyDynaBeanTestCase.assertNull((String)"Check Property doesn't exist", (Object)this.dynaClass.getDynaProperty(this.testProperty));
        LazyDynaBeanTestCase.assertNull((String)"Check Value is null", (Object)this.bean.get(this.testProperty));
        try {
            this.bean.set(this.testProperty, 3, (Object)this.testInteger1);
            LazyDynaBeanTestCase.fail((String)"expected IllegalArgumentException trying to add new property to restricted MutableDynaClass");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIndexedPropertyUtils() {
        int index = 3;
        this.dynaClass.setReturnNull(false);
        LazyDynaBeanTestCase.assertFalse((String)"Check Indexed Property doesn't exist", (boolean)this.dynaClass.isDynaProperty(this.testProperty));
        LazyDynaBeanTestCase.assertNull((String)"Check Indexed Property is null", (Object)this.bean.get(this.testProperty));
        LazyDynaBeanTestCase.assertNull((String)"Check Indexed value is null", (Object)this.bean.get(this.testProperty, 3));
        try {
            PropertyUtils.setProperty((Object)this.bean, (String)(this.testProperty + "[" + 3 + "]"), (Object)this.testString1);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LazyDynaBeanTestCase.fail((String)("testIndexedPropertyUtils threw " + ex));
        }
        LazyDynaBeanTestCase.assertEquals((String)"Check Indexed Bean Value is correct", (Object)this.testString1, (Object)this.bean.get(this.testProperty, 3));
    }

    public void testMappedInvalidType() {
        this.dynaClass.add(this.testProperty, String.class);
        LazyDynaBeanTestCase.assertFalse((String)"Check Property is not mapped", (boolean)this.dynaClass.getDynaProperty(this.testProperty).isMapped());
        try {
            this.bean.set(this.testProperty, this.testKey, (Object)this.testInteger1);
            LazyDynaBeanTestCase.fail((String)"set(property, key, value) should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMappedPropertyDefault() {
        LazyDynaBeanTestCase.assertNull((String)"Check Mapped Property doesn't exist", (Object)this.dynaClass.getDynaProperty(this.testProperty));
        LazyDynaBeanTestCase.assertNull((String)"Check Map is null", (Object)this.bean.get(this.testProperty));
        LazyDynaBeanTestCase.assertNull((String)"Check Mapped Value is null", (Object)this.bean.get(this.testProperty, this.testKey));
        this.bean.set(this.testProperty, this.testKey, (Object)this.testInteger1);
        LazyDynaBeanTestCase.assertEquals((String)"Check Mapped Property exists", HashMap.class, this.bean.get(this.testProperty).getClass());
        LazyDynaBeanTestCase.assertEquals((String)"Check First Mapped Value is correct(a)", (Object)this.testInteger1, (Object)this.bean.get(this.testProperty, this.testKey));
        LazyDynaBeanTestCase.assertEquals((String)"Check First Mapped Value is correct(b)", (Object)this.testInteger1, ((HashMap)this.bean.get(this.testProperty)).get(this.testKey));
        this.bean.set(this.testProperty, this.testKey, (Object)this.testInteger2);
        LazyDynaBeanTestCase.assertEquals((String)"Check Second Mapped Value is correct(a)", (Object)this.testInteger2, (Object)this.bean.get(this.testProperty, this.testKey));
        LazyDynaBeanTestCase.assertEquals((String)"Check Second Mapped Value is correct(b)", (Object)this.testInteger2, ((HashMap)this.bean.get(this.testProperty)).get(this.testKey));
    }

    public void testMappedPropertyRestricted() {
        this.dynaClass.setRestricted(true);
        LazyDynaBeanTestCase.assertTrue((String)"Check MutableDynaClass is restricted", (boolean)this.dynaClass.isRestricted());
        LazyDynaBeanTestCase.assertNull((String)"Check Property doesn't exist", (Object)this.dynaClass.getDynaProperty(this.testProperty));
        LazyDynaBeanTestCase.assertNull((String)"Check Value is null", (Object)this.bean.get(this.testProperty));
        try {
            this.bean.set(this.testProperty, this.testKey, (Object)this.testInteger1);
            LazyDynaBeanTestCase.fail((String)"expected IllegalArgumentException trying to add new property to restricted MutableDynaClass");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMappedPropertyTreeMap() {
        LazyDynaBeanTestCase.assertNull((String)"Check Mapped Property doesn't exist", (Object)this.dynaClass.getDynaProperty(this.testProperty));
        this.dynaClass.add(this.testProperty, TreeMap.class);
        LazyDynaBeanTestCase.assertTrue((String)"Check Property is mapped", (boolean)this.dynaClass.getDynaProperty(this.testProperty).isMapped());
        LazyDynaBeanTestCase.assertEquals((String)"Check Property is correct type", TreeMap.class, (Object)this.dynaClass.getDynaProperty(this.testProperty).getType());
        LazyDynaBeanTestCase.assertEquals((String)"Check Mapped Property exists", TreeMap.class, this.bean.get(this.testProperty).getClass());
        this.bean.set(this.testProperty, this.testKey, (Object)this.testInteger1);
        LazyDynaBeanTestCase.assertEquals((String)"Check Mapped Property exists", TreeMap.class, this.bean.get(this.testProperty).getClass());
        LazyDynaBeanTestCase.assertEquals((String)"Check First Mapped Value is correct(a)", (Object)this.testInteger1, (Object)this.bean.get(this.testProperty, this.testKey));
        LazyDynaBeanTestCase.assertEquals((String)"Check First Mapped Value is correct(b)", (Object)this.testInteger1, ((TreeMap)this.bean.get(this.testProperty)).get(this.testKey));
        this.bean.set(this.testProperty, this.testKey, (Object)this.testInteger2);
        LazyDynaBeanTestCase.assertEquals((String)"Check Second Mapped Value is correct(a)", (Object)this.testInteger2, (Object)this.bean.get(this.testProperty, this.testKey));
        LazyDynaBeanTestCase.assertEquals((String)"Check Second Mapped Value is correct(b)", (Object)this.testInteger2, ((TreeMap)this.bean.get(this.testProperty)).get(this.testKey));
    }

    public void testMappedPropertyUtils() {
        this.dynaClass.setReturnNull(false);
        LazyDynaBeanTestCase.assertFalse((String)"Check Mapped Property doesn't exist", (boolean)this.dynaClass.isDynaProperty(this.testProperty));
        LazyDynaBeanTestCase.assertNull((String)"Check Map is null", (Object)this.bean.get(this.testProperty));
        LazyDynaBeanTestCase.assertNull((String)"Check Mapped Value is null", (Object)this.bean.get(this.testProperty, this.testKey));
        try {
            PropertyUtils.setProperty((Object)this.bean, (String)(this.testProperty + "(" + this.testKey + ")"), (Object)this.testString1);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LazyDynaBeanTestCase.fail((String)("testIndexedPropertyUtils threw " + ex));
        }
        LazyDynaBeanTestCase.assertEquals((String)"Check Mapped Bean Value is correct", (Object)this.testString1, (Object)this.bean.get(this.testProperty, this.testKey));
    }

    public void testNullProperty() {
        LazyDynaBeanTestCase.assertNull((String)"Check Property doesn't exist", (Object)this.dynaClass.getDynaProperty(this.testProperty));
        LazyDynaBeanTestCase.assertNull((String)"Check Value is null", (Object)this.bean.get(this.testProperty));
        this.bean.set(this.testProperty, null);
        LazyDynaBeanTestCase.assertNull((String)"Check Value is still null", (Object)this.bean.get(this.testProperty));
    }

    public void testSimpleProperty() {
        LazyDynaBeanTestCase.assertNull((String)"Check Property doesn't exist", (Object)this.dynaClass.getDynaProperty(this.testProperty));
        LazyDynaBeanTestCase.assertNull((String)"Check Value is null", (Object)this.bean.get(this.testProperty));
        this.bean.set(this.testProperty, (Object)this.testInteger1);
        LazyDynaBeanTestCase.assertEquals((String)"Check First Value is correct", (Object)this.testInteger1, (Object)this.bean.get(this.testProperty));
        LazyDynaBeanTestCase.assertEquals((String)"Check Property type is correct", Integer.class, (Object)this.dynaClass.getDynaProperty(this.testProperty).getType());
        this.bean.set(this.testProperty, (Object)this.testInteger2);
        LazyDynaBeanTestCase.assertEquals((String)"Check Second Value is correct", (Object)this.testInteger2, (Object)this.bean.get(this.testProperty));
        try {
            this.bean.set(this.testProperty, (Object)this.testString1);
            LazyDynaBeanTestCase.fail((String)"expected ConversionException trying to set an Integer property to a String");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testSimplePropertyRestricted() {
        this.dynaClass.setRestricted(true);
        LazyDynaBeanTestCase.assertTrue((String)"Check MutableDynaClass is restricted", (boolean)this.dynaClass.isRestricted());
        LazyDynaBeanTestCase.assertNull((String)"Check Property doesn't exist", (Object)this.dynaClass.getDynaProperty(this.testProperty));
        LazyDynaBeanTestCase.assertNull((String)"Check Value is null", (Object)this.bean.get(this.testProperty));
        try {
            this.bean.set(this.testProperty, (Object)this.testString1);
            LazyDynaBeanTestCase.fail((String)"expected IllegalArgumentException trying to add new property to restricted DynaClass");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

