package org.apache.cayenne.testdo.inheritance.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

import org.apache.cayenne.BaseDataObject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.ListProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.testdo.inheritance.BaseEntity;
import org.apache.cayenne.testdo.inheritance.SubEntity;

/**
 * Class _RelatedEntity was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _RelatedEntity extends BaseDataObject {

    private static final long serialVersionUID = 1L; 

    public static final NumericProperty<Integer> RELATED_ENTITY_ID_PK_PROPERTY = PropertyFactory.createNumeric(ExpressionFactory.dbPathExp("RELATED_ENTITY_ID"), Integer.class);
    public static final String RELATED_ENTITY_ID_PK_COLUMN = "RELATED_ENTITY_ID";

    public static final ListProperty<BaseEntity> BASE_ENTITIES = PropertyFactory.createList("baseEntities", BaseEntity.class);
    public static final ListProperty<SubEntity> SUB_ENTITIES = PropertyFactory.createList("subEntities", SubEntity.class);


    protected Object baseEntities;
    protected Object subEntities;

    public void addToBaseEntities(BaseEntity obj) {
        addToManyTarget("baseEntities", obj, true);
    }

    public void removeFromBaseEntities(BaseEntity obj) {
        removeToManyTarget("baseEntities", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<BaseEntity> getBaseEntities() {
        return (List<BaseEntity>)readProperty("baseEntities");
    }

    public void addToSubEntities(SubEntity obj) {
        addToManyTarget("subEntities", obj, true);
    }

    public void removeFromSubEntities(SubEntity obj) {
        removeToManyTarget("subEntities", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<SubEntity> getSubEntities() {
        return (List<SubEntity>)readProperty("subEntities");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "baseEntities":
                return this.baseEntities;
            case "subEntities":
                return this.subEntities;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "baseEntities":
                this.baseEntities = val;
                break;
            case "subEntities":
                this.subEntities = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.baseEntities);
        out.writeObject(this.subEntities);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.baseEntities = in.readObject();
        this.subEntities = in.readObject();
    }

}
