--  Licensed to the Apache Software Foundation (ASF) under one
--  or more contributor license agreements.  See the NOTICE file
--  distributed with this work for additional information
-- regarding copyright ownership.  The ASF licenses this file
--  to you under the Apache License, Version 2.0 (the
--  "License"); you may not use this file except in compliance
--  with the License.  You may obtain a copy of the License at
--
--    https://www.apache.org/licenses/LICENSE-2.0
--
--  Unless required by applicable law or agreed to in writing,
--  software distributed under the License is distributed on an
--  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
--  KIND, either express or implied.  See the License for the
--  specific language governing permissions and limitations
--  under the License.

-- Test Schema for dbimport task test

CREATE TABLE ARTIST (ARTIST_ID BIGINT  NOT NULL, ARTIST_NAME CHAR (254) NOT NULL, DATE_OF_BIRTH DATE , PRIMARY KEY (ARTIST_ID));
CREATE TABLE NULL_TEST (ID INTEGER  NOT NULL GENERATED BY DEFAULT AS IDENTITY, NAME VARCHAR (100), PRIMARY KEY (ID));
CREATE TABLE ARTIST_CT (ARTIST_ID INTEGER  NOT NULL, ARTIST_NAME CHAR (254) NOT NULL, DATE_OF_BIRTH DATE , PRIMARY KEY (ARTIST_ID));
CREATE TABLE GENERATED_COLUMN (GENERATED_COLUMN INTEGER  NOT NULL GENERATED BY DEFAULT AS IDENTITY, NAME VARCHAR (250), PRIMARY KEY (GENERATED_COLUMN));
CREATE TABLE GALLERY (GALLERY_ID INTEGER  NOT NULL, GALLERY_NAME VARCHAR (100) NOT NULL, PRIMARY KEY (GALLERY_ID));
CREATE TABLE PAINTING1 (ARTIST_ID BIGINT , ESTIMATED_PRICE DECIMAL (10, 2), GALLERY_ID INTEGER , PAINTING_ID INTEGER  NOT NULL, PAINTING_TITLE VARCHAR (255) NOT NULL, PRIMARY KEY (PAINTING_ID));
CREATE TABLE ARTGROUP (GROUP_ID INTEGER  NOT NULL, NAME VARCHAR (100) NOT NULL, PARENT_GROUP_ID INTEGER , PRIMARY KEY (GROUP_ID));
CREATE TABLE EXHIBIT (CLOSING_DATE TIMESTAMP  NOT NULL, EXHIBIT_ID INTEGER  NOT NULL, GALLERY_ID INTEGER  NOT NULL, OPENING_DATE TIMESTAMP  NOT NULL, PRIMARY KEY (EXHIBIT_ID));
CREATE TABLE ARTIST_GROUP (ARTIST_ID BIGINT  NOT NULL, GROUP_ID INTEGER  NOT NULL, PRIMARY KEY (ARTIST_ID, GROUP_ID));
CREATE TABLE PAINTING (ARTIST_ID BIGINT , ESTIMATED_PRICE DECIMAL (10, 2), GALLERY_ID INTEGER , PAINTING_DESCRIPTION VARCHAR (255), PAINTING_ID INTEGER  NOT NULL, PAINTING_TITLE VARCHAR (255) NOT NULL, PRIMARY KEY (PAINTING_ID));
CREATE TABLE ARTIST_EXHIBIT (ARTIST_ID BIGINT  NOT NULL, EXHIBIT_ID INTEGER  NOT NULL, PRIMARY KEY (ARTIST_ID, EXHIBIT_ID));
CREATE TABLE PAINTING_INFO (IMAGE_BLOB LONG VARCHAR FOR BIT DATA , PAINTING_ID INTEGER  NOT NULL, TEXT_REVIEW LONG VARCHAR , PRIMARY KEY (PAINTING_ID));

ALTER TABLE PAINTING1 ADD FOREIGN KEY (ARTIST_ID) REFERENCES ARTIST (ARTIST_ID);
ALTER TABLE ARTGROUP ADD FOREIGN KEY (PARENT_GROUP_ID) REFERENCES ARTGROUP (GROUP_ID);
ALTER TABLE EXHIBIT ADD FOREIGN KEY (GALLERY_ID) REFERENCES GALLERY (GALLERY_ID);
ALTER TABLE ARTIST_GROUP ADD FOREIGN KEY (ARTIST_ID) REFERENCES ARTIST (ARTIST_ID);
ALTER TABLE ARTIST_GROUP ADD FOREIGN KEY (GROUP_ID) REFERENCES ARTGROUP (GROUP_ID);
ALTER TABLE PAINTING ADD FOREIGN KEY (ARTIST_ID) REFERENCES ARTIST (ARTIST_ID);
ALTER TABLE PAINTING ADD FOREIGN KEY (GALLERY_ID) REFERENCES GALLERY (GALLERY_ID);
ALTER TABLE ARTIST_EXHIBIT ADD FOREIGN KEY (ARTIST_ID) REFERENCES ARTIST (ARTIST_ID);
ALTER TABLE ARTIST_EXHIBIT ADD FOREIGN KEY (EXHIBIT_ID) REFERENCES EXHIBIT (EXHIBIT_ID);
ALTER TABLE PAINTING_INFO ADD FOREIGN KEY (PAINTING_ID) REFERENCES PAINTING (PAINTING_ID);

CREATE SEQUENCE PK_ARTGROUP AS BIGINT START WITH 200 INCREMENT BY 20 NO MAXVALUE NO CYCLE;
CREATE SEQUENCE PK_ARTIST AS BIGINT START WITH 200 INCREMENT BY 20 NO MAXVALUE NO CYCLE;
CREATE SEQUENCE PK_ARTIST_CT AS BIGINT START WITH 200 INCREMENT BY 20 NO MAXVALUE NO CYCLE;
CREATE SEQUENCE PK_ARTIST_GROUP AS BIGINT START WITH 200 INCREMENT BY 20 NO MAXVALUE NO CYCLE;
CREATE SEQUENCE PK_EXHIBIT AS BIGINT START WITH 200 INCREMENT BY 20 NO MAXVALUE NO CYCLE;
CREATE SEQUENCE PK_GALLERY AS BIGINT START WITH 200 INCREMENT BY 20 NO MAXVALUE NO CYCLE;
CREATE SEQUENCE PK_GENERATED_COLUMN AS BIGINT START WITH 200 INCREMENT BY 20 NO MAXVALUE NO CYCLE;
CREATE SEQUENCE PK_NULL_TEST AS BIGINT START WITH 200 INCREMENT BY 20 NO MAXVALUE NO CYCLE;
CREATE SEQUENCE PK_PAINTING AS BIGINT START WITH 200 INCREMENT BY 20 NO MAXVALUE NO CYCLE;
CREATE SEQUENCE PK_PAINTING1 AS BIGINT START WITH 200 INCREMENT BY 20 NO MAXVALUE NO CYCLE;