/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.http.HttpComponent;

/**
 * Send requests to external HTTP servers using Apache HTTP Client 5.x.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface HttpsComponentBuilderFactory {

    /**
     * HTTPS (Secure) (camel-http)
     * Send requests to external HTTP servers using Apache HTTP Client 5.x.
     * 
     * Category: http
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-http
     * 
     * @return the dsl builder
     */
    static HttpsComponentBuilder https() {
        return new HttpsComponentBuilderImpl();
    }

    /**
     * Builder for the HTTPS (Secure) component.
     */
    interface HttpsComponentBuilder extends ComponentBuilder<HttpComponent> {
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        
        /**
         * To enable logging HTTP request and response. You can use a custom
         * LoggingHttpActivityListener as httpActivityListener to control
         * logging options.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param logHttpActivity the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder logHttpActivity(boolean logHttpActivity) {
            doSetProperty("logHttpActivity", logHttpActivity);
            return this;
        }
    
        
        /**
         * Whether to skip mapping all the Camel headers as HTTP request
         * headers. If there are no data from Camel headers needed to be
         * included in the HTTP request then this can avoid parsing overhead
         * with many object allocations for the JVM garbage collector.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param skipRequestHeaders the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder skipRequestHeaders(boolean skipRequestHeaders) {
            doSetProperty("skipRequestHeaders", skipRequestHeaders);
            return this;
        }
    
        
        /**
         * Whether to skip mapping all the HTTP response headers to Camel
         * headers. If there are no data needed from HTTP headers then this can
         * avoid parsing overhead with many object allocations for the JVM
         * garbage collector.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param skipResponseHeaders the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder skipResponseHeaders(boolean skipResponseHeaders) {
            doSetProperty("skipResponseHeaders", skipResponseHeaders);
            return this;
        }
    
        /**
         * To use a custom org.apache.hc.client5.http.cookie.CookieStore. By
         * default the org.apache.hc.client5.http.cookie.BasicCookieStore is
         * used which is an in-memory only cookie store. Notice if
         * bridgeEndpoint=true then the cookie store is forced to be a noop
         * cookie store as cookie shouldn't be stored as we are just bridging
         * (eg acting as a proxy).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.hc.client5.http.cookie.CookieStore&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param cookieStore the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder cookieStore(org.apache.hc.client5.http.cookie.CookieStore cookieStore) {
            doSetProperty("cookieStore", cookieStore);
            return this;
        }
    
        
        /**
         * If this option is true then IN exchange headers will be copied to OUT
         * exchange headers according to copy strategy. Setting this to false,
         * allows to only include the headers from the HTTP response (not
         * propagating IN headers).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param copyHeaders the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder copyHeaders(boolean copyHeaders) {
            doSetProperty("copyHeaders", copyHeaders);
            return this;
        }
    
        
        /**
         * Whether to the HTTP request should follow redirects. By default the
         * HTTP request does not follow redirects.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param followRedirects the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder followRedirects(boolean followRedirects) {
            doSetProperty("followRedirects", followRedirects);
            return this;
        }
    
        /**
         * To use a custom activity listener.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.http.HttpActivityListener&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param httpActivityListener the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder httpActivityListener(org.apache.camel.component.http.HttpActivityListener httpActivityListener) {
            doSetProperty("httpActivityListener", httpActivityListener);
            return this;
        }
    
        
        /**
         * This threshold in bytes controls whether the response payload should
         * be stored in memory as a byte array or be streaming based. Set this
         * to -1 to always use streaming mode.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: producer (advanced)
         * 
         * @param responsePayloadStreamingThreshold the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder responsePayloadStreamingThreshold(int responsePayloadStreamingThreshold) {
            doSetProperty("responsePayloadStreamingThreshold", responsePayloadStreamingThreshold);
            return this;
        }
    
        /**
         * To set a custom HTTP User-Agent request header.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param userAgent the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder userAgent(java.lang.String userAgent) {
            doSetProperty("userAgent", userAgent);
            return this;
        }
    
        
        /**
         * Whether to allow java serialization when a request uses
         * context-type=application/x-java-serialized-object. This is by default
         * turned off. If you enable this then be aware that Java will
         * deserialize the incoming data from the request to Java and that can
         * be a potential security risk.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowJavaSerializedObject the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder allowJavaSerializedObject(boolean allowJavaSerializedObject) {
            doSetProperty("allowJavaSerializedObject", allowJavaSerializedObject);
            return this;
        }
    
        
        /**
         * Disables authentication scheme caching.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param authCachingDisabled the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder authCachingDisabled(boolean authCachingDisabled) {
            doSetProperty("authCachingDisabled", authCachingDisabled);
            return this;
        }
    
        
        /**
         * Disables automatic request recovery and re-execution.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param automaticRetriesDisabled the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder automaticRetriesDisabled(boolean automaticRetriesDisabled) {
            doSetProperty("automaticRetriesDisabled", automaticRetriesDisabled);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        /**
         * To use a custom and shared HttpClientConnectionManager to manage
         * connections. If this has been configured then this is always used for
         * all endpoints created by this component.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.hc.client5.http.io.HttpClientConnectionManager&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param clientConnectionManager the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder clientConnectionManager(org.apache.hc.client5.http.io.HttpClientConnectionManager clientConnectionManager) {
            doSetProperty("clientConnectionManager", clientConnectionManager);
            return this;
        }
    
        
        /**
         * The maximum number of connections per route.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 20
         * Group: advanced
         * 
         * @param connectionsPerRoute the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder connectionsPerRoute(int connectionsPerRoute) {
            doSetProperty("connectionsPerRoute", connectionsPerRoute);
            return this;
        }
    
        
        /**
         * Disables connection state tracking.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param connectionStateDisabled the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder connectionStateDisabled(boolean connectionStateDisabled) {
            doSetProperty("connectionStateDisabled", connectionStateDisabled);
            return this;
        }
    
        /**
         * The time for connection to live, the time unit is millisecond, the
         * default value is always keepAlive.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param connectionTimeToLive the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder connectionTimeToLive(long connectionTimeToLive) {
            doSetProperty("connectionTimeToLive", connectionTimeToLive);
            return this;
        }
    
        
        /**
         * Disables automatic content decompression.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param contentCompressionDisabled the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder contentCompressionDisabled(boolean contentCompressionDisabled) {
            doSetProperty("contentCompressionDisabled", contentCompressionDisabled);
            return this;
        }
    
        
        /**
         * Disables state (cookie) management.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param cookieManagementDisabled the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder cookieManagementDisabled(boolean cookieManagementDisabled) {
            doSetProperty("cookieManagementDisabled", cookieManagementDisabled);
            return this;
        }
    
        
        /**
         * Disables the default user agent set by this builder if none has been
         * provided by the user.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param defaultUserAgentDisabled the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder defaultUserAgentDisabled(boolean defaultUserAgentDisabled) {
            doSetProperty("defaultUserAgentDisabled", defaultUserAgentDisabled);
            return this;
        }
    
        /**
         * To use a custom HttpBinding to control the mapping between Camel
         * message and HttpClient.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.http.common.HttpBinding&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param httpBinding the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder httpBinding(org.apache.camel.http.common.HttpBinding httpBinding) {
            doSetProperty("httpBinding", httpBinding);
            return this;
        }
    
        /**
         * To use the custom HttpClientConfigurer to perform configuration of
         * the HttpClient that will be used.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.http.HttpClientConfigurer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpClientConfigurer the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder httpClientConfigurer(org.apache.camel.component.http.HttpClientConfigurer httpClientConfigurer) {
            doSetProperty("httpClientConfigurer", httpClientConfigurer);
            return this;
        }
    
        /**
         * To use the shared HttpConfiguration as base configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.http.common.HttpConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpConfiguration the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder httpConfiguration(org.apache.camel.http.common.HttpConfiguration httpConfiguration) {
            doSetProperty("httpConfiguration", httpConfiguration);
            return this;
        }
    
        /**
         * To use a custom org.apache.hc.core5.http.protocol.HttpContext when
         * executing requests.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.hc.core5.http.protocol.HttpContext&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpContext the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder httpContext(org.apache.hc.core5.http.protocol.HttpContext httpContext) {
            doSetProperty("httpContext", httpContext);
            return this;
        }
    
        
        /**
         * The maximum number of connections.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 200
         * Group: advanced
         * 
         * @param maxTotalConnections the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder maxTotalConnections(int maxTotalConnections) {
            doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }
    
        
        /**
         * Disables automatic redirect handling.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param redirectHandlingDisabled the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder redirectHandlingDisabled(boolean redirectHandlingDisabled) {
            doSetProperty("redirectHandlingDisabled", redirectHandlingDisabled);
            return this;
        }
    
        
        /**
         * To use System Properties as fallback for configuration for
         * configuring HTTP Client.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param useSystemProperties the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder useSystemProperties(boolean useSystemProperties) {
            doSetProperty("useSystemProperties", useSystemProperties);
            return this;
        }
    
        /**
         * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
         * header to and from Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: filter
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder headerFilterStrategy(org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
    
        /**
         * Proxy authentication domain to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyAuthDomain the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder proxyAuthDomain(java.lang.String proxyAuthDomain) {
            doSetProperty("proxyAuthDomain", proxyAuthDomain);
            return this;
        }
    
        /**
         * Proxy authentication host.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyAuthHost the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder proxyAuthHost(java.lang.String proxyAuthHost) {
            doSetProperty("proxyAuthHost", proxyAuthHost);
            return this;
        }
    
        /**
         * Proxy authentication method to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyAuthMethod the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder proxyAuthMethod(java.lang.String proxyAuthMethod) {
            doSetProperty("proxyAuthMethod", proxyAuthMethod);
            return this;
        }
    
        /**
         * Proxy authentication domain (workstation name) to use with NTML.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyAuthNtHost the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder proxyAuthNtHost(java.lang.String proxyAuthNtHost) {
            doSetProperty("proxyAuthNtHost", proxyAuthNtHost);
            return this;
        }
    
        /**
         * Proxy authentication password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyAuthPassword the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder proxyAuthPassword(java.lang.String proxyAuthPassword) {
            doSetProperty("proxyAuthPassword", proxyAuthPassword);
            return this;
        }
    
        /**
         * Proxy authentication port.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyAuthPort the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder proxyAuthPort(java.lang.Integer proxyAuthPort) {
            doSetProperty("proxyAuthPort", proxyAuthPort);
            return this;
        }
    
        /**
         * Proxy authentication protocol scheme.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyAuthScheme the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder proxyAuthScheme(java.lang.String proxyAuthScheme) {
            doSetProperty("proxyAuthScheme", proxyAuthScheme);
            return this;
        }
    
        /**
         * Proxy authentication username.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyAuthUsername the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder proxyAuthUsername(java.lang.String proxyAuthUsername) {
            doSetProperty("proxyAuthUsername", proxyAuthUsername);
            return this;
        }
    
        /**
         * To configure security using SSLContextParameters. Important: Only one
         * instance of org.apache.camel.support.jsse.SSLContextParameters is
         * supported per HttpComponent. If you need to use 2 or more different
         * instances, you need to define a new HttpComponent per instance you
         * need.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder sslContextParameters(org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    
        
        /**
         * Enable usage of global SSL context parameters.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useGlobalSslContextParameters the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    
        /**
         * To use a custom X509HostnameVerifier such as DefaultHostnameVerifier
         * or NoopHostnameVerifier.
         * 
         * The option is a:
         * &lt;code&gt;javax.net.ssl.HostnameVerifier&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param x509HostnameVerifier the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder x509HostnameVerifier(javax.net.ssl.HostnameVerifier x509HostnameVerifier) {
            doSetProperty("x509HostnameVerifier", x509HostnameVerifier);
            return this;
        }
    
        
        /**
         * Returns the connection lease request timeout used when requesting a
         * connection from the connection manager. A timeout value of zero is
         * interpreted as a disabled timeout.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.hc.core5.util.Timeout&lt;/code&gt; type.
         * 
         * Default: 3 minutes
         * Group: timeout
         * 
         * @param connectionRequestTimeout the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder connectionRequestTimeout(org.apache.hc.core5.util.Timeout connectionRequestTimeout) {
            doSetProperty("connectionRequestTimeout", connectionRequestTimeout);
            return this;
        }
    
        
        /**
         * Determines the timeout until a new connection is fully established. A
         * timeout value of zero is interpreted as an infinite timeout.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.hc.core5.util.Timeout&lt;/code&gt; type.
         * 
         * Default: 3 minutes
         * Group: timeout
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder connectTimeout(org.apache.hc.core5.util.Timeout connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
    
        
        /**
         * Determines the timeout until arrival of a response from the opposite
         * endpoint. A timeout value of zero is interpreted as an infinite
         * timeout. Please note that response timeout may be unsupported by HTTP
         * transports with message multiplexing.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.hc.core5.util.Timeout&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: timeout
         * 
         * @param responseTimeout the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder responseTimeout(org.apache.hc.core5.util.Timeout responseTimeout) {
            doSetProperty("responseTimeout", responseTimeout);
            return this;
        }
    
        
        /**
         * Determines the default socket timeout value for blocking I/O
         * operations.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.hc.core5.util.Timeout&lt;/code&gt; type.
         * 
         * Default: 3 minutes
         * Group: timeout
         * 
         * @param soTimeout the value to set
         * @return the dsl builder
         */
        default HttpsComponentBuilder soTimeout(org.apache.hc.core5.util.Timeout soTimeout) {
            doSetProperty("soTimeout", soTimeout);
            return this;
        }
    }

    class HttpsComponentBuilderImpl
            extends AbstractComponentBuilder<HttpComponent>
            implements HttpsComponentBuilder {
        @Override
        protected HttpComponent buildConcreteComponent() {
            return new HttpComponent();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "lazyStartProducer": ((HttpComponent) component).setLazyStartProducer((boolean) value); return true;
            case "logHttpActivity": ((HttpComponent) component).setLogHttpActivity((boolean) value); return true;
            case "skipRequestHeaders": ((HttpComponent) component).setSkipRequestHeaders((boolean) value); return true;
            case "skipResponseHeaders": ((HttpComponent) component).setSkipResponseHeaders((boolean) value); return true;
            case "cookieStore": ((HttpComponent) component).setCookieStore((org.apache.hc.client5.http.cookie.CookieStore) value); return true;
            case "copyHeaders": ((HttpComponent) component).setCopyHeaders((boolean) value); return true;
            case "followRedirects": ((HttpComponent) component).setFollowRedirects((boolean) value); return true;
            case "httpActivityListener": ((HttpComponent) component).setHttpActivityListener((org.apache.camel.component.http.HttpActivityListener) value); return true;
            case "responsePayloadStreamingThreshold": ((HttpComponent) component).setResponsePayloadStreamingThreshold((int) value); return true;
            case "userAgent": ((HttpComponent) component).setUserAgent((java.lang.String) value); return true;
            case "allowJavaSerializedObject": ((HttpComponent) component).setAllowJavaSerializedObject((boolean) value); return true;
            case "authCachingDisabled": ((HttpComponent) component).setAuthCachingDisabled((boolean) value); return true;
            case "automaticRetriesDisabled": ((HttpComponent) component).setAutomaticRetriesDisabled((boolean) value); return true;
            case "autowiredEnabled": ((HttpComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "clientConnectionManager": ((HttpComponent) component).setClientConnectionManager((org.apache.hc.client5.http.io.HttpClientConnectionManager) value); return true;
            case "connectionsPerRoute": ((HttpComponent) component).setConnectionsPerRoute((int) value); return true;
            case "connectionStateDisabled": ((HttpComponent) component).setConnectionStateDisabled((boolean) value); return true;
            case "connectionTimeToLive": ((HttpComponent) component).setConnectionTimeToLive((long) value); return true;
            case "contentCompressionDisabled": ((HttpComponent) component).setContentCompressionDisabled((boolean) value); return true;
            case "cookieManagementDisabled": ((HttpComponent) component).setCookieManagementDisabled((boolean) value); return true;
            case "defaultUserAgentDisabled": ((HttpComponent) component).setDefaultUserAgentDisabled((boolean) value); return true;
            case "httpBinding": ((HttpComponent) component).setHttpBinding((org.apache.camel.http.common.HttpBinding) value); return true;
            case "httpClientConfigurer": ((HttpComponent) component).setHttpClientConfigurer((org.apache.camel.component.http.HttpClientConfigurer) value); return true;
            case "httpConfiguration": ((HttpComponent) component).setHttpConfiguration((org.apache.camel.http.common.HttpConfiguration) value); return true;
            case "httpContext": ((HttpComponent) component).setHttpContext((org.apache.hc.core5.http.protocol.HttpContext) value); return true;
            case "maxTotalConnections": ((HttpComponent) component).setMaxTotalConnections((int) value); return true;
            case "redirectHandlingDisabled": ((HttpComponent) component).setRedirectHandlingDisabled((boolean) value); return true;
            case "useSystemProperties": ((HttpComponent) component).setUseSystemProperties((boolean) value); return true;
            case "headerFilterStrategy": ((HttpComponent) component).setHeaderFilterStrategy((org.apache.camel.spi.HeaderFilterStrategy) value); return true;
            case "proxyAuthDomain": ((HttpComponent) component).setProxyAuthDomain((java.lang.String) value); return true;
            case "proxyAuthHost": ((HttpComponent) component).setProxyAuthHost((java.lang.String) value); return true;
            case "proxyAuthMethod": ((HttpComponent) component).setProxyAuthMethod((java.lang.String) value); return true;
            case "proxyAuthNtHost": ((HttpComponent) component).setProxyAuthNtHost((java.lang.String) value); return true;
            case "proxyAuthPassword": ((HttpComponent) component).setProxyAuthPassword((java.lang.String) value); return true;
            case "proxyAuthPort": ((HttpComponent) component).setProxyAuthPort((java.lang.Integer) value); return true;
            case "proxyAuthScheme": ((HttpComponent) component).setProxyAuthScheme((java.lang.String) value); return true;
            case "proxyAuthUsername": ((HttpComponent) component).setProxyAuthUsername((java.lang.String) value); return true;
            case "sslContextParameters": ((HttpComponent) component).setSslContextParameters((org.apache.camel.support.jsse.SSLContextParameters) value); return true;
            case "useGlobalSslContextParameters": ((HttpComponent) component).setUseGlobalSslContextParameters((boolean) value); return true;
            case "x509HostnameVerifier": ((HttpComponent) component).setX509HostnameVerifier((javax.net.ssl.HostnameVerifier) value); return true;
            case "connectionRequestTimeout": ((HttpComponent) component).setConnectionRequestTimeout((org.apache.hc.core5.util.Timeout) value); return true;
            case "connectTimeout": ((HttpComponent) component).setConnectTimeout((org.apache.hc.core5.util.Timeout) value); return true;
            case "responseTimeout": ((HttpComponent) component).setResponseTimeout((org.apache.hc.core5.util.Timeout) value); return true;
            case "soTimeout": ((HttpComponent) component).setSoTimeout((org.apache.hc.core5.util.Timeout) value); return true;
            default: return false;
            }
        }
    }
}